/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.hierarchy.HierarchyBrowserBaseEx;
import com.intellij.ide.hierarchy.HierarchyBrowserManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.util.IconLoader;
import com.intellij.psi.PsiElement;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.plaf.LabelUI;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class MethodHierarchyBrowserBase
extends HierarchyBrowserBaseEx {
    public static final String METHOD_TYPE = IdeBundle.message((String)"title.hierarchy.method", (Object[])new Object[0]);
    public static final DataKey<MethodHierarchyBrowserBase> DATA_KEY = DataKey.create((String)"com.intellij.ide.hierarchy.MethodHierarchyBrowserBase");
    @Deprecated
    @NonNls
    public static final String METHOD_HIERARCHY_BROWSER_DATA_KEY = DATA_KEY.getName();

    public MethodHierarchyBrowserBase(Project project, PsiElement method) {
        super(project, method);
    }

    @Override
    @NotNull
    protected String getPrevOccurenceActionNameImpl() {
        String string = IdeBundle.message((String)"hierarchy.method.prev.occurence.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/hierarchy/MethodHierarchyBrowserBase.getPrevOccurenceActionNameImpl must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String getNextOccurenceActionNameImpl() {
        String string = IdeBundle.message((String)"hierarchy.method.next.occurence.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/hierarchy/MethodHierarchyBrowserBase.getNextOccurenceActionNameImpl must not return null");
        }
        return string;
    }

    protected static JPanel createStandardLegendPanel(String methodDefinedText, String methodNotDefinedLegallyText, String methodShouldBeDefined) {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 5, 0, 5), 0, 0);
        JLabel label = new JLabel(methodDefinedText, IconLoader.getIcon((String)"/hierarchy/methodDefined.png"), 2);
        label.setUI((LabelUI)new MultiLineLabelUI());
        label.setIconTextGap(10);
        panel.add((Component)label, gc);
        ++gc.gridy;
        label = new JLabel(methodNotDefinedLegallyText, IconLoader.getIcon((String)"/hierarchy/methodNotDefined.png"), 2);
        label.setUI((LabelUI)new MultiLineLabelUI());
        label.setIconTextGap(10);
        panel.add((Component)label, gc);
        ++gc.gridy;
        label = new JLabel(methodShouldBeDefined, IconLoader.getIcon((String)"/hierarchy/shouldDefineMethod.png"), 2);
        label.setUI((LabelUI)new MultiLineLabelUI());
        label.setIconTextGap(10);
        panel.add((Component)label, gc);
        return panel;
    }

    @Override
    protected void prependActions(@NotNull DefaultActionGroup actionGroup) {
        if (actionGroup == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/hierarchy/MethodHierarchyBrowserBase.prependActions must not be null");
        }
        actionGroup.add((AnAction)new HierarchyBrowserBaseEx.AlphaSortAction());
        actionGroup.add((AnAction)new ShowImplementationsOnlyAction());
    }

    @Override
    @NotNull
    protected String getBrowserDataKey() {
        String string = DATA_KEY.getName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/hierarchy/MethodHierarchyBrowserBase.getBrowserDataKey must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    protected String getActionPlace() {
        if ("MethodHierarchyViewToolbar" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/hierarchy/MethodHierarchyBrowserBase.getActionPlace must not return null");
        }
        return "MethodHierarchyViewToolbar";
    }

    public static class BaseOnThisMethodAction
    extends HierarchyBrowserBaseEx.BaseOnThisElementAction {
        public BaseOnThisMethodAction() {
            super(IdeBundle.message((String)"action.base.on.this.method", (Object[])new Object[0]), "MethodHierarchy", DATA_KEY.getName());
        }
    }

    final class ShowImplementationsOnlyAction
    extends ToggleAction {
        public ShowImplementationsOnlyAction() {
            super(IdeBundle.message((String)"action.hide.non.implementations", (Object[])new Object[0]), null, IconLoader.getIcon((String)"/ant/filter.png"));
        }

        public final boolean isSelected(AnActionEvent event) {
            return HierarchyBrowserManager.getInstance((Project)MethodHierarchyBrowserBase.this.myProject).getState().HIDE_CLASSES_WHERE_METHOD_NOT_IMPLEMENTED;
        }

        public final void setSelected(AnActionEvent event, boolean flag) {
            HierarchyBrowserManager.getInstance((Project)MethodHierarchyBrowserBase.this.myProject).getState().HIDE_CLASSES_WHERE_METHOD_NOT_IMPLEMENTED = flag;
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    MethodHierarchyBrowserBase.this.doRefresh(true);
                }
            });
        }

        public final void update(AnActionEvent event) {
            super.update(event);
            Presentation presentation = event.getPresentation();
            presentation.setEnabled(MethodHierarchyBrowserBase.this.isValidBase());
        }
    }
}

