/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.highlighter.custom;

import com.intellij.ide.highlighter.custom.tokens.TokenInfo;
import com.intellij.ide.highlighter.custom.tokens.TokenParser;
import com.intellij.lexer.LexerBase;
import com.intellij.psi.CustomHighlighterTokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;

public abstract class AbstractCustomLexer
extends LexerBase {
    protected CharSequence myBuffer = ArrayUtil.EMPTY_CHAR_SEQUENCE;
    protected int myStartOffset = 0;
    protected int myEndOffset = 0;
    private final TokenParser[] myTokenParsers;
    private TokenInfo myCurrentToken;
    private int myPosition;

    public AbstractCustomLexer(TokenParser[] tokenParsers) {
        this.myTokenParsers = tokenParsers;
        int smartUpdateShift = 0;
        for (TokenParser tokenParser : this.myTokenParsers) {
            smartUpdateShift = Math.max(smartUpdateShift, tokenParser.getSmartUpdateShift());
        }
    }

    public void start(CharSequence buffer, int startOffset, int endOffset, int initialState) {
        this.myBuffer = buffer;
        this.myStartOffset = startOffset;
        this.myEndOffset = endOffset;
        this.myPosition = this.myStartOffset;
        this.myCurrentToken = new TokenInfo();
        for (TokenParser tokenParser : this.myTokenParsers) {
            tokenParser.setBuffer(this.myBuffer, this.myStartOffset, this.myEndOffset);
        }
        this.advance();
    }

    public int getState() {
        return 0;
    }

    public IElementType getTokenType() {
        return this.myCurrentToken.getType();
    }

    public int getTokenStart() {
        return this.myCurrentToken.getStart();
    }

    public int getTokenEnd() {
        return this.myCurrentToken.getEnd();
    }

    public void advance() {
        if (this.myPosition >= this.myEndOffset) {
            this.myCurrentToken.updateData(this.myPosition, this.myPosition, null);
            return;
        }
        boolean tokenFound = false;
        for (TokenParser tokenParser : this.myTokenParsers) {
            if (!tokenParser.hasToken(this.myPosition)) continue;
            tokenParser.getTokenInfo(this.myCurrentToken);
            tokenFound = true;
            break;
        }
        if (!tokenFound) {
            this.myCurrentToken.updateData(this.myPosition, this.myPosition + 1, CustomHighlighterTokenType.CHARACTER);
        }
        this.myPosition = this.myCurrentToken.getEnd();
    }

    public CharSequence getBufferSequence() {
        return this.myBuffer;
    }

    public int getBufferEnd() {
        return this.myEndOffset;
    }
}

