/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerColumnInfo;
import com.intellij.ide.plugins.PluginNode;
import com.intellij.ide.plugins.PluginTableModel;
import com.intellij.ide.plugins.SortableProvider;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.BooleanTableCellEditor;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.util.Function;
import com.intellij.util.ui.ColumnInfo;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstalledPluginsTableModel
extends PluginTableModel {
    public static Map<PluginId, Integer> NewVersions2Plugins = new HashMap<PluginId, Integer>();
    public static Set<PluginId> updatedPlugins = new HashSet<PluginId>();
    private final Map<PluginId, Boolean> myEnabled = new HashMap<PluginId, Boolean>();

    public InstalledPluginsTableModel(SortableProvider sortableProvider) {
        this.sortableProvider = sortableProvider;
        this.columns = new ColumnInfo[]{new EnabledPluginInfo(), new NameColumnInfo(), new BundledColumnInfo()};
        this.view = new ArrayList<IdeaPluginDescriptor>(Arrays.asList(PluginManager.getPlugins()));
        this.reset(this.view);
        Iterator iterator = this.view.iterator();
        while (iterator.hasNext()) {
            String s = ((IdeaPluginDescriptor)iterator.next()).getPluginId().getIdString();
            if (!"com.intellij".equals(s)) continue;
            iterator.remove();
        }
        this.sortByColumn(this.getNameColumn());
    }

    public static int getCheckboxColumn() {
        return 0;
    }

    @Override
    public int getNameColumn() {
        return 1;
    }

    @Override
    public void addData(List<IdeaPluginDescriptor> list) {
        this.modifyData(list);
        this.reset(Arrays.asList(PluginManager.getPlugins()));
    }

    private void reset(List<IdeaPluginDescriptor> list) {
        for (IdeaPluginDescriptor ideaPluginDescriptor : list) {
            if (!(ideaPluginDescriptor instanceof IdeaPluginDescriptorImpl)) continue;
            this.myEnabled.put(ideaPluginDescriptor.getPluginId(), ((IdeaPluginDescriptorImpl)ideaPluginDescriptor).isEnabled());
        }
    }

    @Override
    public void modifyData(List<IdeaPluginDescriptor> list) {
        for (IdeaPluginDescriptor descr : list) {
            PluginId descrId = descr.getPluginId();
            IdeaPluginDescriptor existing = PluginManager.getPlugin((PluginId)descrId);
            if (existing == null) continue;
            if (descr instanceof PluginNode) {
                InstalledPluginsTableModel.updateExistingPluginInfo(descr, existing);
                continue;
            }
            this.view.add(descr);
            this.myEnabled.put(descr.getPluginId(), ((IdeaPluginDescriptorImpl)descr).isEnabled());
        }
        this.safeSort();
    }

    @Override
    public void filter(ArrayList<IdeaPluginDescriptor> filtered) {
        this.view.clear();
        for (IdeaPluginDescriptor descriptor : filtered) {
            if (PluginManager.getPlugin((PluginId)descriptor.getPluginId()) == null) continue;
            this.view.add(descriptor);
        }
        super.filter(filtered);
    }

    private static void updateExistingPluginInfo(IdeaPluginDescriptor descr, IdeaPluginDescriptor existing) {
        int state = StringUtil.compareVersionNumbers((String)descr.getVersion(), (String)existing.getVersion());
        if (state > 0 && !PluginManager.isIncompatible((IdeaPluginDescriptor)descr)) {
            NewVersions2Plugins.put(existing.getPluginId(), 1);
            IdeaPluginDescriptorImpl plugin = (IdeaPluginDescriptorImpl)existing;
            plugin.setDownloadsCount(descr.getDownloads());
            plugin.setVendor(descr.getVendor());
            plugin.setVendorEmail(descr.getVendorEmail());
            plugin.setVendorUrl(descr.getVendorUrl());
            plugin.setUrl(descr.getUrl());
        } else if (NewVersions2Plugins.remove(existing.getPluginId()) != null) {
            updatedPlugins.add(existing.getPluginId());
        }
    }

    public static boolean hasNewerVersion(PluginId descr) {
        return NewVersions2Plugins.containsKey(descr);
    }

    public static boolean wasUpdated(PluginId descr) {
        return updatedPlugins.contains(descr);
    }

    public boolean isEnabled(PluginId pluginId) {
        Boolean enabled = this.myEnabled.get(pluginId);
        return enabled != null && enabled != false;
    }

    public Map<PluginId, Boolean> getEnabledMap() {
        return this.myEnabled;
    }

    private class NameColumnInfo
    extends PluginManagerColumnInfo {
        public NameColumnInfo() {
            super(0, InstalledPluginsTableModel.this.sortableProvider);
        }

        @Override
        public TableCellRenderer getRenderer(IdeaPluginDescriptor ideaPluginDescriptor) {
            final DefaultTableCellRenderer cellRenderer = (DefaultTableCellRenderer)super.getRenderer(ideaPluginDescriptor);
            if (cellRenderer != null && ideaPluginDescriptor != null) {
                IdeaPluginDescriptorImpl descriptor = (IdeaPluginDescriptorImpl)ideaPluginDescriptor;
                if (descriptor.isDeleted()) {
                    cellRenderer.setIcon(IconLoader.getIcon((String)"/actions/clean.png"));
                } else if (InstalledPluginsTableModel.hasNewerVersion(ideaPluginDescriptor.getPluginId())) {
                    cellRenderer.setIcon(IconLoader.getIcon((String)"/nodes/pluginobsolete.png"));
                } else {
                    cellRenderer.setIcon(IconLoader.getIcon((String)"/nodes/plugin.png"));
                }
                Boolean enabled = (Boolean)InstalledPluginsTableModel.this.myEnabled.get(ideaPluginDescriptor.getPluginId());
                if (enabled != null && enabled.booleanValue()) {
                    PluginManager.checkDependants((IdeaPluginDescriptor)ideaPluginDescriptor, (Function)new Function<PluginId, IdeaPluginDescriptor>(){

                        @Nullable
                        public IdeaPluginDescriptor fun(PluginId pluginId) {
                            return PluginManager.getPlugin((PluginId)pluginId);
                        }
                    }, (Condition)new Condition<PluginId>(){

                        public boolean value(PluginId pluginId) {
                            Boolean enabled = (Boolean)InstalledPluginsTableModel.this.myEnabled.get(pluginId);
                            if (enabled == null || !enabled.booleanValue()) {
                                cellRenderer.setForeground(Color.red);
                                IdeaPluginDescriptor plugin = PluginManager.getPlugin((PluginId)pluginId);
                                cellRenderer.setToolTipText(IdeBundle.message((String)"plugin.manager.tooltip.warning", (Object[])new Object[]{plugin != null ? plugin.getName() : pluginId.getIdString()}));
                                return false;
                            }
                            return true;
                        }
                    });
                }
                if (PluginManager.isIncompatible((IdeaPluginDescriptor)ideaPluginDescriptor)) {
                    cellRenderer.setToolTipText(IdeBundle.message((String)"plugin.manager.incompatible.tooltip.warning", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()}));
                    cellRenderer.setForeground(Color.red);
                }
            }
            return cellRenderer;
        }
    }

    private static class BundledColumnInfo
    extends ColumnInfo<IdeaPluginDescriptor, Boolean> {
        public BundledColumnInfo() {
            super("Bundled");
        }

        @NotNull
        public Boolean valueOf(IdeaPluginDescriptor ideaPluginDescriptor) {
            Boolean bl = ideaPluginDescriptor.isBundled();
            if (bl == null) {
                throw new IllegalStateException("@NotNull method com/intellij/ide/plugins/InstalledPluginsTableModel$BundledColumnInfo.valueOf must not return null");
            }
            return bl;
        }

        public Comparator<IdeaPluginDescriptor> getComparator() {
            return new Comparator<IdeaPluginDescriptor>(){

                @Override
                public int compare(IdeaPluginDescriptor o1, IdeaPluginDescriptor o2) {
                    return BundledColumnInfo.this.valueOf(o1).compareTo(BundledColumnInfo.this.valueOf(o2));
                }
            };
        }

        public TableCellRenderer getRenderer(IdeaPluginDescriptor ideaPluginDescriptor) {
            if (ideaPluginDescriptor.isBundled()) {
                return new BooleanTableCellRenderer(){

                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        JCheckBox checkbox = (JCheckBox)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                        checkbox.setEnabled(false);
                        return checkbox;
                    }
                };
            }
            return new DefaultTableCellRenderer(){

                @Override
                protected void setValue(Object value) {
                    this.setText("");
                }
            };
        }
    }

    private class EnabledPluginInfo
    extends ColumnInfo<IdeaPluginDescriptorImpl, Boolean> {
        public EnabledPluginInfo() {
            super(IdeBundle.message((String)"plugin.manager.enable.column.title", (Object[])new Object[0]));
        }

        public Boolean valueOf(IdeaPluginDescriptorImpl ideaPluginDescriptor) {
            return (Boolean)InstalledPluginsTableModel.this.myEnabled.get(ideaPluginDescriptor.getPluginId());
        }

        public boolean isCellEditable(IdeaPluginDescriptorImpl ideaPluginDescriptor) {
            return true;
        }

        public Class getColumnClass() {
            return Boolean.class;
        }

        public TableCellEditor getEditor(IdeaPluginDescriptorImpl o) {
            return new BooleanTableCellEditor();
        }

        public TableCellRenderer getRenderer(IdeaPluginDescriptorImpl ideaPluginDescriptor) {
            return new BooleanTableCellRenderer();
        }

        public void setValue(IdeaPluginDescriptorImpl ideaPluginDescriptor, Boolean value) {
            InstalledPluginsTableModel.this.myEnabled.put(ideaPluginDescriptor.getPluginId(), value);
            if (value.booleanValue()) {
                final HashSet deps = new HashSet();
                PluginManager.checkDependants((IdeaPluginDescriptor)ideaPluginDescriptor, (Function)new Function<PluginId, IdeaPluginDescriptor>(){

                    @Nullable
                    public IdeaPluginDescriptor fun(PluginId pluginId) {
                        return PluginManager.getPlugin((PluginId)pluginId);
                    }
                }, (Condition)new Condition<PluginId>(){

                    public boolean value(PluginId pluginId) {
                        Boolean enabled = (Boolean)InstalledPluginsTableModel.this.myEnabled.get(pluginId);
                        if (enabled == null) {
                            return false;
                        }
                        if (!enabled.booleanValue()) {
                            deps.add(pluginId);
                        }
                        return true;
                    }
                });
                if (!deps.isEmpty() && Messages.showOkCancelDialog((String)("<html>The following plugins on which this plugin depends are disabled:<br>" + StringUtil.join(deps, (Function)new Function<PluginId, String>(){

                    public String fun(PluginId pluginId) {
                        IdeaPluginDescriptor pluginDescriptor = PluginManager.getPlugin((PluginId)pluginId);
                        assert (pluginDescriptor != null);
                        return pluginDescriptor.getName();
                    }
                }, (String)"<br>") + "<br>Would you like to enable them?</html>"), (String)"Enable Dependant Plugins", (Icon)Messages.getQuestionIcon()) == 0) {
                    for (PluginId pluginId : deps) {
                        InstalledPluginsTableModel.this.myEnabled.put(pluginId, Boolean.TRUE);
                    }
                }
            }
        }

        public Comparator<IdeaPluginDescriptorImpl> getComparator() {
            final boolean sortDirection = InstalledPluginsTableModel.this.sortableProvider.getSortOrder() == 1;
            return new Comparator<IdeaPluginDescriptorImpl>(){

                @Override
                public int compare(IdeaPluginDescriptorImpl o1, IdeaPluginDescriptorImpl o2) {
                    if (o1.isEnabled()) {
                        if (o2.isEnabled()) {
                            return 0;
                        }
                        return sortDirection ? -1 : 1;
                    }
                    if (!o2.isEnabled()) {
                        return 0;
                    }
                    return sortDirection ? 1 : -1;
                }
            };
        }
    }
}

