/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl.java;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.java.JavaClassTreeElement;
import com.intellij.ide.structureView.impl.java.JavaClassTreeElementBase;
import com.intellij.ide.util.treeView.smartTree.SortableTreeElement;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.source.jsp.jspJava.JspHolderMethod;
import com.intellij.psi.util.PsiFormatUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class PsiMethodTreeElement
extends JavaClassTreeElementBase<PsiMethod>
implements SortableTreeElement {
    public PsiMethodTreeElement(PsiMethod method, boolean isInherited) {
        super(isInherited, method);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Collection<StructureViewTreeElement> getChildrenBase() {
        ArrayList<StructureViewTreeElement> arrayList;
        final ArrayList<StructureViewTreeElement> result = new ArrayList<StructureViewTreeElement>();
        PsiMethod element = (PsiMethod)this.getElement();
        if (element == null || element instanceof JspHolderMethod) {
            arrayList = result;
            if (arrayList == null) throw new IllegalStateException("@NotNull method com/intellij/ide/structureView/impl/java/PsiMethodTreeElement.getChildrenBase must not return null");
            return arrayList;
        }
        TextRange range = element.getTextRange();
        if (range == null) {
            arrayList = result;
            if (arrayList == null) throw new IllegalStateException("@NotNull method com/intellij/ide/structureView/impl/java/PsiMethodTreeElement.getChildrenBase must not return null");
            return arrayList;
        }
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null || psiFile instanceof PsiCompiledElement) {
            arrayList = result;
            if (arrayList == null) throw new IllegalStateException("@NotNull method com/intellij/ide/structureView/impl/java/PsiMethodTreeElement.getChildrenBase must not return null");
            return arrayList;
        }
        String fileText = psiFile.getText();
        if (fileText == null) {
            arrayList = result;
            if (arrayList == null) throw new IllegalStateException("@NotNull method com/intellij/ide/structureView/impl/java/PsiMethodTreeElement.getChildrenBase must not return null");
            return arrayList;
        }
        if (!range.substring(fileText).contains("class")) {
            arrayList = result;
            if (arrayList == null) throw new IllegalStateException("@NotNull method com/intellij/ide/structureView/impl/java/PsiMethodTreeElement.getChildrenBase must not return null");
            return arrayList;
        }
        element.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitClass(PsiClass aClass) {
                if (!(aClass instanceof PsiAnonymousClass) && !(aClass instanceof PsiTypeParameter)) {
                    result.add(new JavaClassTreeElement(aClass, PsiMethodTreeElement.this.isInherited()));
                }
            }
        });
        arrayList = result;
        if (arrayList != null) return arrayList;
        throw new IllegalStateException("@NotNull method com/intellij/ide/structureView/impl/java/PsiMethodTreeElement.getChildrenBase must not return null");
    }

    public String getPresentableText() {
        return PsiFormatUtil.formatMethod((PsiMethod)((PsiMethod)this.getElement()), (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)263, (int)2);
    }

    @Override
    public TextAttributesKey getTextAttributesKey() {
        if (this.isInherited()) {
            return CodeInsightColors.NOT_USED_ELEMENT_ATTRIBUTES;
        }
        return super.getTextAttributesKey();
    }

    public PsiMethod getMethod() {
        return (PsiMethod)this.getElement();
    }

    public String getAlphaSortKey() {
        PsiMethod method = (PsiMethod)this.getElement();
        if (method != null) {
            return method.getName();
        }
        return "";
    }
}

