/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ResourceUtil;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.text.MessageFormat;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import org.jetbrains.annotations.NonNls;

public class TipUIUtil {
    @NonNls
    private static final String SHORTCUT_ENTITY = "&shortcut:";
    @NonNls
    public static final String FONT = SystemInfo.isMac ? "Courier" : "Verdana";
    public static final String COLOR = "#993300";
    public static final String SIZE = SystemInfo.isMac ? "4" : "3";
    @NonNls
    public static final String SHORTCUT_HTML_TEMPLATE = "<font  style=\"font-family: " + FONT + "; font-weight:bold;\" size=\"" + SIZE + "\"  color=\"" + "#993300" + "\">{0}</font>";

    private TipUIUtil() {
    }

    public static void openTipInBrowser(String tipPath, JEditorPane browser, Class providerClass) {
        try {
            URL url;
            if (tipPath == null) {
                return;
            }
            if (providerClass == null) {
                providerClass = TipUIUtil.class;
            }
            if ((url = ResourceUtil.getResource(providerClass, (String)"/tips/", (String)tipPath)) == null) {
                TipUIUtil.setCantReadText(browser);
                return;
            }
            StringBuffer text = new StringBuffer(ResourceUtil.loadText((URL)url));
            TipUIUtil.updateShortcuts(text);
            browser.read(new StringReader(text.toString()), null);
            Document document = browser.getDocument();
            if (document instanceof HTMLDocument) {
                ((HTMLDocument)document).setBase(url);
            }
        }
        catch (IOException e) {
            TipUIUtil.setCantReadText(browser);
        }
    }

    private static void setCantReadText(JEditorPane browser) {
        try {
            browser.read(new StringReader(IdeBundle.message((String)"error.unable.to.read.tip.of.the.day", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getFullProductName()})), null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void updateShortcuts(StringBuffer text) {
        int lastIndex = 0;
        while ((lastIndex = text.indexOf(SHORTCUT_ENTITY, lastIndex)) >= 0) {
            int actionIdStart = lastIndex + SHORTCUT_ENTITY.length();
            int actionIdEnd = text.indexOf(";", actionIdStart);
            if (actionIdEnd < 0) {
                return;
            }
            String actionId = text.substring(actionIdStart, actionIdEnd);
            Shortcut[] shortcuts = KeymapManager.getInstance().getActiveKeymap().getShortcuts(actionId);
            String shortcutText = "";
            for (Shortcut shortcut : shortcuts) {
                if (!(shortcut instanceof KeyboardShortcut)) continue;
                shortcutText = KeymapUtil.getShortcutText((Shortcut)shortcut);
                break;
            }
            String replacement = MessageFormat.format(SHORTCUT_HTML_TEMPLATE, shortcutText);
            text.replace(lastIndex, actionIdEnd + 1, replacement);
            lastIndex += replacement.length();
        }
        return;
    }
}

