/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indentation;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class IndentationAnnotatorVisitor
extends PsiElementVisitor {
    protected final AnnotationHolder myHolder;
    private final IElementType myIndentTokenType;
    private final IElementType myEolTokenType;

    public IndentationAnnotatorVisitor(@NotNull AnnotationHolder holder, IElementType indentTokenType, IElementType eolTokenType) {
        if (holder == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/indentation/IndentationAnnotatorVisitor.<init> must not be null");
        }
        this.myHolder = holder;
        this.myIndentTokenType = indentTokenType;
        this.myEolTokenType = eolTokenType;
    }

    public void visitFile(PsiFile file) {
        int lastIndent = 0;
        IndentInfo indentInfo = null;
        PsiElement leaf = PsiTreeUtil.getDeepestFirst((PsiElement)file);
        if (leaf == null || leaf instanceof PsiFile) {
            return;
        }
        PsiElement nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)leaf);
        if (leaf.getNode().getElementType() == this.myIndentTokenType) {
            this.myHolder.createErrorAnnotation(leaf, "Indenting at the beginning of the document is illegal");
        }
        PsiElement psiElement = nextLeaf = (leaf = nextLeaf) != null ? PsiTreeUtil.nextLeaf((PsiElement)leaf) : null;
        while (leaf != null) {
            IElementType leafType = leaf.getNode().getElementType();
            if (leafType == this.myIndentTokenType && nextLeaf != null && nextLeaf.getNode().getElementType() != this.myEolTokenType) {
                String currentIndentText = leaf.getText();
                IndentInfo currentIndent = this.getIndent(currentIndentText);
                int currentIndentLength = currentIndent.length;
                if (currentIndentLength == -1) {
                    this.myHolder.createErrorAnnotation(leaf, "Indentation can't use both tabs and spaces");
                } else if (currentIndentLength > 0) {
                    if (indentInfo == null) {
                        indentInfo = currentIndent;
                        lastIndent = currentIndentLength;
                    } else {
                        Boolean useTab = indentInfo.useTab;
                        int indentInfoLength = indentInfo.length;
                        if (useTab.booleanValue() && currentIndentText.contains(" ") || !useTab.booleanValue() && currentIndentText.contains("\t")) {
                            String message = useTab != false ? "Inconsistent indentation: " + currentIndentLength + " spaces were used for indentation, but the rest of the document was indented using " + indentInfoLength + " tabs" : "Inconsistent indentation: " + currentIndentLength + " tabs were used for indentation, but the rest of the document was indented using " + indentInfoLength + " spaces";
                            this.myHolder.createErrorAnnotation(leaf, message);
                        } else {
                            int delta = currentIndentLength - lastIndent;
                            if (currentIndentLength % indentInfoLength != 0 || delta > indentInfoLength) {
                                String message = useTab != false ? currentIndentLength + " tabs were used for indentation. Must be indented using " + indentInfoLength + " tabs" : currentIndentLength + " spaces were used for indentation. Must be indented using " + indentInfoLength + " spaces";
                                this.myHolder.createErrorAnnotation(leaf, message);
                            }
                            lastIndent = currentIndentLength / indentInfoLength * indentInfoLength;
                        }
                    }
                }
            }
            nextLeaf = (leaf = nextLeaf) != null ? PsiTreeUtil.nextLeaf((PsiElement)leaf) : null;
        }
    }

    private IndentInfo getIndent(String text) {
        if (text.length() == 0) {
            return new IndentInfo(0, false);
        }
        if (text.contains("\t ") || text.contains(" \t")) {
            return new IndentInfo(-1, false);
        }
        return new IndentInfo(text.length(), text.contains("\t"));
    }

    private class IndentInfo {
        final int length;
        final boolean useTab;

        private IndentInfo(int length, boolean useTab) {
            this.length = length;
            this.useTab = useTab;
        }
    }
}

