/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.injected.editor;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;

public class RangeMarkerWindow
implements RangeMarkerEx {
    private final DocumentWindow myDocumentWindow;
    private final RangeMarkerEx myHostMarker;

    public RangeMarkerWindow(@NotNull DocumentWindow documentWindow, RangeMarkerEx hostMarker) {
        if (documentWindow == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/injected/editor/RangeMarkerWindow.<init> must not be null");
        }
        this.myDocumentWindow = documentWindow;
        this.myHostMarker = hostMarker;
    }

    @NotNull
    public Document getDocument() {
        DocumentWindow documentWindow = this.myDocumentWindow;
        if (documentWindow == null) {
            throw new IllegalStateException("@NotNull method com/intellij/injected/editor/RangeMarkerWindow.getDocument must not return null");
        }
        return documentWindow;
    }

    public int getStartOffset() {
        int hostOffset = this.myHostMarker.getStartOffset();
        return this.myDocumentWindow.hostToInjected(hostOffset);
    }

    public int getEndOffset() {
        int hostOffset = this.myHostMarker.getEndOffset();
        return this.myDocumentWindow.hostToInjected(hostOffset);
    }

    public boolean isValid() {
        return this.myHostMarker.isValid() && this.myDocumentWindow.isValid();
    }

    public void setGreedyToLeft(boolean greedy) {
        this.myHostMarker.setGreedyToLeft(greedy);
    }

    public void setGreedyToRight(boolean greedy) {
        this.myHostMarker.setGreedyToRight(greedy);
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/injected/editor/RangeMarkerWindow.getUserData must not be null");
        }
        return (T)this.myHostMarker.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, T value) {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/injected/editor/RangeMarkerWindow.putUserData must not be null");
        }
        this.myHostMarker.putUserData(key, value);
    }

    @Override
    public void documentChanged(DocumentEvent e) {
        this.myHostMarker.documentChanged(e);
    }

    @Override
    public long getId() {
        return this.myHostMarker.getId();
    }

    public RangeMarkerEx getDelegate() {
        return this.myHostMarker;
    }

    public boolean isGreedyToRight() {
        return this.myHostMarker.isGreedyToRight();
    }

    public boolean isGreedyToLeft() {
        return this.myHostMarker.isGreedyToLeft();
    }
}

