/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.CommonBundle;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.impl.EditorAndState;
import com.intellij.openapi.command.impl.NonUndoableAction;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.Icon;

class UndoableGroup {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.command.impl.UndoableGroup");
    private String myCommandName;
    private boolean myGlobal;
    private int myCommandTimestamp;
    private boolean myTransparentsOnly;
    private List<UndoableAction> myActions;
    private EditorAndState myStateBefore;
    private EditorAndState myStateAfter;
    private Project myProject;
    private final UndoConfirmationPolicy myConfirmationPolicy;
    private boolean isValid = true;

    public UndoableGroup(String commandName, boolean isGlobal, Project project, EditorAndState stateBefore, EditorAndState stateAfter, List<UndoableAction> actions, int commandTimestamp, UndoConfirmationPolicy confirmationPolicy, boolean transparentsOnly) {
        this.myCommandName = commandName;
        this.myGlobal = isGlobal;
        this.myCommandTimestamp = commandTimestamp;
        this.myActions = actions;
        this.myProject = project;
        this.myStateBefore = stateBefore;
        this.myStateAfter = stateAfter;
        this.myConfirmationPolicy = confirmationPolicy;
        this.myTransparentsOnly = transparentsOnly;
    }

    public boolean isGlobal() {
        return this.myGlobal;
    }

    public boolean isTransparentsOnly() {
        return this.myTransparentsOnly;
    }

    public boolean isUndoable() {
        for (UndoableAction action : this.myActions) {
            if (!(action instanceof NonUndoableAction)) continue;
            return false;
        }
        return true;
    }

    public void addTailActions(Collection<UndoableAction> actions) {
        this.myActions.addAll(actions);
    }

    public void undo() {
        this.undoOrRedo(true);
    }

    public void redo() {
        this.undoOrRedo(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void undoOrRedo(boolean isUndo) {
        LocalHistoryAction action = LocalHistoryAction.NULL;
        if (this.myProject != null && this.isGlobal()) {
            String actionName = isUndo ? CommonBundle.message((String)"local.vcs.action.name.undo.command", (Object[])new Object[]{this.myCommandName}) : CommonBundle.message((String)"local.vcs.action.name.redo.command", (Object[])new Object[]{this.myCommandName});
            action = LocalHistory.startAction((Project)this.myProject, (String)actionName);
        }
        try {
            this.doUndoOrRedo(isUndo);
        }
        finally {
            action.finish();
        }
    }

    private void doUndoOrRedo(final boolean isUndo) {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                Iterator it = isUndo ? UndoableGroup.this.reverseIterator(UndoableGroup.this.myActions.listIterator(UndoableGroup.this.myActions.size())) : UndoableGroup.this.myActions.iterator();
                try {
                    while (it.hasNext()) {
                        UndoableAction each = (UndoableAction)it.next();
                        if (isUndo) {
                            each.undo();
                            continue;
                        }
                        each.redo();
                    }
                }
                catch (UnexpectedUndoException e) {
                    UndoableGroup.this.reportUndoProblem(e, isUndo);
                }
            }
        });
    }

    private Iterator<UndoableAction> reverseIterator(final ListIterator<UndoableAction> iter) {
        return new Iterator<UndoableAction>(){

            @Override
            public boolean hasNext() {
                return iter.hasPrevious();
            }

            @Override
            public UndoableAction next() {
                return (UndoableAction)iter.previous();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private void reportUndoProblem(UnexpectedUndoException e, boolean isUndo) {
        String message;
        String title;
        if (isUndo) {
            title = CommonBundle.message((String)"cannot.undo.dialog.title", (Object[])new Object[0]);
            message = CommonBundle.message((String)"cannot.undo.message", (Object[])new Object[0]);
        } else {
            title = CommonBundle.message((String)"cannot.redo.dialog.title", (Object[])new Object[0]);
            message = CommonBundle.message((String)"cannot.redo.message", (Object[])new Object[0]);
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            if (e.getMessage() != null) {
                message = message + ".\n" + e.getMessage();
            }
            Messages.showMessageDialog((Project)this.myProject, (String)message, (String)title, (Icon)Messages.getErrorIcon());
        } else {
            LOG.error((Throwable)e);
        }
    }

    public Collection<DocumentReference> getAffectedDocuments() {
        THashSet result = new THashSet();
        for (UndoableAction action : this.myActions) {
            DocumentReference[] refs = action.getAffectedDocuments();
            if (refs == null) continue;
            Collections.addAll(result, refs);
        }
        return result;
    }

    public EditorAndState getStateBefore() {
        return this.myStateBefore;
    }

    public EditorAndState getStateAfter() {
        return this.myStateAfter;
    }

    public void setStateBefore(EditorAndState stateBefore) {
        this.myStateBefore = stateBefore;
    }

    public void setStateAfter(EditorAndState stateAfter) {
        this.myStateAfter = stateAfter;
    }

    public String getCommandName() {
        return this.myCommandName;
    }

    public int getCommandTimestamp() {
        return this.myCommandTimestamp;
    }

    public boolean shouldAskConfirmation() {
        if (this.myConfirmationPolicy == UndoConfirmationPolicy.REQUEST_CONFIRMATION) {
            return true;
        }
        if (this.myConfirmationPolicy == UndoConfirmationPolicy.DO_NOT_REQUEST_CONFIRMATION) {
            return false;
        }
        return this.myGlobal;
    }

    public void invalidateIfGlobal() {
        if (!this.myGlobal) {
            return;
        }
        this.isValid = false;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("UndoableGroup{ ");
        for (UndoableAction action : this.myActions) {
            result.append(action).append(" ");
        }
        result.append("}");
        return result.toString();
    }
}

