/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.incrementalMerge;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.impl.highlighting.FragmentSide;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeList;
import com.intellij.openapi.diff.impl.incrementalMerge.ChangeType;
import com.intellij.openapi.diff.impl.incrementalMerge.DiffRangeMarker;
import com.intellij.openapi.diff.impl.util.GutterActionRenderer;
import com.intellij.openapi.diff.impl.util.TextDiffType;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Change {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.incrementalMerge.Change");

    private void apply(FragmentSide original) {
        FragmentSide targetSide = original.otherSide();
        RangeMarker originalRangeMarker = this.getRangeMarker(original);
        RangeMarker rangeMarker = this.getRangeMarker(targetSide);
        if (originalRangeMarker != null && rangeMarker != null) {
            ChangeType.apply(originalRangeMarker, rangeMarker);
            if (this.isValid()) {
                this.removeFromList();
            }
        }
    }

    protected abstract void removeFromList();

    public void addMarkup(Editor[] editors) {
        LOG.assertTrue(editors.length == 2);
        this.highlight(editors, FragmentSide.SIDE1);
        this.highlight(editors, FragmentSide.SIDE2);
    }

    private void highlight(Editor[] editors, FragmentSide side) {
        this.getHighlighterHolder(side).highlight(this.getChangeSide(side), editors[side.getIndex()], this.getType());
    }

    private void updateHighlighter(FragmentSide side) {
        this.getHighlighterHolder(side).updateHighlighter(this.getChangeSide(side), this.getType());
    }

    private Project getProject() {
        return this.getChangeList().getProject();
    }

    public abstract ChangeType.ChangeSide getChangeSide(FragmentSide var1);

    public abstract ChangeType getType();

    public abstract ChangeList getChangeList();

    private HighlighterHolder getHighlighterHolder(FragmentSide side) {
        return this.getChangeSide(side).getHighlighterHolder();
    }

    private RangeMarker getRangeMarker(FragmentSide side) {
        ChangeType.ChangeSide changeSide = this.getChangeSide(side);
        LOG.assertTrue(changeSide != null);
        return changeSide.getRange();
    }

    public abstract void onRemovedFromList();

    public abstract boolean isValid();

    public static void apply(final Change change, final FragmentSide fromSide) {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                CommandProcessor.getInstance().executeCommand(change.getProject(), new Runnable(){

                    @Override
                    public void run() {
                        change.apply(fromSide);
                    }
                }, null, (Object)DiffBundle.message((String)"save.merge.result.command.name", (Object[])new Object[0]));
            }
        });
    }

    public void updateMarkup() {
        this.updateHighlighter(FragmentSide.SIDE1);
        this.updateHighlighter(FragmentSide.SIDE2);
    }

    public boolean canHasActions(FragmentSide fromSide) {
        FragmentSide targetSide = fromSide.otherSide();
        Document targetDocument = this.getChangeList().getDocument(targetSide);
        if (!targetDocument.isWritable()) {
            return false;
        }
        Editor targetEditor = this.getHighlighterHolder(targetSide).getEditor();
        return !targetEditor.isViewer();
    }

    protected static class Side
    extends ChangeType.ChangeSide {
        private final FragmentSide mySide;
        private final DiffRangeMarker myRange;
        private final HighlighterHolder myHighlighterHolder = new HighlighterHolder();

        public Side(FragmentSide side, DiffRangeMarker rangeMarker) {
            this.mySide = side;
            this.myRange = rangeMarker;
        }

        public FragmentSide getFragmentSide() {
            return this.mySide;
        }

        @Override
        public DiffRangeMarker getRange() {
            return this.myRange;
        }

        @Override
        public HighlighterHolder getHighlighterHolder() {
            return this.myHighlighterHolder;
        }
    }

    protected static class HighlighterHolder
    implements ChangeType.MarkupHolder {
        private Editor myEditor;
        private final ArrayList<RangeHighlighter> myHighlighters = new ArrayList(3);
        private RangeHighlighter myMainHighlighter = null;
        private AnAction[] myActions;
        private RangeHighlighter[] myActionHighlighters = RangeHighlighter.EMPTY_ARRAY;

        protected HighlighterHolder() {
        }

        public void highlight(ChangeType.ChangeSide changeSide, Editor editor, ChangeType type) {
            LOG.assertTrue(this.myEditor == null || editor == this.myEditor);
            this.removeHighlighters();
            this.myEditor = editor;
            this.setHighlighter(changeSide, type);
        }

        private MarkupModel getMarkupModel() {
            return this.myEditor.getMarkupModel();
        }

        private void highlighterCreated(RangeHighlighter highlighter, TextAttributes attrs) {
            if (attrs != null) {
                highlighter.setErrorStripeMarkColor(attrs.getErrorStripeColor());
            }
            this.myHighlighters.add(highlighter);
        }

        @Override
        @Nullable
        public RangeHighlighter addLineHighlighter(int line, int layer, TextDiffType diffType) {
            if (this.myEditor.getDocument().getTextLength() == 0) {
                return null;
            }
            RangeHighlighter highlighter = this.getMarkupModel().addLineHighlighter(line, layer, null);
            highlighter.setLineSeparatorColor(diffType.getTextBackground(this.myEditor));
            this.highlighterCreated(highlighter, diffType.getTextAttributes(this.myEditor));
            return highlighter;
        }

        @Override
        @Nullable
        public RangeHighlighter addRangeHighlighter(int start, int end, int layer, TextDiffType type, HighlighterTargetArea targetArea) {
            if (this.getMarkupModel().getDocument().getTextLength() == 0) {
                return null;
            }
            TextAttributes attributes = type.getTextAttributes(this.myEditor);
            RangeHighlighter highlighter = this.getMarkupModel().addRangeHighlighter(start, end, layer, attributes, targetArea);
            this.highlighterCreated(highlighter, attributes);
            return highlighter;
        }

        private void setHighlighter(ChangeType.ChangeSide changeSide, ChangeType type) {
            this.myMainHighlighter = type.addMarker(changeSide, this);
            this.updateAction();
        }

        public Editor getEditor() {
            return this.myEditor;
        }

        public void removeHighlighters() {
            if (this.myEditor == null) {
                LOG.assertTrue(this.myHighlighters.isEmpty());
                LOG.assertTrue(this.myMainHighlighter == null);
                return;
            }
            MarkupModel markupModel = this.myEditor.getMarkupModel();
            Iterator<RangeHighlighter> iterator = this.myHighlighters.iterator();
            while (iterator.hasNext()) {
                RangeHighlighter highlighter = iterator.next();
                markupModel.removeHighlighter(highlighter);
                iterator.remove();
            }
            this.removeActionHighlighters();
            this.myMainHighlighter = null;
        }

        private void removeActionHighlighters() {
            MarkupModel markupModel = this.myEditor.getMarkupModel();
            for (RangeHighlighter actionHighlighter : this.myActionHighlighters) {
                markupModel.removeHighlighter(actionHighlighter);
            }
            this.myActionHighlighters = RangeHighlighter.EMPTY_ARRAY;
        }

        public void setActions(AnAction[] action) {
            this.myActions = action;
            this.updateAction();
        }

        private void updateAction() {
            this.removeActionHighlighters();
            if (this.myMainHighlighter != null && this.myActions != null && this.myActions.length > 0) {
                this.myActionHighlighters = new RangeHighlighter[this.myActions.length];
                for (int i = 0; i < this.myActionHighlighters.length; ++i) {
                    RangeHighlighter highlighter = this.cloneMainHighlighter(this.myMainHighlighter);
                    highlighter.setGutterIconRenderer((GutterIconRenderer)new GutterActionRenderer(this.myActions[i]));
                    this.myActionHighlighters[i] = highlighter;
                }
            }
        }

        private RangeHighlighter cloneMainHighlighter(@NotNull RangeHighlighter mainHighlighter) {
            if (mainHighlighter == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/diff/impl/incrementalMerge/Change$HighlighterHolder.cloneMainHighlighter must not be null");
            }
            RangeHighlighter highlighter = this.myEditor.getMarkupModel().addRangeHighlighter(mainHighlighter.getStartOffset(), mainHighlighter.getEndOffset(), mainHighlighter.getLayer(), null, mainHighlighter.getTargetArea());
            return highlighter;
        }

        public void updateHighlighter(ChangeType.ChangeSide changeSide, ChangeType type) {
            LOG.assertTrue(this.myEditor != null);
            this.removeHighlighters();
            this.setHighlighter(changeSide, type);
        }
    }

    public static class ChangeOrder
    implements Comparator<Change> {
        private final FragmentSide myMainSide;

        public ChangeOrder(FragmentSide mainSide) {
            this.myMainSide = mainSide;
        }

        @Override
        public int compare(Change change, Change change1) {
            int result1 = ChangeOrder.compareSide(change, change1, this.myMainSide);
            if (result1 != 0) {
                return result1;
            }
            return ChangeOrder.compareSide(change, change1, this.myMainSide.otherSide());
        }

        private static int compareSide(Change change, Change change1, FragmentSide side) {
            return RangeMarker.BY_START_OFFSET.compare(change.getRangeMarker(side), change1.getRangeMarker(side));
        }
    }
}

