/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.EditorActionUtil;

public class BackspaceAction
extends EditorAction {
    public BackspaceAction() {
        super((EditorActionHandler)new Handler());
    }

    public static void doBackSpaceAtCaret(Editor editor) {
        if (editor.getSelectionModel().hasSelection()) {
            int newOffset = editor.getSelectionModel().getSelectionStart();
            editor.getCaretModel().moveToOffset(newOffset);
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            EditorModificationUtil.deleteSelectedText((Editor)editor);
            return;
        }
        int lineNumber = editor.getCaretModel().getLogicalPosition().line;
        int colNumber = editor.getCaretModel().getLogicalPosition().column;
        Document document = editor.getDocument();
        if (colNumber > 0) {
            if (EditorModificationUtil.calcAfterLineEnd((Editor)editor) > 0) {
                int columnShift = -1;
                editor.getCaretModel().moveCaretRelatively(columnShift, 0, false, false, true);
            } else {
                int offset = editor.getCaretModel().getOffset();
                editor.getCaretModel().moveToOffset(offset - 1);
                editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                editor.getSelectionModel().removeSelection();
                document.deleteString(offset - 1, offset);
            }
        } else if (lineNumber > 0) {
            int separatorLength = document.getLineSeparatorLength(lineNumber - 1);
            int lineEnd = document.getLineEndOffset(lineNumber - 1) + separatorLength;
            editor.getCaretModel().moveToOffset(lineEnd - separatorLength);
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            editor.getSelectionModel().removeSelection();
            document.deleteString(lineEnd - separatorLength, lineEnd);
            CommandProcessor commandProcessor = CommandProcessor.getInstance();
            commandProcessor.setCurrentCommandGroupId(null);
        }
    }

    private static class Handler
    extends EditorWriteActionHandler {
        private Handler() {
        }

        public void executeWriteAction(Editor editor, DataContext dataContext) {
            CommandProcessor.getInstance().setCurrentCommandGroupId(EditorActionUtil.DELETE_COMMAND_GROUP);
            SelectionModel selectionModel = editor.getSelectionModel();
            if (selectionModel.hasBlockSelection()) {
                LogicalPosition start = selectionModel.getBlockStart();
                LogicalPosition end = selectionModel.getBlockEnd();
                int column = Math.min(start.column, end.column);
                int startLine = Math.min(start.line, end.line);
                int endLine = Math.max(start.line, end.line);
                EditorModificationUtil.deleteBlockSelection((Editor)editor);
                if (column > 0 && start.column == end.column) {
                    for (int i = startLine; i <= endLine; ++i) {
                        editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(i, column));
                        BackspaceAction.doBackSpaceAtCaret(editor);
                    }
                    --column;
                }
                int newColumn = Math.max(column, 0);
                selectionModel.setBlockSelection(new LogicalPosition(startLine, newColumn), new LogicalPosition(endLine, newColumn));
                return;
            }
            BackspaceAction.doBackSpaceAtCaret(editor);
        }
    }
}

