/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.AppTopics;
import com.intellij.ProjectTopics;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.EditorDataProvider;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.NavigatableFileEditor;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorFileSwapper;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.fileEditor.impl.HistoryEntry;
import com.intellij.openapi.fileEditor.impl.IdeDocumentHistoryImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.FrameTitleBuilder;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.pom.Navigatable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.impl.MessageListenerList;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileEditorManagerImpl
extends FileEditorManagerEx
implements ProjectComponent,
JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl");
    private static final Key<LocalFileSystem.WatchRequest> WATCH_REQUEST_KEY = Key.create((String)"WATCH_REQUEST_KEY");
    private static final Key<Boolean> DUMB_AWARE = Key.create((String)"DUMB_AWARE");
    private static final FileEditor[] EMPTY_EDITOR_ARRAY = new FileEditor[0];
    private static final FileEditorProvider[] EMPTY_PROVIDER_ARRAY = new FileEditorProvider[0];
    private volatile JPanel myPanels;
    private EditorsSplitters mySplitters;
    private final Project myProject;
    private final MergingUpdateQueue myQueue = new MergingUpdateQueue("FileEditorManagerUpdateQueue", 50, true, null);
    private final MyEditorPropertyChangeListener myEditorPropertyChangeListener = new MyEditorPropertyChangeListener();
    private final List<EditorDataProvider> myDataProviders = new ArrayList<EditorDataProvider>();
    private final Object myInitLock = new Object();
    private final MessageListenerList<FileEditorManagerListener> myListenerList;

    public FileEditorManagerImpl(Project project) {
        this.myProject = project;
        this.myListenerList = new MessageListenerList(this.myProject.getMessageBus(), FileEditorManagerListener.FILE_EDITOR_MANAGER);
    }

    public static boolean isDumbAware(FileEditor editor) {
        return Boolean.TRUE.equals(editor.getUserData(DUMB_AWARE));
    }

    @Override
    public JComponent getComponent() {
        this.initUI();
        return this.myPanels;
    }

    public EditorsSplitters getSplitters() {
        this.initUI();
        return this.mySplitters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initUI() {
        if (this.myPanels == null) {
            Object object = this.myInitLock;
            synchronized (object) {
                if (this.myPanels == null) {
                    this.myPanels = new JPanel(new BorderLayout());
                    this.mySplitters = new EditorsSplitters(this);
                    this.myPanels.add((Component)this.mySplitters, "Center");
                }
            }
        }
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        EditorWithProviderComposite editor;
        FileEditorManagerImpl.assertReadAccess();
        EditorWindow window = this.getSplitters().getCurrentWindow();
        if (window != null && (editor = window.getSelectedEditor()) != null) {
            return editor.getPreferredFocusedComponent();
        }
        return null;
    }

    public Color getFileColor(@NotNull VirtualFile file) {
        Color statusColor;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.getFileColor must not be null");
        }
        FileStatusManager fileStatusManager = FileStatusManager.getInstance((Project)this.myProject);
        Color color = statusColor = fileStatusManager != null ? fileStatusManager.getStatus(file).getColor() : Color.BLACK;
        if (statusColor == null) {
            statusColor = Color.BLACK;
        }
        return statusColor;
    }

    public boolean isProblem(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.isProblem must not be null");
        }
        return false;
    }

    public String getFileTooltipText(VirtualFile file) {
        return file.getPresentableUrl();
    }

    @Override
    public void updateFilePresentation(VirtualFile file) {
        if (!this.isFileOpen(file)) {
            return;
        }
        this.updateFileColor(file);
        this.updateFileIcon(file);
        this.updateFileName(file);
        this.updateFileBackgroundColor(file);
    }

    private void updateFileColor(VirtualFile file) {
        this.getSplitters().updateFileColor(file);
    }

    private void updateFileBackgroundColor(VirtualFile file) {
        this.getSplitters().updateFileBackgroundColor(file);
    }

    protected void updateFileIcon(VirtualFile file) {
        this.getSplitters().updateFileIcon(file);
    }

    void updateFileName(final @Nullable VirtualFile file) {
        this.myQueue.queue(new Update("UpdateFileName " + (file == null ? "" : file.getPath())){

            public boolean isExpired() {
                return FileEditorManagerImpl.this.myProject.isDisposed() || !FileEditorManagerImpl.this.myProject.isOpen() || (file == null ? super.isExpired() : !file.isValid());
            }

            public void run() {
                WindowManagerEx windowManagerEx = WindowManagerEx.getInstanceEx();
                IdeFrameImpl frame = windowManagerEx.getFrame(FileEditorManagerImpl.this.myProject);
                LOG.assertTrue(frame != null);
                FileEditorManagerImpl.this.getSplitters().updateFileName(file);
                File ioFile = file == null ? null : new File(file.getPresentableUrl());
                frame.setFileTitle(file == null ? null : FrameTitleBuilder.getInstance().getFileTitle(FileEditorManagerImpl.this.myProject, file), ioFile);
            }
        });
    }

    @Override
    public VirtualFile getFile(@NotNull FileEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.getFile must not be null");
        }
        EditorWithProviderComposite editorComposite = this.getEditorComposite(editor);
        if (editorComposite != null) {
            return editorComposite.getFile();
        }
        return null;
    }

    @Override
    public void unsplitWindow() {
        EditorWindow currentWindow = this.getSplitters().getCurrentWindow();
        if (currentWindow != null) {
            currentWindow.unsplit(true);
        }
    }

    @Override
    public void unsplitAllWindow() {
        EditorWindow currentWindow = this.getSplitters().getCurrentWindow();
        if (currentWindow != null) {
            currentWindow.unsplitAll();
        }
    }

    @Override
    @NotNull
    public EditorWindow[] getWindows() {
        EditorWindow[] editorWindowArray = this.getSplitters().getWindows();
        if (editorWindowArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.getWindows must not return null");
        }
        return editorWindowArray;
    }

    @Override
    public EditorWindow getNextWindow(@NotNull EditorWindow window) {
        if (window == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.getNextWindow must not be null");
        }
        EditorWindow[] windows = this.getSplitters().getOrderedWindows();
        for (int i = 0; i != windows.length; ++i) {
            if (!windows[i].equals(window)) continue;
            return windows[(i + 1) % windows.length];
        }
        LOG.error("Not window found");
        return null;
    }

    @Override
    public EditorWindow getPrevWindow(@NotNull EditorWindow window) {
        if (window == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.getPrevWindow must not be null");
        }
        EditorWindow[] windows = this.getSplitters().getOrderedWindows();
        for (int i = 0; i != windows.length; ++i) {
            if (!windows[i].equals(window)) continue;
            return windows[(i + windows.length - 1) % windows.length];
        }
        LOG.error("Not window found");
        return null;
    }

    @Override
    public void createSplitter(int orientation, @Nullable EditorWindow window) {
        if (window != null) {
            window.split(orientation);
        } else {
            EditorWindow currentWindow = this.getSplitters().getCurrentWindow();
            if (currentWindow != null) {
                currentWindow.split(orientation);
            }
        }
    }

    @Override
    public void changeSplitterOrientation() {
        EditorWindow currentWindow = this.getSplitters().getCurrentWindow();
        if (currentWindow != null) {
            currentWindow.changeOrientation();
        }
    }

    @Override
    public void flipTabs() {
        this.myPanels.revalidate();
    }

    @Override
    public boolean tabsMode() {
        return false;
    }

    private void setTabsMode(boolean mode) {
        if (this.tabsMode() != mode) {
            this.flipTabs();
        }
    }

    @Override
    public boolean isInSplitter() {
        EditorWindow currentWindow = this.getSplitters().getCurrentWindow();
        return currentWindow != null && currentWindow.inSplitter();
    }

    @Override
    public boolean hasOpenedFile() {
        EditorWindow currentWindow = this.getSplitters().getCurrentWindow();
        return currentWindow != null && currentWindow.getSelectedEditor() != null;
    }

    @Override
    public VirtualFile getCurrentFile() {
        return this.getSplitters().getCurrentFile();
    }

    @Override
    public EditorWindow getCurrentWindow() {
        return this.getSplitters().getCurrentWindow();
    }

    @Override
    public void setCurrentWindow(EditorWindow window) {
        this.getSplitters().setCurrentWindow(window, true);
    }

    @Override
    public void closeFile(final @NotNull VirtualFile file, final @NotNull EditorWindow window) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.closeFile must not be null");
        }
        if (window == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.closeFile must not be null");
        }
        FileEditorManagerImpl.assertDispatchThread();
        CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

            @Override
            public void run() {
                if (window.isFileOpen(file)) {
                    LocalFileSystem.WatchRequest request;
                    window.closeFile(file);
                    List<EditorWindow> windows = FileEditorManagerImpl.this.getSplitters().findWindows(file);
                    if (windows.isEmpty() && (request = (LocalFileSystem.WatchRequest)file.getUserData(WATCH_REQUEST_KEY)) != null) {
                        LocalFileSystem.getInstance().removeWatchedRoot(request);
                    }
                }
            }
        }, IdeBundle.message((String)"command.close.active.editor", (Object[])new Object[0]), null);
    }

    public void closeFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.closeFile must not be null");
        }
        this.closeFile(file, true);
    }

    public void closeFile(final @NotNull VirtualFile file, final boolean moveFocus) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.closeFile must not be null");
        }
        FileEditorManagerImpl.assertDispatchThread();
        LocalFileSystem.WatchRequest request = (LocalFileSystem.WatchRequest)file.getUserData(WATCH_REQUEST_KEY);
        if (request != null) {
            LocalFileSystem.getInstance().removeWatchedRoot(request);
        }
        CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

            @Override
            public void run() {
                FileEditorManagerImpl.this.closeFileImpl(file, moveFocus);
            }
        }, "", null);
    }

    private VirtualFile findNextFile(VirtualFile file) {
        EditorWindow[] windows = this.getWindows();
        for (int i = 0; i != windows.length; ++i) {
            VirtualFile[] files;
            for (VirtualFile fileAt : files = windows[i].getFiles()) {
                if (fileAt == file) continue;
                return fileAt;
            }
        }
        return null;
    }

    private void closeFileImpl(final @NotNull VirtualFile file, final boolean moveFocus) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.closeFileImpl must not be null");
        }
        FileEditorManagerImpl.assertDispatchThread();
        this.getSplitters().runChange(new Runnable(){

            @Override
            public void run() {
                List<EditorWindow> windows = FileEditorManagerImpl.this.getSplitters().findWindows(file);
                if (!windows.isEmpty()) {
                    VirtualFile nextFile = FileEditorManagerImpl.this.findNextFile(file);
                    for (EditorWindow window : windows) {
                        LOG.assertTrue(window.getSelectedEditor() != null);
                        window.closeFile(file, false, moveFocus);
                        if (window.getTabCount() != 0 || nextFile == null) continue;
                        EditorWithProviderComposite newComposite = FileEditorManagerImpl.this.newEditorComposite(nextFile);
                        window.setEditor(newComposite, moveFocus);
                    }
                    for (EditorWindow window : windows) {
                        if (window.isDisposed() || window.getTabCount() != 0) continue;
                        window.unsplit(false);
                    }
                }
            }
        });
    }

    @Override
    @NotNull
    public Pair<FileEditor[], FileEditorProvider[]> openFileWithProviders(@NotNull VirtualFile file, boolean focusEditor) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.openFileWithProviders must not be null");
        }
        if (!file.isValid()) {
            throw new IllegalArgumentException("file is not valid: " + file);
        }
        FileEditorManagerImpl.assertDispatchThread();
        Pair<FileEditor[], FileEditorProvider[]> pair = this.openFileImpl2(this.getSplitters().getOrCreateCurrentWindow(file), file, focusEditor, null);
        if (pair == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.openFileWithProviders must not return null");
        }
        return pair;
    }

    @NotNull
    Pair<FileEditor[], FileEditorProvider[]> openFileImpl2(final EditorWindow window, final VirtualFile file, final boolean focusEditor, final HistoryEntry entry) {
        final Ref resHolder = new Ref();
        CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

            @Override
            public void run() {
                resHolder.set(FileEditorManagerImpl.this.openFileImpl3(window, file, focusEditor, entry, true));
            }
        }, "", null);
        Pair pair = (Pair)resHolder.get();
        if (pair == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.openFileImpl2 must not return null");
        }
        return pair;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    Pair<FileEditor[], FileEditorProvider[]> openFileImpl3(EditorWindow window, @NotNull VirtualFile file, boolean focusEditor, HistoryEntry entry, boolean current) {
        int i;
        Pair pair;
        Object[] providers;
        FileEditor[] editors;
        EditorWithProviderComposite newSelectedComposite;
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.openFileImpl3 must not be null");
        }
        boolean newEditorCreated = false;
        boolean open = window.isFileOpen(file);
        if (open) {
            newSelectedComposite = window.findFileComposite(file);
            LOG.assertTrue(newSelectedComposite != null);
            editors = newSelectedComposite.getEditors();
            providers = newSelectedComposite.getProviders();
        } else {
            FileEditorProviderManager editorProviderManager = FileEditorProviderManager.getInstance();
            providers = editorProviderManager.getProviders(this.myProject, file);
            if (DumbService.getInstance((Project)this.myProject).isDumb()) {
                List dumbAware = ContainerUtil.findAll((Object[])providers, (Condition)new Condition<FileEditorProvider>(){

                    public boolean value(FileEditorProvider fileEditorProvider) {
                        return fileEditorProvider instanceof DumbAware;
                    }
                });
                providers = dumbAware.toArray(new FileEditorProvider[dumbAware.size()]);
            }
            if (providers.length == 0) {
                pair = Pair.create((Object)EMPTY_EDITOR_ARRAY, (Object)EMPTY_PROVIDER_ARRAY);
                if (pair == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.openFileImpl3 must not return null");
                return pair;
            }
            newEditorCreated = true;
            ((FileEditorManagerListener.Before)this.getProject().getMessageBus().syncPublisher(FileEditorManagerListener.Before.FILE_EDITOR_MANAGER)).beforeFileOpened((FileEditorManager)this, file);
            editors = new FileEditor[providers.length];
            for (i = 0; i < providers.length; ++i) {
                try {
                    Object provider = providers[i];
                    LOG.assertTrue(provider != null);
                    LOG.assertTrue(provider.accept(this.myProject, file));
                    FileEditor editor = provider.createEditor(this.myProject, file);
                    LOG.assertTrue(editor != null);
                    LOG.assertTrue(editor.isValid());
                    editors[i] = editor;
                    editor.addPropertyChangeListener((PropertyChangeListener)this.myEditorPropertyChangeListener);
                    editor.putUserData(DUMB_AWARE, (Object)(provider instanceof DumbAware));
                    if (!current || !(editor instanceof TextEditorImpl)) continue;
                    ((TextEditorImpl)editor).initFolding();
                    continue;
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                    continue;
                }
                catch (AssertionError e) {
                    LOG.error((Throwable)((Object)e));
                }
            }
            newSelectedComposite = new EditorWithProviderComposite(file, editors, (FileEditorProvider[])providers, this);
        }
        window.setEditor(newSelectedComposite, focusEditor);
        EditorHistoryManager editorHistoryManager = EditorHistoryManager.getInstance(this.myProject);
        for (i = 0; i < editors.length; ++i) {
            FileEditor editor = editors[i];
            if (editor instanceof TextEditor) {
                ((EditorEx)((TextEditor)editor).getEditor()).stopOptimizedScrolling();
            }
            Object provider = providers[i];
            FileEditorState state = null;
            if (entry != null) {
                state = entry.getState((FileEditorProvider)provider);
            }
            if (state == null && !open) {
                state = editorHistoryManager.getState(file, (FileEditorProvider)provider);
            }
            if (state == null) continue;
            editor.setState(state);
        }
        FileEditorProvider selectedProvider = editorHistoryManager.getSelectedProvider(file);
        if (selectedProvider != null) {
            FileEditor[] _editors = newSelectedComposite.getEditors();
            FileEditorProvider[] _providers = newSelectedComposite.getProviders();
            for (int i2 = _editors.length - 1; i2 >= 0; --i2) {
                FileEditorProvider provider = _providers[i2];
                if (!provider.equals(selectedProvider)) continue;
                newSelectedComposite.setSelectedEditor(i2);
                break;
            }
        }
        this.getSplitters().setCurrentWindow(window, false);
        newSelectedComposite.getSelectedEditor().selectNotify();
        if (newEditorCreated) {
            ((FileEditorManagerListener)this.getProject().getMessageBus().syncPublisher(FileEditorManagerListener.FILE_EDITOR_MANAGER)).fileOpened((FileEditorManager)this, file);
            VirtualFile parentDir = file.getParent();
            if (parentDir != null) {
                LocalFileSystem.WatchRequest request = LocalFileSystem.getInstance().addRootToWatch(parentDir.getPath(), false);
                file.putUserData(WATCH_REQUEST_KEY, (Object)request);
            }
        }
        ((IdeDocumentHistoryImpl)IdeDocumentHistory.getInstance(this.myProject)).onSelectionChanged();
        if (!ApplicationManagerEx.getApplicationEx().isUnitTestMode() && focusEditor) {
            window.setAsCurrentWindow(false);
            ToolWindowManager.getInstance((Project)this.myProject).activateEditorComponent();
        }
        this.updateFileName(file);
        IdeDocumentHistory.getInstance(this.myProject).includeCurrentCommandAsNavigation();
        pair = Pair.create((Object)editors, (Object)providers);
        if (pair != null) return pair;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.openFileImpl3 must not return null");
    }

    private void setSelectedEditor(VirtualFile file, String fileEditorProviderId) {
        EditorWithProviderComposite composite = this.getCurrentEditorWithProviderComposite(file);
        if (composite == null) {
            List<EditorWithProviderComposite> composites = this.getEditorComposites(file);
            if (composites.isEmpty()) {
                return;
            }
            composite = composites.get(0);
        }
        FileEditorProvider[] editorProviders = composite.getProviders();
        FileEditorProvider selectedProvider = (FileEditorProvider)composite.getSelectedEditorWithProvider().getSecond();
        for (int i = 0; i < editorProviders.length; ++i) {
            if (!editorProviders[i].getEditorTypeId().equals(fileEditorProviderId) || selectedProvider.equals(editorProviders[i])) continue;
            composite.setSelectedEditor(i);
            composite.getSelectedEditor().selectNotify();
        }
    }

    private EditorWithProviderComposite newEditorComposite(VirtualFile file) {
        if (file == null) {
            return null;
        }
        FileEditorProviderManager editorProviderManager = FileEditorProviderManager.getInstance();
        FileEditorProvider[] providers = editorProviderManager.getProviders(this.myProject, file);
        FileEditor[] editors = new FileEditor[providers.length];
        for (int i = 0; i < providers.length; ++i) {
            FileEditor editor;
            FileEditorProvider provider = providers[i];
            LOG.assertTrue(provider != null);
            LOG.assertTrue(provider.accept(this.myProject, file));
            editors[i] = editor = provider.createEditor(this.myProject, file);
            LOG.assertTrue(editor.isValid());
            editor.addPropertyChangeListener((PropertyChangeListener)this.myEditorPropertyChangeListener);
        }
        EditorWithProviderComposite newComposite = new EditorWithProviderComposite(file, editors, providers, this);
        EditorHistoryManager editorHistoryManager = EditorHistoryManager.getInstance(this.myProject);
        for (int i = 0; i < editors.length; ++i) {
            FileEditorProvider provider;
            FileEditorState state;
            FileEditor editor = editors[i];
            if (editor instanceof TextEditor) {
                // empty if block
            }
            if ((state = editorHistoryManager.getState(file, provider = providers[i])) == null) continue;
            editor.setState(state);
        }
        return newComposite;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public List<FileEditor> openEditor(final @NotNull OpenFileDescriptor descriptor, final boolean focusEditor) {
        List<FileEditor> list;
        if (descriptor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.openEditor must not be null");
        }
        FileEditorManagerImpl.assertDispatchThread();
        if (descriptor.getFile() instanceof VirtualFileWindow) {
            VirtualFileWindow delegate = (VirtualFileWindow)descriptor.getFile();
            int hostOffset = delegate.getDocumentWindow().injectedToHost(descriptor.getOffset());
            OpenFileDescriptor realDescriptor = new OpenFileDescriptor(descriptor.getProject(), delegate.getDelegate(), hostOffset);
            list = this.openEditor(realDescriptor, focusEditor);
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.openEditor must not return null");
            return list;
        }
        final ArrayList<FileEditor> result = new ArrayList<FileEditor>();
        CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

            @Override
            public void run() {
                FileEditor editor;
                int i$;
                VirtualFile file = descriptor.getFile();
                FileEditor[] editors = FileEditorManagerImpl.this.openFile(file, focusEditor);
                result.addAll(Arrays.asList(editors));
                boolean navigated = false;
                FileEditor[] arr$ = editors;
                int len$ = arr$.length;
                for (i$ = 0; !(i$ >= len$ || (editor = arr$[i$]) instanceof NavigatableFileEditor && FileEditorManagerImpl.this.getSelectedEditor(descriptor.getFile()) == editor && (navigated = FileEditorManagerImpl.this.navigateAndSelectEditor((NavigatableFileEditor)editor, descriptor))); ++i$) {
                }
                if (!navigated) {
                    arr$ = editors;
                    len$ = arr$.length;
                    for (i$ = 0; !(i$ >= len$ || (editor = arr$[i$]) instanceof NavigatableFileEditor && FileEditorManagerImpl.this.getSelectedEditor(descriptor.getFile()) != editor && FileEditorManagerImpl.this.navigateAndSelectEditor((NavigatableFileEditor)editor, descriptor)); ++i$) {
                    }
                }
            }
        }, "", null);
        list = result;
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.openEditor must not return null");
    }

    private boolean navigateAndSelectEditor(NavigatableFileEditor editor, OpenFileDescriptor descriptor) {
        if (editor.canNavigateTo((Navigatable)descriptor)) {
            this.setSelectedEditor((FileEditor)editor);
            editor.navigateTo((Navigatable)descriptor);
            return true;
        }
        return false;
    }

    private void setSelectedEditor(FileEditor editor) {
        EditorWithProviderComposite composite = this.getEditorComposite(editor);
        if (composite == null) {
            return;
        }
        FileEditor[] editors = composite.getEditors();
        for (int i = 0; i < editors.length; ++i) {
            FileEditor each = editors[i];
            if (editor != each) continue;
            composite.setSelectedEditor(i);
            composite.getSelectedEditor().selectNotify();
            break;
        }
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.getProject must not return null");
        }
        return project;
    }

    public void registerExtraEditorDataProvider(final @NotNull EditorDataProvider provider, Disposable parentDisposable) {
        if (provider == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.registerExtraEditorDataProvider must not be null");
        }
        this.myDataProviders.add(provider);
        if (parentDisposable != null) {
            Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

                public void dispose() {
                    FileEditorManagerImpl.this.myDataProviders.remove(provider);
                }
            });
        }
    }

    @Nullable
    public final Object getData(String dataId, Editor editor, VirtualFile file) {
        for (EditorDataProvider dataProvider : this.myDataProviders) {
            Object o = dataProvider.getData(dataId, editor, file);
            if (o == null) continue;
            return o;
        }
        return null;
    }

    @Nullable
    public Editor openTextEditor(OpenFileDescriptor descriptor, boolean focusEditor) {
        List<FileEditor> fileEditors = this.openEditor(descriptor, focusEditor);
        for (FileEditor fileEditor : fileEditors) {
            if (!(fileEditor instanceof TextEditor)) continue;
            this.setSelectedEditor(descriptor.getFile(), TextEditorProvider.getInstance().getEditorTypeId());
            Editor editor = ((TextEditor)fileEditor).getEditor();
            return this.getOpenedEditor(editor, focusEditor);
        }
        return null;
    }

    protected Editor getOpenedEditor(Editor editor, boolean focusEditor) {
        return editor;
    }

    public Editor getSelectedTextEditor() {
        EditorWithProviderComposite selectedEditor;
        FileEditorManagerImpl.assertReadAccess();
        EditorWindow currentWindow = this.getSplitters().getCurrentWindow();
        if (currentWindow != null && (selectedEditor = currentWindow.getSelectedEditor()) != null && selectedEditor.getSelectedEditor() instanceof TextEditor) {
            return ((TextEditor)selectedEditor.getSelectedEditor()).getEditor();
        }
        return null;
    }

    public boolean isFileOpen(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.isFileOpen must not be null");
        }
        return this.getEditors(file).length != 0;
    }

    @NotNull
    public VirtualFile[] getOpenFiles() {
        VirtualFile[] virtualFileArray = this.getSplitters().getOpenFiles();
        if (virtualFileArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.getOpenFiles must not return null");
        }
        return virtualFileArray;
    }

    @NotNull
    public VirtualFile[] getSelectedFiles() {
        VirtualFile[] virtualFileArray = this.getSplitters().getSelectedFiles();
        if (virtualFileArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.getSelectedFiles must not return null");
        }
        return virtualFileArray;
    }

    @NotNull
    public FileEditor[] getSelectedEditors() {
        FileEditor[] fileEditorArray = this.getSplitters().getSelectedEditors();
        if (fileEditorArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.getSelectedEditors must not return null");
        }
        return fileEditorArray;
    }

    public FileEditor getSelectedEditor(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.getSelectedEditor must not be null");
        }
        Pair<FileEditor, FileEditorProvider> selectedEditorWithProvider = this.getSelectedEditorWithProvider(file);
        return selectedEditorWithProvider == null ? null : (FileEditor)selectedEditorWithProvider.getFirst();
    }

    @Override
    public Pair<FileEditor, FileEditorProvider> getSelectedEditorWithProvider(@NotNull VirtualFile file) {
        EditorWithProviderComposite composite;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.getSelectedEditorWithProvider must not be null");
        }
        if (file instanceof VirtualFileWindow) {
            file = ((VirtualFileWindow)file).getDelegate();
        }
        if ((composite = this.getCurrentEditorWithProviderComposite(file)) != null) {
            return composite.getSelectedEditorWithProvider();
        }
        List<EditorWithProviderComposite> composites = this.getEditorComposites(file);
        return composites.isEmpty() ? null : composites.get(0).getSelectedEditorWithProvider();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Pair<FileEditor[], FileEditorProvider[]> getEditorsWithProviders(@NotNull VirtualFile file) {
        Pair pair;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.getEditorsWithProviders must not be null");
        }
        FileEditorManagerImpl.assertReadAccess();
        EditorWithProviderComposite composite = this.getCurrentEditorWithProviderComposite(file);
        if (composite != null) {
            pair = Pair.create((Object)composite.getEditors(), (Object)composite.getProviders());
            if (pair == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.getEditorsWithProviders must not return null");
            return pair;
        }
        List<EditorWithProviderComposite> composites = this.getEditorComposites(file);
        if (!composites.isEmpty()) {
            pair = Pair.create((Object)composites.get(0).getEditors(), (Object)composites.get(0).getProviders());
            if (pair == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.getEditorsWithProviders must not return null");
            return pair;
        }
        pair = Pair.create((Object)EMPTY_EDITOR_ARRAY, (Object)EMPTY_PROVIDER_ARRAY);
        if (pair != null) return pair;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.getEditorsWithProviders must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public FileEditor[] getEditors(@NotNull VirtualFile file) {
        FileEditor[] fileEditorArray;
        EditorWithProviderComposite composite;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.getEditors must not be null");
        }
        FileEditorManagerImpl.assertReadAccess();
        if (file instanceof VirtualFileWindow) {
            file = ((VirtualFileWindow)file).getDelegate();
        }
        if ((composite = this.getCurrentEditorWithProviderComposite(file)) != null) {
            fileEditorArray = composite.getEditors();
            if (fileEditorArray == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.getEditors must not return null");
            return fileEditorArray;
        }
        List<EditorWithProviderComposite> composites = this.getEditorComposites(file);
        if (!composites.isEmpty()) {
            fileEditorArray = composites.get(0).getEditors();
            if (fileEditorArray == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.getEditors must not return null");
            return fileEditorArray;
        }
        fileEditorArray = EMPTY_EDITOR_ARRAY;
        if (EMPTY_EDITOR_ARRAY != null) return fileEditorArray;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.getEditors must not return null");
    }

    @NotNull
    public FileEditor[] getAllEditors(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.getAllEditors must not be null");
        }
        List<EditorWithProviderComposite> editorComposites = this.getEditorComposites(file);
        ArrayList<FileEditor> editors = new ArrayList<FileEditor>();
        for (EditorWithProviderComposite composite : editorComposites) {
            editors.addAll(Arrays.asList(composite.getEditors()));
        }
        FileEditor[] fileEditorArray = editors.toArray(new FileEditor[editors.size()]);
        if (fileEditorArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.getAllEditors must not return null");
        }
        return fileEditorArray;
    }

    @Nullable
    private EditorWithProviderComposite getCurrentEditorWithProviderComposite(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.getCurrentEditorWithProviderComposite must not be null");
        }
        EditorWindow editorWindow = this.getSplitters().getCurrentWindow();
        if (editorWindow != null) {
            return editorWindow.findFileComposite(virtualFile);
        }
        return null;
    }

    @NotNull
    public List<EditorWithProviderComposite> getEditorComposites(VirtualFile file) {
        List<EditorWithProviderComposite> list = this.getSplitters().findEditorComposites(file);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.getEditorComposites must not return null");
        }
        return list;
    }

    @NotNull
    public FileEditor[] getAllEditors() {
        EditorWithProviderComposite[] editorsComposites;
        FileEditorManagerImpl.assertReadAccess();
        ArrayList<FileEditor> result = new ArrayList<FileEditor>();
        for (EditorWithProviderComposite editorsComposite : editorsComposites = this.getSplitters().getEditorsComposites()) {
            FileEditor[] editors = editorsComposite.getEditors();
            result.addAll(Arrays.asList(editors));
        }
        FileEditor[] fileEditorArray = result.toArray(new FileEditor[result.size()]);
        if (fileEditorArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.getAllEditors must not return null");
        }
        return fileEditorArray;
    }

    public void showEditorAnnotation(@NotNull FileEditor editor, @NotNull JComponent annotationComponent) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.showEditorAnnotation must not be null");
        }
        if (annotationComponent == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.showEditorAnnotation must not be null");
        }
        EditorWithProviderComposite composite = this.getEditorComposite(editor);
        if (composite != null) {
            composite.getPane(editor).addInfo(annotationComponent);
        }
    }

    public void removeEditorAnnotation(@NotNull FileEditor editor, @NotNull JComponent annotationComponent) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.removeEditorAnnotation must not be null");
        }
        if (annotationComponent == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.removeEditorAnnotation must not be null");
        }
        EditorWithProviderComposite composite = this.getEditorComposite(editor);
        if (composite != null) {
            composite.getPane(editor).removeInfo(annotationComponent);
        }
    }

    public void addTopComponent(@NotNull FileEditor editor, @NotNull JComponent component) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.addTopComponent must not be null");
        }
        if (component == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.addTopComponent must not be null");
        }
        EditorWithProviderComposite composite = this.getEditorComposite(editor);
        if (composite != null) {
            composite.addTopComponent(editor, component);
        }
    }

    public void removeTopComponent(@NotNull FileEditor editor, @NotNull JComponent component) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.removeTopComponent must not be null");
        }
        if (component == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.removeTopComponent must not be null");
        }
        EditorWithProviderComposite composite = this.getEditorComposite(editor);
        if (composite != null) {
            composite.removeTopComponent(editor, component);
        }
    }

    public void addBottomComponent(@NotNull FileEditor editor, @NotNull JComponent component) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.addBottomComponent must not be null");
        }
        if (component == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.addBottomComponent must not be null");
        }
        EditorWithProviderComposite composite = this.getEditorComposite(editor);
        if (composite != null) {
            composite.addBottomComponent(editor, component);
        }
    }

    public void removeBottomComponent(@NotNull FileEditor editor, @NotNull JComponent component) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.removeBottomComponent must not be null");
        }
        if (component == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.removeBottomComponent must not be null");
        }
        EditorWithProviderComposite composite = this.getEditorComposite(editor);
        if (composite != null) {
            composite.removeBottomComponent(editor, component);
        }
    }

    public void addFileEditorManagerListener(@NotNull FileEditorManagerListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.addFileEditorManagerListener must not be null");
        }
        this.myListenerList.add((Object)listener);
    }

    public void addFileEditorManagerListener(@NotNull FileEditorManagerListener listener, Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.addFileEditorManagerListener must not be null");
        }
        this.myListenerList.add((Object)listener, parentDisposable);
    }

    public void removeFileEditorManagerListener(@NotNull FileEditorManagerListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.removeFileEditorManagerListener must not be null");
        }
        this.myListenerList.remove((Object)listener);
    }

    public void projectOpened() {
        this.getSplitters().startListeningFocus();
        MessageBusConnection connection = this.myProject.getMessageBus().connect((Disposable)this.myProject);
        FileStatusManager fileStatusManager = FileStatusManager.getInstance((Project)this.myProject);
        if (fileStatusManager != null) {
            MyFileStatusListener myFileStatusListener = new MyFileStatusListener();
            fileStatusManager.addFileStatusListener((FileStatusListener)myFileStatusListener, (Disposable)this.myProject);
        }
        connection.subscribe(AppTopics.FILE_TYPES, (Object)new MyFileTypeListener());
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new MyRootsListener());
        MyVirtualFileListener myVirtualFileListener = new MyVirtualFileListener();
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)myVirtualFileListener, (Disposable)this.myProject);
        final MyUISettingsListener myUISettingsListener = new MyUISettingsListener();
        UISettings.getInstance().addUISettingsListener((UISettingsListener)myUISettingsListener);
        Disposer.register((Disposable)this.myProject, (Disposable)new Disposable(){

            public void dispose() {
                UISettings.getInstance().removeUISettingsListener((UISettingsListener)myUISettingsListener);
            }
        });
        StartupManager.getInstance((Project)this.myProject).registerPostStartupActivity((Runnable)new DumbAwareRunnable(){

            public void run() {
                ToolWindowManager.getInstance((Project)FileEditorManagerImpl.this.myProject).invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CommandProcessor.getInstance().executeCommand(FileEditorManagerImpl.this.myProject, new Runnable(){

                            @Override
                            public void run() {
                                FileEditorManagerImpl.this.setTabsMode(UISettings.getInstance().EDITOR_TAB_PLACEMENT != 0);
                                FileEditorManagerImpl.this.getSplitters().openFiles();
                                LaterInvocator.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        long currentTime = System.nanoTime();
                                        Long startTime = (Long)FileEditorManagerImpl.this.myProject.getUserData(ProjectImpl.CREATION_TIME);
                                        if (startTime != null) {
                                            LOG.info("Project opening took " + (currentTime - startTime) / 1000000L + " ms");
                                            PluginManager.dumpPluginClassStatistics();
                                        }
                                    }
                                });
                            }
                        }, "", null);
                    }
                });
            }
        });
    }

    public void projectClosed() {
        this.getSplitters().dispose();
        this.closeAllFiles();
    }

    @NotNull
    public String getComponentName() {
        if ("FileEditorManager" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.getComponentName must not return null");
        }
        return "FileEditorManager";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public void writeExternal(Element element) {
        this.getSplitters().writeExternal(element);
    }

    public void readExternal(Element element) {
        this.getSplitters().readExternal(element);
    }

    private EditorWithProviderComposite getEditorComposite(@NotNull FileEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.getEditorComposite must not be null");
        }
        EditorWithProviderComposite[] editorsComposites = this.getSplitters().getEditorsComposites();
        for (int i = editorsComposites.length - 1; i >= 0; --i) {
            EditorWithProviderComposite composite = editorsComposites[i];
            FileEditor[] editors = composite.getEditors();
            for (int j = editors.length - 1; j >= 0; --j) {
                FileEditor _editor = editors[j];
                LOG.assertTrue(_editor != null);
                if (!editor.equals(_editor)) continue;
                return composite;
            }
        }
        return null;
    }

    private static void assertDispatchThread() {
        ApplicationManager.getApplication().assertIsDispatchThread();
    }

    private static void assertReadAccess() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
    }

    public void fireSelectionChanged(EditorComposite oldSelectedComposite, EditorComposite newSelectedComposite) {
        boolean editorsEqual;
        boolean filesEqual;
        FileEditor newSelectedEditor;
        VirtualFile oldSelectedFile = oldSelectedComposite != null ? oldSelectedComposite.getFile() : null;
        VirtualFile newSelectedFile = newSelectedComposite != null ? newSelectedComposite.getFile() : null;
        FileEditor oldSelectedEditor = oldSelectedComposite != null && !oldSelectedComposite.isDisposed() ? oldSelectedComposite.getSelectedEditor() : null;
        FileEditor fileEditor = newSelectedEditor = newSelectedComposite != null && !newSelectedComposite.isDisposed() ? newSelectedComposite.getSelectedEditor() : null;
        boolean bl = oldSelectedFile == null ? newSelectedFile == null : (filesEqual = oldSelectedFile.equals(newSelectedFile));
        boolean bl2 = oldSelectedEditor == null ? newSelectedEditor == null : (editorsEqual = oldSelectedEditor.equals(newSelectedEditor));
        if (!filesEqual || !editorsEqual) {
            FileEditorManagerEvent event = new FileEditorManagerEvent((FileEditorManager)this, oldSelectedFile, oldSelectedEditor, newSelectedFile, newSelectedEditor);
            FileEditorManagerListener publisher = (FileEditorManagerListener)this.getProject().getMessageBus().syncPublisher(FileEditorManagerListener.FILE_EDITOR_MANAGER);
            publisher.selectionChanged(event);
        }
    }

    @Override
    public boolean isChanged(@NotNull EditorComposite editor) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.isChanged must not be null");
        }
        FileStatusManager fileStatusManager = FileStatusManager.getInstance((Project)this.myProject);
        return fileStatusManager != null && !fileStatusManager.getStatus(editor.getFile()).equals(FileStatus.NOT_CHANGED);
    }

    public void disposeComposite(EditorWithProviderComposite editor) {
        if (this.getAllEditors().length == 0) {
            this.setCurrentWindow(null);
        }
        if (editor.equals(this.getLastSelected())) {
            editor.getSelectedEditor().deselectNotify();
            this.getSplitters().setCurrentWindow(null, false);
        }
        FileEditor[] editors = editor.getEditors();
        FileEditorProvider[] providers = editor.getProviders();
        FileEditor selectedEditor = editor.getSelectedEditor();
        for (int i = editors.length - 1; i >= 0; --i) {
            FileEditor editor1 = editors[i];
            FileEditorProvider provider = providers[i];
            if (!editor.equals(selectedEditor) && selectedEditor.equals(editor1)) {
                editor1.deselectNotify();
            }
            editor1.removePropertyChangeListener((PropertyChangeListener)this.myEditorPropertyChangeListener);
            provider.disposeEditor(editor1);
        }
        Disposer.dispose((Disposable)editor);
    }

    EditorComposite getLastSelected() {
        EditorWindow currentWindow = this.getSplitters().getCurrentWindow();
        if (currentWindow != null) {
            return currentWindow.getSelectedEditor();
        }
        return null;
    }

    public void runChange(Runnable runnable) {
        this.getSplitters().runChange(runnable);
    }

    @Override
    public boolean isInsideChange() {
        return this.getSplitters().isInsideChange();
    }

    @Override
    public void closeAllFiles() {
        VirtualFile[] openFiles;
        for (VirtualFile openFile : openFiles = this.getSplitters().getOpenFiles()) {
            this.closeFile(openFile);
        }
    }

    @Override
    @NotNull
    public VirtualFile[] getSiblings(VirtualFile file) {
        VirtualFile[] virtualFileArray = this.getOpenFiles();
        if (virtualFileArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl.getSiblings must not return null");
        }
        return virtualFileArray;
    }

    protected void queueUpdateFile(final VirtualFile file) {
        this.myQueue.queue(new Update(file){

            public void run() {
                if (FileEditorManagerImpl.this.isFileOpen(file)) {
                    FileEditorManagerImpl.this.updateFileIcon(file);
                    FileEditorManagerImpl.this.updateFileColor(file);
                    FileEditorManagerImpl.this.updateFileBackgroundColor(file);
                }
            }
        });
    }

    private final class MyUISettingsListener
    implements UISettingsListener {
        private MyUISettingsListener() {
        }

        public void uiSettingsChanged(UISettings source) {
            FileEditorManagerImpl.assertDispatchThread();
            FileEditorManagerImpl.this.setTabsMode(source.EDITOR_TAB_PLACEMENT != 0);
            FileEditorManagerImpl.this.getSplitters().setTabsPlacement(source.EDITOR_TAB_PLACEMENT);
            FileEditorManagerImpl.this.getSplitters().trimToSize(source.EDITOR_TAB_LIMIT);
            if (source.SCROLL_TAB_LAYOUT_IN_EDITOR) {
                FileEditorManagerImpl.this.getSplitters().setTabLayoutPolicy(1);
            } else {
                FileEditorManagerImpl.this.getSplitters().setTabLayoutPolicy(0);
            }
            VirtualFile[] openFiles = FileEditorManagerImpl.this.getOpenFiles();
            for (int i = openFiles.length - 1; i >= 0; --i) {
                VirtualFile file = openFiles[i];
                FileEditorManagerImpl.this.updateFileIcon(file);
                FileEditorManagerImpl.this.updateFileName(file);
                FileEditorManagerImpl.this.updateFileBackgroundColor(file);
            }
        }
    }

    private class MyRootsListener
    implements ModuleRootListener {
        private MyRootsListener() {
        }

        public void beforeRootsChange(ModuleRootEvent event) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rootsChanged(ModuleRootEvent event) {
            EditorFileSwapper[] swappers = (EditorFileSwapper[])Extensions.getExtensions(EditorFileSwapper.EP_NAME);
            for (EditorWindow eachWindow : FileEditorManagerImpl.this.getWindows()) {
                VirtualFile selected = eachWindow.getSelectedFile();
                VirtualFile[] files = eachWindow.getFiles();
                for (int i = 0; i < files.length - 1 + 1; ++i) {
                    VirtualFile eachFile = files[i];
                    VirtualFile newFile = null;
                    for (EditorFileSwapper each : swappers) {
                        newFile = each.getFileToSwapTo(FileEditorManagerImpl.this.myProject, eachFile);
                    }
                    if (newFile == null || eachWindow.findFileIndex(newFile) != -1) continue;
                    FileEditorManagerImpl.this.closeFile(eachFile, eachWindow);
                    try {
                        newFile.putUserData(EditorWindow.INITIAL_INDEX_KEY, (Object)i);
                        FileEditorManagerImpl.this.openFile(newFile, eachFile == selected);
                        continue;
                    }
                    finally {
                        newFile.putUserData(EditorWindow.INITIAL_INDEX_KEY, null);
                    }
                }
            }
        }
    }

    private final class MyFileTypeListener
    implements FileTypeListener {
        private MyFileTypeListener() {
        }

        public void beforeFileTypesChanged(FileTypeEvent event) {
        }

        public void fileTypesChanged(FileTypeEvent event) {
            FileEditorManagerImpl.assertDispatchThread();
            VirtualFile[] openFiles = FileEditorManagerImpl.this.getOpenFiles();
            for (int i = openFiles.length - 1; i >= 0; --i) {
                VirtualFile file = openFiles[i];
                LOG.assertTrue(file != null);
                FileEditorManagerImpl.this.updateFileIcon(file);
            }
        }
    }

    private final class MyFileStatusListener
    implements FileStatusListener {
        private MyFileStatusListener() {
        }

        public void fileStatusesChanged() {
            FileEditorManagerImpl.assertDispatchThread();
            LOG.debug("FileEditorManagerImpl.MyFileStatusListener.fileStatusesChanged()");
            VirtualFile[] openFiles = FileEditorManagerImpl.this.getOpenFiles();
            for (int i = openFiles.length - 1; i >= 0; --i) {
                final VirtualFile file = openFiles[i];
                LOG.assertTrue(file != null);
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("updating file status in tab for " + file.getPath());
                        }
                        MyFileStatusListener.this.updateFileStatus(file);
                    }
                }, ModalityState.NON_MODAL, FileEditorManagerImpl.this.myProject.getDisposed());
            }
        }

        public void fileStatusChanged(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$MyFileStatusListener.fileStatusChanged must not be null");
            }
            FileEditorManagerImpl.assertDispatchThread();
            if (FileEditorManagerImpl.this.isFileOpen(file)) {
                this.updateFileStatus(file);
            }
        }

        private void updateFileStatus(VirtualFile file) {
            FileEditorManagerImpl.this.updateFileColor(file);
            FileEditorManagerImpl.this.updateFileIcon(file);
        }
    }

    private final class MyEditorPropertyChangeListener
    implements PropertyChangeListener {
        private MyEditorPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            boolean valid;
            FileEditorManagerImpl.assertDispatchThread();
            String propertyName = e.getPropertyName();
            if ("modified".equals(propertyName)) {
                FileEditor editor = (FileEditor)e.getSource();
                EditorWithProviderComposite composite = FileEditorManagerImpl.this.getEditorComposite(editor);
                if (composite != null) {
                    FileEditorManagerImpl.this.updateFileIcon(composite.getFile());
                }
            } else if ("valid".equals(propertyName) && !(valid = ((Boolean)e.getNewValue()).booleanValue())) {
                FileEditor editor = (FileEditor)e.getSource();
                LOG.assertTrue(editor != null);
                EditorWithProviderComposite composite = FileEditorManagerImpl.this.getEditorComposite(editor);
                if (composite != null) {
                    FileEditorManagerImpl.this.closeFile(composite.getFile());
                }
            }
        }
    }

    private final class MyVirtualFileListener
    extends VirtualFileAdapter {
        private MyVirtualFileListener() {
        }

        public void beforeFileDeletion(VirtualFileEvent e) {
            FileEditorManagerImpl.assertDispatchThread();
            VirtualFile file = e.getFile();
            VirtualFile[] openFiles = FileEditorManagerImpl.this.getOpenFiles();
            for (int i = openFiles.length - 1; i >= 0; --i) {
                if (!VfsUtil.isAncestor((VirtualFile)file, (VirtualFile)openFiles[i], (boolean)false)) continue;
                FileEditorManagerImpl.this.closeFile(openFiles[i]);
            }
        }

        public void propertyChanged(VirtualFilePropertyEvent e) {
            if ("name".equals(e.getPropertyName())) {
                FileEditorManagerImpl.assertDispatchThread();
                VirtualFile file = e.getFile();
                if (FileEditorManagerImpl.this.isFileOpen(file)) {
                    FileEditorManagerImpl.this.updateFileName(file);
                    FileEditorManagerImpl.this.updateFileIcon(file);
                    FileEditorManagerImpl.this.updateFileBackgroundColor(file);
                }
            } else if ("writable".equals(e.getPropertyName()) || "encoding".equals(e.getPropertyName())) {
                this.updateIconAndStatusbar(e);
            }
        }

        private void updateIconAndStatusbar(VirtualFilePropertyEvent e) {
            FileEditorManagerImpl.assertDispatchThread();
            VirtualFile file = e.getFile();
            if (FileEditorManagerImpl.this.isFileOpen(file)) {
                FileEditorManagerImpl.this.updateFileIcon(file);
                if (file.equals(FileEditorManagerImpl.this.getSelectedFiles()[0])) {
                    StatusBarEx statusBar = (StatusBarEx)WindowManager.getInstance().getStatusBar(FileEditorManagerImpl.this.myProject);
                    assert (statusBar != null);
                    statusBar.update(FileEditorManagerImpl.this.getSelectedTextEditor());
                }
            }
        }

        public void fileMoved(VirtualFileMoveEvent e) {
            VirtualFile[] openFiles;
            VirtualFile file = e.getFile();
            for (VirtualFile openFile : openFiles = FileEditorManagerImpl.this.getOpenFiles()) {
                if (!VfsUtil.isAncestor((VirtualFile)file, (VirtualFile)openFile, (boolean)false)) continue;
                FileEditorManagerImpl.this.updateFileName(openFile);
                FileEditorManagerImpl.this.updateFileBackgroundColor(openFile);
            }
        }
    }
}

