/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.ex;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.ui.search.DefaultSearchableConfigurable;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ex.ControlPanelMnemonicsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectIntHashMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;

public class ExplorerSettingsEditor
extends DialogWrapper {
    private static final TObjectIntHashMap<String> ourGroup2LastConfigurableIndex = new TObjectIntHashMap();
    private static String ourLastGroup;
    private final Project myProject;
    private int myKeySelectedConfigurableIndex;
    private final ConfigurableGroup[] myGroups;
    private Configurable mySelectedConfigurable;
    private ConfigurableGroup mySelectedGroup;
    private JPanel myOptionsPanel;
    private final Map<Configurable, JComponent> myInitializedConfigurables2Component;
    private final Dimension myPreferredSize;
    private final Map<Configurable, Dimension> myConfigurable2PrefSize;
    private JButton myHelpButton;
    private JPanel myComponentPanel;
    private SearchUtil.ConfigurableSearchTextField mySearchField;
    private Set<Configurable> myOptionContainers = null;
    private final Alarm mySearchUpdater = new Alarm();
    private JTree myTree;
    @NonNls
    private final DefaultMutableTreeNode myRoot = new DefaultMutableTreeNode("Root");
    private static final Logger LOG;
    private final JBPopup[] myPopup = new JBPopup[2];
    private static final TObjectHashingStrategy<Configurable> UNWRAPPING_STRATEGY;
    private final Alarm myAlarm = new Alarm();

    public ExplorerSettingsEditor(Project project, ConfigurableGroup[] group) {
        super(project, true);
        this.myProject = project;
        this.myPreferredSize = new Dimension(800, 600);
        this.myGroups = group;
        if (this.myGroups.length == 0) {
            throw new IllegalStateException("number of configurables must be more then zero");
        }
        this.myInitializedConfigurables2Component = new THashMap(UNWRAPPING_STRATEGY);
        this.myConfigurable2PrefSize = new THashMap(UNWRAPPING_STRATEGY);
        this.init();
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.openapi.options.ex.ExplorerSettingsEditor";
    }

    protected final void init() {
        super.init();
        int lastGroup = 0;
        for (int i = 0; i < this.myGroups.length; ++i) {
            ConfigurableGroup group = this.myGroups[i];
            if (!Comparing.equal((String)group.getShortName(), (String)ourLastGroup)) continue;
            lastGroup = i;
            break;
        }
        this.selectGroup(lastGroup);
    }

    private void selectGroup(int groupIdx) {
        String shortName = this.myGroups[groupIdx].getShortName();
        int lastIndex = ourGroup2LastConfigurableIndex.get((Object)shortName);
        if (lastIndex == -1) {
            lastIndex = 0;
        }
        this.selectGroup(groupIdx, lastIndex);
    }

    private void selectGroup(int groupIdx, int indexToSelect) {
        this.rememberLastUsedPage();
        this.mySelectedGroup = this.myGroups[groupIdx];
        ourLastGroup = this.mySelectedGroup.getShortName();
        DefaultMutableTreeNode groupNode = (DefaultMutableTreeNode)this.myRoot.getChildAt(groupIdx);
        this.myTree.expandPath(new TreePath(groupNode.getPath()));
        TreeUtil.selectNode((JTree)this.myTree, (TreeNode)groupNode.getChildAt(indexToSelect));
        Configurable[] configurables = this.mySelectedGroup.getConfigurables();
        Configurable toSelect = configurables[indexToSelect];
        this.selectConfigurable(toSelect, indexToSelect);
        this.requestFocusForMainPanel();
    }

    private void rememberLastUsedPage() {
        if (this.mySelectedGroup != null) {
            Configurable[] configurables = this.mySelectedGroup.getConfigurables();
            int index = -1;
            for (int i = 0; i < configurables.length; ++i) {
                Configurable configurable = configurables[i];
                if (!UNWRAPPING_STRATEGY.equals((Object)configurable, (Object)this.mySelectedConfigurable)) continue;
                index = i;
                break;
            }
            ourGroup2LastConfigurableIndex.put((Object)this.mySelectedGroup.getShortName(), index);
        }
    }

    private void updateTitle() {
        if (this.mySelectedConfigurable == null) {
            this.setTitle(OptionsBundle.message((String)"settings.panel.title", (Object[])new Object[0]));
        } else {
            String displayName = this.mySelectedConfigurable.getDisplayName();
            this.setTitle(this.mySelectedGroup.getDisplayName() + " - " + (displayName != null ? displayName.replace('\n', ' ') : ""));
            if (this.myHelpButton != null) {
                this.myHelpButton.setEnabled(this.mySelectedConfigurable.getHelpTopic() != null);
            }
        }
    }

    protected boolean apply() {
        if (this.mySelectedConfigurable == null || !this.mySelectedConfigurable.isModified()) {
            return true;
        }
        try {
            this.mySelectedConfigurable.apply();
            return true;
        }
        catch (ConfigurationException e) {
            if (e.getMessage() != null) {
                Messages.showMessageDialog((String)e.getMessage(), (String)e.getTitle(), (Icon)Messages.getErrorIcon());
            }
            return false;
        }
    }

    public final void dispose() {
        for (JBPopup popup : this.myPopup) {
            if (popup == null) continue;
            popup.cancel();
        }
        this.mySearchUpdater.cancelAllRequests();
        this.myAlarm.cancelAllRequests();
        this.rememberLastUsedPage();
        for (Configurable configurable : this.myInitializedConfigurables2Component.keySet()) {
            configurable.disposeUIResources();
        }
        this.mySelectedConfigurable = null;
        this.myOptionContainers = null;
        this.myInitializedConfigurables2Component.clear();
        super.dispose();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myComponentPanel;
    }

    protected final JComponent createCenterPanel() {
        this.myComponentPanel = new JPanel(new BorderLayout());
        this.myOptionsPanel = new JPanel(new BorderLayout()){

            @Override
            public void updateUI() {
                super.updateUI();
                for (Configurable configurable : ExplorerSettingsEditor.this.myInitializedConfigurables2Component.keySet()) {
                    if (configurable.equals(ExplorerSettingsEditor.this.mySelectedConfigurable)) continue;
                    JComponent component = (JComponent)ExplorerSettingsEditor.this.myInitializedConfigurables2Component.get(configurable);
                    SwingUtilities.updateComponentTreeUI(component);
                }
            }
        };
        this.initTree();
        this.initToolbar();
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((JComponent)this.myTree);
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setVerticalScrollBarPolicy(20);
        TreeUtil.expandAll((JTree)this.myTree);
        Dimension preferredSize = new Dimension(this.myTree.getPreferredSize().width + 20, scrollPane.getPreferredSize().height);
        scrollPane.setPreferredSize(preferredSize);
        scrollPane.setMinimumSize(preferredSize);
        TreeUtil.collapseAll((JTree)this.myTree, (int)1);
        JPanel leftPane = new JPanel(new BorderLayout());
        leftPane.setBorder(BorderFactory.createRaisedBevelBorder());
        leftPane.add((Component)scrollPane, "Center");
        this.myComponentPanel.add((Component)leftPane, "West");
        this.myOptionsPanel.setBorder(BorderFactory.createEmptyBorder(15, 5, 2, 5));
        JScrollPane optionsScrollForTinyScreens = new JScrollPane(this.myOptionsPanel);
        optionsScrollForTinyScreens.setBorder(null);
        this.myComponentPanel.add((Component)optionsScrollForTinyScreens, "Center");
        optionsScrollForTinyScreens.setPreferredSize(this.myPreferredSize);
        this.myComponentPanel.setFocusable(true);
        final KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                Configurable[] configurables = ExplorerSettingsEditor.this.mySelectedGroup.getConfigurables();
                int index = ExplorerSettingsEditor.this.myKeySelectedConfigurableIndex;
                if (index == -1) {
                    return;
                }
                int keyCode = e.getKeyCode();
                if (keyCode == 38) {
                    int groupIdx;
                    if (--index == -1 && (groupIdx = ArrayUtil.find((Object[])ExplorerSettingsEditor.this.myGroups, (Object)ExplorerSettingsEditor.this.mySelectedGroup)) > 0) {
                        ExplorerSettingsEditor.this.selectGroup(groupIdx - 1, ExplorerSettingsEditor.this.myGroups[groupIdx - 1].getConfigurables().length - 1);
                        return;
                    }
                } else if (keyCode == 40) {
                    int groupIdx;
                    if (++index == configurables.length && (groupIdx = ArrayUtil.find((Object[])ExplorerSettingsEditor.this.myGroups, (Object)ExplorerSettingsEditor.this.mySelectedGroup)) < ExplorerSettingsEditor.this.myGroups.length - 1) {
                        ExplorerSettingsEditor.this.selectGroup(groupIdx + 1, 0);
                        return;
                    }
                } else {
                    Configurable configurableFromMnemonic = ControlPanelMnemonicsUtil.getConfigurableFromMnemonic(e, ExplorerSettingsEditor.this.myGroups);
                    if (configurableFromMnemonic == null) {
                        return;
                    }
                    int keyGroupIndex = -1;
                    ConfigurableGroup keyGroup = null;
                    int keyIndexInGroup = 0;
                    for (int i = 0; i < ExplorerSettingsEditor.this.myGroups.length; ++i) {
                        ConfigurableGroup group = ExplorerSettingsEditor.this.myGroups[i];
                        int ingroupIdx = ArrayUtil.find((Object[])group.getConfigurables(), (Object)configurableFromMnemonic);
                        if (ingroupIdx == -1) continue;
                        keyGroupIndex = i;
                        keyGroup = group;
                        keyIndexInGroup = ingroupIdx;
                        break;
                    }
                    if (ExplorerSettingsEditor.this.mySelectedGroup != keyGroup) {
                        ExplorerSettingsEditor.this.selectGroup(keyGroupIndex, keyIndexInGroup);
                        return;
                    }
                    index = ControlPanelMnemonicsUtil.getIndexFromKeycode(keyCode, ExplorerSettingsEditor.this.mySelectedGroup == ExplorerSettingsEditor.this.myGroups[0]);
                }
                if (index == -1 || index >= configurables.length) {
                    return;
                }
                TreeNode groupNode = ExplorerSettingsEditor.this.myRoot.getChildAt(ArrayUtil.find((Object[])ExplorerSettingsEditor.this.myGroups, (Object)ExplorerSettingsEditor.this.mySelectedGroup));
                TreeUtil.selectPath((JTree)ExplorerSettingsEditor.this.myTree, (TreePath)new TreePath(new TreeNode[]{ExplorerSettingsEditor.this.myRoot, groupNode, groupNode.getChildAt(index)}));
            }
        };
        this.myComponentPanel.addKeyListener(keyAdapter);
        Disposer.register((Disposable)this.myDisposable, (Disposable)new Disposable(){

            public void dispose() {
                ExplorerSettingsEditor.this.myComponentPanel.removeKeyListener(keyAdapter);
            }
        });
        return this.myComponentPanel;
    }

    private void initTree() {
        this.myTree = new JTree(this.myRoot){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                Dimension size = super.getPreferredScrollableViewportSize();
                size = new Dimension(size.width + 10, size.height);
                return size;
            }
        };
        this.myTree.setCellRenderer((TreeCellRenderer)new ColoredTreeCellRenderer(){
            {
                this.setFocusBorderAroundIcon(true);
            }

            public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (value instanceof DefaultMutableTreeNode) {
                    Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
                    if (userObject instanceof Pair) {
                        Pair configurableWithMnemonics = (Pair)userObject;
                        Configurable configurable = (Configurable)configurableWithMnemonics.first;
                        this.setIcon(configurable.getIcon());
                        this.append(configurable.getDisplayName().replaceAll("\n", " "), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                        this.append(" ( " + configurableWithMnemonics.second + " )", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    } else if (userObject instanceof String) {
                        this.setIcon(null);
                        this.append((String)userObject, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                    }
                }
            }
        });
        this.myTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode treeNode;
                Object userObject;
                Object node = ExplorerSettingsEditor.this.myTree.getLastSelectedPathComponent();
                if (node instanceof DefaultMutableTreeNode && (userObject = (treeNode = (DefaultMutableTreeNode)node).getUserObject()) instanceof Pair) {
                    Pair configurableWithMnemonic = (Pair)userObject;
                    Configurable configurable = (Configurable)configurableWithMnemonic.first;
                    TreeNode[] nodes = treeNode.getPath();
                    LOG.assertTrue(nodes != null && nodes.length > 0 && nodes[1] != null);
                    int groupIdx = ExplorerSettingsEditor.this.myRoot.getIndex(nodes[1]);
                    ExplorerSettingsEditor.this.selectConfigurableLater(configurable, ArrayUtil.find((Object[])ExplorerSettingsEditor.this.myGroups[groupIdx].getConfigurables(), (Object)configurable));
                    ExplorerSettingsEditor.this.rememberLastUsedPage();
                    ExplorerSettingsEditor.this.mySelectedGroup = ExplorerSettingsEditor.this.myGroups[groupIdx];
                    ourLastGroup = ExplorerSettingsEditor.this.mySelectedGroup.getShortName();
                }
            }
        });
        this.myTree.setRowHeight(32);
        TreeUtil.installActions((JTree)this.myTree);
        UIUtil.setLineStyleAngled((JTree)this.myTree);
        this.myTree.setShowsRootHandles(true);
        this.myTree.setRootVisible(false);
    }

    protected JComponent createNorthPanel() {
        Consumer<String> selectConfigurable = new Consumer<String>(){

            public void consume(String configurableId) {
                if (ExplorerSettingsEditor.this.myOptionContainers != null) {
                    for (int groupIdx = 0; groupIdx < ExplorerSettingsEditor.this.myGroups.length; ++groupIdx) {
                        ConfigurableGroup group = ExplorerSettingsEditor.this.myGroups[groupIdx];
                        Configurable[] configurables = group.getConfigurables();
                        int idx = 0;
                        for (Configurable configurable : configurables) {
                            if (!ExplorerSettingsEditor.this.myOptionContainers.contains(configurable)) continue;
                            if (Comparing.strEqual((String)configurable.getDisplayName(), (String)configurableId)) {
                                ExplorerSettingsEditor.this.rememberLastUsedPage();
                                ExplorerSettingsEditor.this.mySelectedGroup = ExplorerSettingsEditor.this.myGroups[groupIdx];
                                ourLastGroup = ExplorerSettingsEditor.this.mySelectedGroup.getShortName();
                                DefaultMutableTreeNode groupNode = (DefaultMutableTreeNode)ExplorerSettingsEditor.this.myRoot.getChildAt(groupIdx);
                                ExplorerSettingsEditor.this.myTree.expandPath(new TreePath(groupNode.getPath()));
                                TreeUtil.selectNode((JTree)ExplorerSettingsEditor.this.myTree, (TreeNode)groupNode.getChildAt(idx));
                                ExplorerSettingsEditor.this.selectConfigurable(configurable, idx);
                                ExplorerSettingsEditor.this.requestFocusForMainPanel();
                                return;
                            }
                            ++idx;
                        }
                    }
                }
            }
        };
        final SearchableOptionsRegistrar optionsRegistrar = SearchableOptionsRegistrar.getInstance();
        final JPanel panel = new JPanel(new GridBagLayout());
        this.mySearchField = new SearchUtil.ConfigurableSearchTextField();
        final DocumentAdapter documentAdapter = new DocumentAdapter((Consumer)selectConfigurable){
            final /* synthetic */ Consumer val$selectConfigurable;
            {
                this.val$selectConfigurable = consumer;
            }

            protected void textChanged(final DocumentEvent e) {
                ExplorerSettingsEditor.this.mySearchUpdater.cancelAllRequests();
                ExplorerSettingsEditor.this.mySearchUpdater.addRequest(new Runnable(){

                    @Override
                    public void run() {
                        String searchPattern = ExplorerSettingsEditor.this.mySearchField.getText();
                        if (searchPattern != null && searchPattern.length() > 0) {
                            ExplorerSettingsEditor.this.myOptionContainers = optionsRegistrar.getConfigurables(ExplorerSettingsEditor.this.myGroups, e.getType(), ExplorerSettingsEditor.this.myOptionContainers, searchPattern, ExplorerSettingsEditor.this.myProject).getContentHits();
                        } else {
                            ExplorerSettingsEditor.this.myOptionContainers = null;
                        }
                        SearchUtil.showHintPopup(ExplorerSettingsEditor.this.mySearchField, ExplorerSettingsEditor.this.myPopup, ExplorerSettingsEditor.this.mySearchUpdater, (Consumer<String>)val$selectConfigurable, ExplorerSettingsEditor.this.myProject);
                        ExplorerSettingsEditor.this.initToolbar();
                        TreeUtil.expandAll((JTree)ExplorerSettingsEditor.this.myTree);
                        if (ExplorerSettingsEditor.this.mySelectedConfigurable instanceof SearchableConfigurable) {
                            ExplorerSettingsEditor.this.selectOption(new DefaultSearchableConfigurable((SearchableConfigurable)ExplorerSettingsEditor.this.mySelectedConfigurable));
                        }
                        ExplorerSettingsEditor.this.myComponentPanel.revalidate();
                        ExplorerSettingsEditor.this.myComponentPanel.repaint();
                    }
                }, 300, ModalityState.defaultModalityState());
            }
        };
        this.mySearchField.addDocumentListener((DocumentListener)documentAdapter);
        Disposer.register((Disposable)this.myDisposable, (Disposable)new Disposable(){

            public void dispose() {
                if (ExplorerSettingsEditor.this.mySearchField != null) {
                    panel.remove((Component)((Object)ExplorerSettingsEditor.this.mySearchField));
                    ExplorerSettingsEditor.this.mySearchField.removeDocumentListener((DocumentListener)documentAdapter);
                    ExplorerSettingsEditor.this.mySearchField = null;
                }
            }
        });
        SearchUtil.registerKeyboardNavigation(this.mySearchField, this.myPopup, this.mySearchUpdater, selectConfigurable, this.myProject);
        GridBagConstraints gc = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0);
        panel.add((Component)Box.createHorizontalBox(), gc);
        ++gc.gridx;
        gc.weightx = 0.0;
        gc.fill = 0;
        JLabel label = new JLabel(IdeBundle.message((String)"search.textfield.title", (Object[])new Object[0]));
        panel.add((Component)label, gc);
        label.setLabelFor((Component)((Object)this.mySearchField));
        ++gc.gridx;
        int height = this.mySearchField.getPreferredSize().height;
        this.mySearchField.setPreferredSize(new Dimension(100, height));
        panel.add((Component)((Object)this.mySearchField), gc);
        return panel;
    }

    private void requestFocusForMainPanel() {
        this.myComponentPanel.requestFocus();
    }

    private void initToolbar() {
        this.myRoot.removeAllChildren();
        int mnemonicStartChar = 49;
        for (ConfigurableGroup group : this.myGroups) {
            DefaultMutableTreeNode groupNode = new DefaultMutableTreeNode(group.getDisplayName());
            Configurable[] configurables = group.getConfigurables();
            for (int i = 0; i < configurables.length; ++i) {
                Configurable configurable = configurables[i];
                if (this.myOptionContainers != null && !this.myOptionContainers.contains(configurable)) continue;
                groupNode.add(new DefaultMutableTreeNode(Pair.create((Object)configurable, (Object)Character.valueOf((char)(mnemonicStartChar + i)))));
            }
            mnemonicStartChar = 65;
            this.myRoot.add(groupNode);
        }
        ((DefaultTreeModel)this.myTree.getModel()).reload();
    }

    private void selectConfigurableLater(final Configurable configurable, final int index) {
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                if (ExplorerSettingsEditor.this.isShowing()) {
                    ExplorerSettingsEditor.this.selectConfigurable(configurable, index);
                }
            }
        }, 400);
        this.myKeySelectedConfigurableIndex = index;
        this.myComponentPanel.repaint();
    }

    private void selectConfigurable(Configurable configurable, int index) {
        Dimension compPrefSize;
        JComponent component;
        Dimension savedPrefferedSize;
        int exitCode;
        if (configurable == null) {
            this.mySelectedConfigurable = null;
            this.myKeySelectedConfigurableIndex = 0;
            this.updateTitle();
            this.myOptionsPanel.removeAll();
            this.validate();
            this.repaint();
            return;
        }
        Dimension currentOptionsSize = this.myOptionsPanel.getSize();
        if (this.mySelectedConfigurable != null && this.mySelectedConfigurable.isModified() && (exitCode = Messages.showYesNoDialog((String)OptionsBundle.message((String)"options.page.modified.save.message.text", (Object[])new Object[0]), (String)OptionsBundle.message((String)"options.save.changes.message.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon())) == 0) {
            try {
                this.mySelectedConfigurable.apply();
            }
            catch (ConfigurationException exc) {
                if (exc.getMessage() != null) {
                    Messages.showMessageDialog((String)exc.getMessage(), (String)exc.getTitle(), (Icon)Messages.getErrorIcon());
                }
                return;
            }
        }
        if (this.mySelectedConfigurable != null && (savedPrefferedSize = this.myConfigurable2PrefSize.get(this.mySelectedConfigurable)) != null) {
            this.myConfigurable2PrefSize.put(this.mySelectedConfigurable, new Dimension(currentOptionsSize));
        }
        this.myComponentPanel.setCursor(Cursor.getPredefinedCursor(3));
        this.myOptionsPanel.removeAll();
        this.mySelectedConfigurable = configurable;
        this.myKeySelectedConfigurableIndex = index;
        if (configurable instanceof SearchableConfigurable) {
            configurable = new DefaultSearchableConfigurable((SearchableConfigurable)configurable);
        }
        if ((component = this.myInitializedConfigurables2Component.get(configurable)) == null) {
            component = configurable.createComponent();
            this.myInitializedConfigurables2Component.put(configurable, component);
        }
        if (this.myConfigurable2PrefSize.containsKey(configurable)) {
            compPrefSize = this.myConfigurable2PrefSize.get(configurable);
        } else {
            compPrefSize = component.getPreferredSize();
            this.myConfigurable2PrefSize.put(configurable, compPrefSize);
        }
        int widthDelta = Math.max(compPrefSize.width - currentOptionsSize.width, 0);
        int heightDelta = Math.max(compPrefSize.height - currentOptionsSize.height, 0);
        this.myOptionsPanel.add((Component)component, "Center");
        if (widthDelta > 0 || heightDelta > 0) {
            this.setSize(this.getSize().width + widthDelta, this.getSize().height + heightDelta);
        }
        configurable.reset();
        this.updateTitle();
        this.validate();
        this.repaint();
        this.requestFocusForMainPanel();
        this.myComponentPanel.setCursor(Cursor.getPredefinedCursor(0));
        if (configurable instanceof DefaultSearchableConfigurable) {
            this.selectOption((DefaultSearchableConfigurable)configurable);
        }
    }

    private void selectOption(DefaultSearchableConfigurable searchableConfigurable) {
        searchableConfigurable.clearSearch();
        if (this.myOptionContainers == null || this.myOptionContainers.isEmpty()) {
            return;
        }
        String filter = this.mySearchField.getText();
        if (filter != null && filter.length() > 0) {
            searchableConfigurable.enableSearch(filter);
        }
    }

    protected final Action[] createActions() {
        return new Action[]{this.getOKAction(), this.getCancelAction(), new ApplyAction(), this.getHelpAction()};
    }

    protected JButton createJButtonForAction(Action action) {
        JButton button = super.createJButtonForAction(action);
        if (action == this.getHelpAction()) {
            this.myHelpButton = button;
        }
        return button;
    }

    protected Action[] createLeftSideActions() {
        return new Action[]{new SwitchToDefaultViewAction()};
    }

    protected final void doOKAction() {
        boolean ok = this.apply();
        if (ok) {
            super.doOKAction();
        }
    }

    protected final void doHelpAction() {
        String helpTopic;
        if (this.mySelectedConfigurable != null && (helpTopic = this.mySelectedConfigurable.getHelpTopic()) != null) {
            HelpManager.getInstance().invokeHelp(helpTopic);
        }
    }

    private void switchToDefaultView(Configurable preselectedConfigurable) {
        if (preselectedConfigurable != null) {
            preselectedConfigurable.disposeUIResources();
        }
        this.close(0);
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                ShowSettingsUtilImpl.showControlPanelOptions(ExplorerSettingsEditor.this.myProject, ExplorerSettingsEditor.this.myGroups, null);
            }
        }, ModalityState.NON_MODAL);
    }

    static {
        LOG = Logger.getInstance((String)"#com.intellij.openapi.options.ex.ExplorerSettingsEditor");
        UNWRAPPING_STRATEGY = new TObjectHashingStrategy<Configurable>(){

            public int computeHashCode(Configurable c) {
                return this.unwrap(c).hashCode();
            }

            public boolean equals(Configurable c1, Configurable c2) {
                return this.unwrap(c1) == this.unwrap(c2);
            }

            private Configurable unwrap(Configurable c) {
                if (c instanceof DefaultSearchableConfigurable) {
                    return ((DefaultSearchableConfigurable)c).getDelegate();
                }
                return c;
            }
        };
    }

    private class SwitchToDefaultViewAction
    extends AbstractAction {
        public SwitchToDefaultViewAction() {
            this.putValue("Name", OptionsBundle.message((String)"explorer.panel.default.view.button", (Object[])new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ExplorerSettingsEditor.this.switchToDefaultView(ExplorerSettingsEditor.this.mySelectedConfigurable);
        }
    }

    private final class ApplyAction
    extends AbstractAction {
        private final Alarm myUpdateAlarm;

        public ApplyAction() {
            super(OptionsBundle.message((String)"options.apply.button", (Object[])new Object[0]));
            this.myUpdateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
            Runnable updateRequest = new Runnable(){

                @Override
                public void run() {
                    if (!ExplorerSettingsEditor.this.isShowing()) {
                        return;
                    }
                    ApplyAction.this.setEnabled(ExplorerSettingsEditor.this.mySelectedConfigurable != null && ExplorerSettingsEditor.this.mySelectedConfigurable.isModified());
                    ApplyAction.this.addUpdateRequest(this);
                }
            };
            this.addUpdateRequest(updateRequest);
        }

        private void addUpdateRequest(Runnable updateRequest) {
            this.myUpdateAlarm.addRequest(updateRequest, 500, ModalityState.stateForComponent((Component)ExplorerSettingsEditor.this.getWindow()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            if (ExplorerSettingsEditor.this.myPerformAction) {
                return;
            }
            ExplorerSettingsEditor.this.myPerformAction = true;
            try {
                if (ExplorerSettingsEditor.this.apply()) {
                    ExplorerSettingsEditor.this.setCancelButtonText(CommonBundle.getCloseButtonText());
                }
            }
            finally {
                ExplorerSettingsEditor.this.myPerformAction = false;
            }
        }
    }
}

