/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts;

import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorEx;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactsStructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElementUsage;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.PackagingElement;
import javax.swing.Icon;

public class UsageInArtifact
extends ProjectStructureElementUsage {
    private Artifact myOriginalArtifact;
    private final ArtifactsStructureConfigurableContext myContext;
    private ProjectStructureElement mySourceElement;
    private ProjectStructureElement myContainingElement;
    private final String myParentPath;
    private final PackagingElement<?> myPackagingElement;

    public UsageInArtifact(Artifact originalArtifact, ArtifactsStructureConfigurableContext context, ProjectStructureElement sourceElement, ArtifactProjectStructureElement containingElement, String parentPath, PackagingElement<?> packagingElement) {
        this.myOriginalArtifact = originalArtifact;
        this.myContext = context;
        this.mySourceElement = sourceElement;
        this.myContainingElement = containingElement;
        this.myParentPath = parentPath;
        this.myPackagingElement = packagingElement;
    }

    @Override
    public ProjectStructureElement getSourceElement() {
        return this.mySourceElement;
    }

    @Override
    public ProjectStructureElement getContainingElement() {
        return this.myContainingElement;
    }

    @Override
    public void navigate() {
        final Artifact artifact = this.myContext.getArtifactModel().getArtifactByOriginal(this.myOriginalArtifact);
        ProjectStructureConfigurable.getInstance(this.myContext.getProject()).select(this.myOriginalArtifact, true).doWhenDone(new Runnable(){

            @Override
            public void run() {
                ArtifactEditorEx artifactEditor = (ArtifactEditorEx)UsageInArtifact.this.myContext.getOrCreateEditor(artifact);
                artifactEditor.getLayoutTreeComponent().selectNode(UsageInArtifact.this.myParentPath, UsageInArtifact.this.myPackagingElement);
            }
        });
    }

    @Override
    public String getPresentableName() {
        return this.myOriginalArtifact.getName();
    }

    @Override
    public int hashCode() {
        return this.myOriginalArtifact.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof UsageInArtifact && ((UsageInArtifact)obj).myOriginalArtifact.equals(this.myOriginalArtifact);
    }

    @Override
    public Icon getIcon() {
        return this.myOriginalArtifact.getArtifactType().getIcon();
    }
}

