/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.nodes;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorImpl;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactProblemDescription;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.ArtifactsTreeNode;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.CompositePackagingElementNode;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.PackagingNodeSource;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemDescription;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.TreeNodePresentation;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.StringBuilderSpinAllocator;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackagingElementNode<E extends PackagingElement<?>>
extends ArtifactsTreeNode {
    private final List<E> myPackagingElements;
    private final Map<PackagingElement<?>, CompositePackagingElement<?>> myParentElements;
    private final MultiValuesMap<PackagingElement<?>, PackagingNodeSource> myNodeSources;
    private final CompositePackagingElementNode myParentNode;

    public PackagingElementNode(@NotNull E packagingElement, ArtifactEditorContext context, @Nullable CompositePackagingElementNode parentNode, @Nullable CompositePackagingElement<?> parentElement, @NotNull Collection<PackagingNodeSource> nodeSources) {
        if (packagingElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/nodes/PackagingElementNode.<init> must not be null");
        }
        if (nodeSources == null) {
            throw new IllegalArgumentException("Argument 4 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/nodes/PackagingElementNode.<init> must not be null");
        }
        super(context, (NodeDescriptor)parentNode, (TreeNodePresentation)packagingElement.createPresentation(context));
        this.myParentElements = new HashMap(1);
        this.myNodeSources = new MultiValuesMap();
        this.myParentNode = parentNode;
        this.myParentElements.put((PackagingElement<?>)packagingElement, parentElement);
        this.myNodeSources.putAll(packagingElement, nodeSources);
        this.myPackagingElements = new SmartList();
        this.doAddElement(packagingElement);
    }

    private void doAddElement(E packagingElement) {
        this.myPackagingElements.add(packagingElement);
    }

    @Nullable
    public CompositePackagingElement<?> getParentElement(PackagingElement<?> element) {
        return this.myParentElements.get(element);
    }

    @Nullable
    public CompositePackagingElementNode getParentNode() {
        return this.myParentNode;
    }

    public List<E> getPackagingElements() {
        return this.myPackagingElements;
    }

    @Nullable
    public E getElementIfSingle() {
        return (E)(this.myPackagingElements.size() == 1 ? (PackagingElement)this.myPackagingElements.get(0) : null);
    }

    public Object[] getEqualityObjects() {
        return ArrayUtil.toObjectArray(this.myPackagingElements);
    }

    protected SimpleNode[] buildChildren() {
        return NO_CHILDREN;
    }

    public E getFirstElement() {
        return (E)((PackagingElement)this.myPackagingElements.get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void update(PresentationData presentation) {
        String tooltip;
        Collection<ArtifactProblemDescription> problems = ((ArtifactEditorImpl)this.myContext.getThisArtifactEditor()).getValidationManager().getProblems(this);
        if (problems == null || problems.isEmpty()) {
            super.update(presentation);
            return;
        }
        StringBuilder buffer = StringBuilderSpinAllocator.alloc();
        boolean isError = false;
        try {
            buffer.append("<html>");
            for (ArtifactProblemDescription problem : problems) {
                isError |= problem.getSeverity() == ProjectStructureProblemDescription.Severity.ERROR;
                buffer.append(problem.getMessage()).append("<br>");
            }
            buffer.append("</html>");
            tooltip = buffer.toString();
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)buffer);
        }
        this.getElementPresentation().render(presentation, PackagingElementNode.addErrorHighlighting(isError, SimpleTextAttributes.REGULAR_ATTRIBUTES), PackagingElementNode.addErrorHighlighting(isError, SimpleTextAttributes.GRAY_ATTRIBUTES));
        presentation.setTooltip(tooltip);
    }

    private static SimpleTextAttributes addErrorHighlighting(boolean error, SimpleTextAttributes attributes) {
        TextAttributes textAttributes = attributes.toTextAttributes();
        textAttributes.setEffectType(EffectType.WAVE_UNDERSCORE);
        textAttributes.setEffectColor(error ? Color.RED : Color.GRAY);
        return SimpleTextAttributes.fromTextAttributes((TextAttributes)textAttributes);
    }

    void addElement(PackagingElement<?> element, CompositePackagingElement parentElement, Collection<PackagingNodeSource> nodeSource) {
        this.doAddElement(element);
        this.myParentElements.put(element, parentElement);
        this.myNodeSources.putAll(element, nodeSource);
    }

    @NotNull
    public Collection<PackagingNodeSource> getNodeSources() {
        Collection collection = this.myNodeSources.values();
        if (collection == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/artifacts/nodes/PackagingElementNode.getNodeSources must not return null");
        }
        return collection;
    }

    @NotNull
    public Collection<PackagingNodeSource> getNodeSource(@NotNull PackagingElement<?> element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/nodes/PackagingElementNode.getNodeSource must not be null");
        }
        List<PackagingNodeSource> nodeSources = this.myNodeSources.get(element);
        List<PackagingNodeSource> list = nodeSources != null ? nodeSources : Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/configuration/artifacts/nodes/PackagingElementNode.getNodeSource must not return null");
        }
        return list;
    }

    public ArtifactEditorContext getContext() {
        return this.myContext;
    }

    @Nullable
    public CompositePackagingElementNode findCompositeChild(@NotNull String name) {
        SimpleNode[] children;
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/roots/ui/configuration/artifacts/nodes/PackagingElementNode.findCompositeChild must not be null");
        }
        for (SimpleNode child : children = this.getChildren()) {
            CompositePackagingElementNode composite;
            if (!(child instanceof CompositePackagingElementNode) || !name.equals(((CompositePackagingElement)(composite = (CompositePackagingElementNode)child).getFirstElement()).getName())) continue;
            return composite;
        }
        return null;
    }

    public List<PackagingElementNode<?>> getNodesByPath(List<PackagingElement<?>> pathToPlace) {
        SimpleNode[] children;
        ArrayList result = new ArrayList();
        PackagingElementNode current = this;
        result.add(current);
        for (int i = 0; current != null && i < pathToPlace.size() && (children = current.getCached()) != null; ++i) {
            PackagingElementNode next = null;
            PackagingElement<?> element = pathToPlace.get(i);
            block1: for (SimpleNode child : children) {
                if (!(child instanceof PackagingElementNode)) continue;
                PackagingElementNode childNode = (PackagingElementNode)child;
                for (PackagingElement childElement : childNode.getPackagingElements()) {
                    if (!childElement.isEqualTo(element)) continue;
                    next = childNode;
                    break block1;
                }
                for (PackagingNodeSource nodeSource : childNode.getNodeSources()) {
                    if (!nodeSource.getSourceElement().isEqualTo(element)) continue;
                    next = current;
                    break block1;
                }
            }
            if ((current = next) == null) continue;
            result.add(current);
        }
        return result;
    }
}

