/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryElementDescriptor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryTableEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryTableTreeContentElement;

public class LibraryElement
extends LibraryTableTreeContentElement {
    private final Library myLibrary;
    private final LibraryTableEditor myParentEditor;
    private final boolean myHasInvalidPaths;

    public LibraryElement(Library library, LibraryTableEditor parentEditor, boolean hasInvalidPaths) {
        this.myLibrary = library;
        this.myParentEditor = parentEditor;
        this.myHasInvalidPaths = hasInvalidPaths;
    }

    public Library getLibrary() {
        return this.myLibrary;
    }

    public boolean isAnonymous() {
        String name = this.myParentEditor.getLibraryEditor(this.myLibrary).getName();
        return name == null;
    }

    public boolean hasInvalidPaths() {
        return this.myHasInvalidPaths;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LibraryElement)) {
            return false;
        }
        LibraryElement libraryElement = (LibraryElement)o;
        return this.myLibrary.equals(libraryElement.myLibrary);
    }

    public int hashCode() {
        return this.myLibrary.hashCode();
    }

    @Override
    public LibraryTableTreeContentElement getParent() {
        return null;
    }

    @Override
    public OrderRootType getOrderRootType() {
        return null;
    }

    @Override
    public NodeDescriptor createDescriptor(NodeDescriptor parentDescriptor, LibraryTableEditor parentEditor) {
        return new LibraryElementDescriptor(parentDescriptor, this, parentEditor);
    }
}

