/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.actions.AbstractVcsAction;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;

public abstract class ShowChangeMarkerAction
extends AbstractVcsAction {
    protected final ChangeMarkerContext myChangeMarkerContext;

    protected abstract Range extractRange(LineStatusTracker var1, int var2, Editor var3);

    public ShowChangeMarkerAction(final Range range, final LineStatusTracker lineStatusTracker, final Editor editor) {
        this.myChangeMarkerContext = new ChangeMarkerContext(){

            @Override
            public Range getRange(VcsContext dataContext) {
                return range;
            }

            @Override
            public LineStatusTracker getLineStatusTracker(VcsContext dataContext) {
                return lineStatusTracker;
            }

            @Override
            public Editor getEditor(VcsContext dataContext) {
                return editor;
            }
        };
    }

    protected boolean forceSyncUpdate(AnActionEvent e) {
        return true;
    }

    public ShowChangeMarkerAction() {
        this.myChangeMarkerContext = new ChangeMarkerContext(){

            @Override
            public Range getRange(VcsContext context) {
                Editor editor = this.getEditor(context);
                if (editor == null) {
                    return null;
                }
                LineStatusTracker lineStatusTracker = this.getLineStatusTracker(context);
                if (lineStatusTracker == null) {
                    return null;
                }
                return ShowChangeMarkerAction.this.extractRange(lineStatusTracker, editor.getCaretModel().getLogicalPosition().line, editor);
            }

            @Override
            public LineStatusTracker getLineStatusTracker(VcsContext dataContext) {
                Editor editor = this.getEditor(dataContext);
                if (editor == null) {
                    return null;
                }
                Project project = dataContext.getProject();
                if (project == null) {
                    return null;
                }
                return LineStatusTrackerManager.getInstance(project).getLineStatusTracker(editor.getDocument());
            }

            @Override
            public Editor getEditor(VcsContext dataContext) {
                return dataContext.getEditor();
            }
        };
    }

    private boolean isActive(VcsContext context) {
        return this.myChangeMarkerContext.getRange(context) != null;
    }

    @Override
    protected void update(VcsContext context, Presentation presentation) {
        presentation.setEnabled(this.isActive(context));
    }

    @Override
    protected void actionPerformed(VcsContext context) {
        Editor editor = this.myChangeMarkerContext.getEditor(context);
        LineStatusTracker lineStatusTracker = this.myChangeMarkerContext.getLineStatusTracker(context);
        Range range = this.myChangeMarkerContext.getRange(context);
        lineStatusTracker.moveToRange(range, editor);
    }

    protected static interface ChangeMarkerContext {
        public Range getRange(VcsContext var1);

        public LineStatusTracker getLineStatusTracker(VcsContext var1);

        public Editor getEditor(VcsContext var1);
    }
}

