/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.lifecycle.AtomicSectionsAware;
import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.Semaphore;

public class ExecutorWrapper {
    private final Project myProject;
    private final String myName;
    private final Semaphore mySemaphore;
    private volatile boolean myDisposeStarted;
    private final Object myLock;
    private boolean myInProgress;
    private Runnable myStopper;
    private Thread myCurrentWorker;
    private AtomicSectionsAware myAtomicSectionsAware;

    protected ExecutorWrapper(Project project, String name) {
        this.myProject = project;
        this.myName = name;
        this.myLock = new Object();
        this.mySemaphore = new Semaphore();
        this.myStopper = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = ExecutorWrapper.this.myLock;
                synchronized (object) {
                    ExecutorWrapper.this.myDisposeStarted = true;
                    if (ExecutorWrapper.this.myCurrentWorker != null) {
                        ExecutorWrapper.this.myCurrentWorker.interrupt();
                    }
                    ExecutorWrapper.this.taskFinished();
                }
            }
        };
        this.myAtomicSectionsAware = new AtomicSectionsAware(){

            @Override
            public void checkShouldExit() throws ProcessCanceledException {
                if (ExecutorWrapper.this.myDisposeStarted) {
                    throw new ProcessCanceledException();
                }
            }

            @Override
            public void enter() {
            }

            @Override
            public void exit() {
            }

            @Override
            public boolean shouldExitAsap() {
                return ExecutorWrapper.this.myDisposeStarted;
            }
        };
        this.myDisposeStarted = !PeriodicalTasksCloser.getInstance(this.myProject).register(this.myName, this.myStopper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void taskFinished() {
        Object object = this.myLock;
        synchronized (object) {
            this.myCurrentWorker = null;
            if (this.myInProgress) {
                this.myInProgress = false;
                this.mySemaphore.up();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submit(final Consumer<AtomicSectionsAware> runnable) {
        try {
            Object object = this.myLock;
            synchronized (object) {
                block9: {
                    if (!this.myDisposeStarted) break block9;
                    return;
                }
                assert (!this.myInProgress);
                this.myInProgress = true;
                this.mySemaphore.down();
            }
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = ExecutorWrapper.this.myLock;
                    synchronized (object) {
                        ExecutorWrapper.this.myCurrentWorker = Thread.currentThread();
                    }
                    try {
                        runnable.consume((Object)ExecutorWrapper.this.myAtomicSectionsAware);
                    }
                    finally {
                        ExecutorWrapper.this.taskFinished();
                    }
                }
            });
            this.mySemaphore.waitFor();
        }
        finally {
            this.taskFinished();
        }
    }
}

