/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.BinaryContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.CommitSession;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.patch.CreatePatchCommitExecutor;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangesViewManager;
import com.intellij.openapi.vcs.changes.ui.SessionDialog;
import java.util.ArrayList;
import java.util.Collections;

public class CreatePatchFromChangesAction
extends AnAction
implements DumbAware {
    public CreatePatchFromChangesAction() {
        super(VcsBundle.message((String)"action.name.create.patch.for.selected.revisions", (Object[])new Object[0]), VcsBundle.message((String)"action.description.create.patch.for.selected.revisions", (Object[])new Object[0]), IconLoader.getIcon((String)"/actions/createPatch.png"));
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        Change[] changes = (Change[])e.getData(VcsDataKeys.CHANGES);
        if (changes == null || changes.length == 0) {
            return;
        }
        String commitMessage = "";
        ShelvedChangeList[] shelvedChangeLists = (ShelvedChangeList[])e.getData(ShelvedChangesViewManager.SHELVED_CHANGELIST_KEY);
        if (shelvedChangeLists != null && shelvedChangeLists.length > 0) {
            commitMessage = shelvedChangeLists[0].DESCRIPTION;
        } else {
            ChangeList[] changeLists = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
            if (changeLists != null && changeLists.length > 0) {
                commitMessage = changeLists[0].getComment();
            }
        }
        ArrayList<Change> changeCollection = new ArrayList<Change>();
        Collections.addAll(changeCollection, changes);
        CreatePatchCommitExecutor executor = CreatePatchCommitExecutor.getInstance(project);
        CommitSession commitSession = executor.createCommitSession();
        SessionDialog sessionDialog = new SessionDialog(executor.getActionText(), project, commitSession, changeCollection, commitMessage);
        sessionDialog.show();
        if (!sessionDialog.isOK()) {
            return;
        }
        CreatePatchFromChangesAction.preloadContent(project, changes);
        commitSession.execute(changeCollection, commitMessage);
    }

    private static void preloadContent(Project project, final Change[] changes) {
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                for (Change change : changes) {
                    this.checkLoadContent(change.getBeforeRevision());
                    this.checkLoadContent(change.getAfterRevision());
                }
            }

            private void checkLoadContent(ContentRevision revision) {
                if (revision != null && !(revision instanceof BinaryContentRevision)) {
                    try {
                        revision.getContent();
                    }
                    catch (VcsException vcsException) {
                        // empty catch block
                    }
                }
            }
        }, VcsBundle.message((String)"create.patch.loading.content.progress", (Object[])new Object[0]), false, project);
    }

    public void update(AnActionEvent e) {
        Change[] changes = (Change[])e.getData(VcsDataKeys.CHANGES);
        ChangeList[] changeLists = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
        e.getPresentation().setEnabled(changes != null && changes.length > 0 && (changeLists == null || changeLists.length == 1));
    }
}

