/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.actions.ShowDiffAction;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesBrowserUseCase;
import java.util.ArrayList;

public class ShowDiffWithLocalAction
extends AnAction
implements DumbAware {
    public ShowDiffWithLocalAction() {
        super(VcsBundle.message((String)"show.diff.with.local.action.text", (Object[])new Object[0]), VcsBundle.message((String)"show.diff.with.local.action.description", (Object[])new Object[0]), IconLoader.getIcon((String)"/actions/diffWithCurrent.png"));
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        Change[] changes = (Change[])e.getData(VcsDataKeys.CHANGES);
        assert (changes != null);
        ArrayList<Change> changesToLocal = new ArrayList<Change>();
        for (Change change : changes) {
            ContentRevision afterRevision = change.getAfterRevision();
            if (afterRevision == null || !ShowDiffWithLocalAction.isValidAfterRevision(afterRevision)) continue;
            changesToLocal.add(new Change(afterRevision, CurrentContentRevision.create((FilePath)afterRevision.getFile())));
        }
        if (!changesToLocal.isEmpty()) {
            Change[] changeArray = changesToLocal.toArray(new Change[changesToLocal.size()]);
            ShowDiffAction.showDiffForChange(changeArray, 0, project);
        }
    }

    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(PlatformDataKeys.PROJECT);
        Change[] changes = (Change[])e.getData(VcsDataKeys.CHANGES);
        e.getPresentation().setEnabled(project != null && changes != null && !CommittedChangesBrowserUseCase.IN_AIR.equals(CommittedChangesBrowserUseCase.DATA_KEY.getData(e.getDataContext())) && ShowDiffWithLocalAction.anyHasAfterRevision(changes));
    }

    private static boolean isValidAfterRevision(ContentRevision afterRevision) {
        return afterRevision != null && !afterRevision.getFile().isNonLocal() && !afterRevision.getFile().isDirectory();
    }

    private static boolean anyHasAfterRevision(Change[] changes) {
        for (Change c : changes) {
            if (!ShowDiffWithLocalAction.isValidAfterRevision(c.getAfterRevision())) continue;
            return true;
        }
        return false;
    }
}

