/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.readOnlyHandler;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.readOnlyHandler.HandleType;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;

public class VcsHandleType
extends HandleType {
    private final AbstractVcs myVcs;

    public VcsHandleType(AbstractVcs vcs) {
        super(VcsBundle.message((String)"handle.ro.file.status.type.using.vcs", (Object[])new Object[]{vcs.getDisplayName()}), true);
        this.myVcs = vcs;
    }

    @Override
    public void processFiles(final Collection<VirtualFile> files) {
        try {
            this.myVcs.getEditFileProvider().editFiles(VfsUtil.toVirtualFileArray(files));
        }
        catch (VcsException e) {
            Messages.showErrorDialog((String)VcsBundle.message((String)"message.text.cannot.edit.file", (Object[])new Object[]{e.getLocalizedMessage()}), (String)VcsBundle.message((String)"message.title.edit.files", (Object[])new Object[0]));
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                for (VirtualFile file : files) {
                    file.refresh(false, false);
                }
            }
        });
    }
}

