/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.objectTree.ObjectNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.ex.VirtualFileManagerEx;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.openapi.vfs.impl.IdentityVirtualFilePointer;
import com.intellij.openapi.vfs.impl.VirtualFilePointerContainerImpl;
import com.intellij.openapi.vfs.impl.VirtualFilePointerImpl;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerFactory;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.messages.MessageBus;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public class VirtualFilePointerManagerImpl
extends VirtualFilePointerManager
implements ApplicationComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.impl.VirtualFilePointerManagerImpl");
    private final Map<VirtualFilePointerListener, TreeMap<String, VirtualFilePointerImpl>> myUrlToPointerMaps;
    private final Set<VirtualFilePointerContainerImpl> myContainers;
    private final VirtualFileManagerEx myVirtualFileManager;
    private MessageBus myBus;
    private static final Comparator<String> COMPARATOR = SystemInfo.isFileSystemCaseSensitive ? new Comparator<String>(){

        @Override
        public int compare(@NotNull String url1, @NotNull String url2) {
            if (url1 == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl$1.compare must not be null");
            }
            if (url2 == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl$1.compare must not be null");
            }
            return url1.compareTo(url2);
        }
    } : new Comparator<String>(){

        @Override
        public int compare(@NotNull String url1, @NotNull String url2) {
            if (url1 == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl$2.compare must not be null");
            }
            if (url2 == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl$2.compare must not be null");
            }
            return url1.compareToIgnoreCase(url2);
        }
    };
    private final Map<String, IdentityVirtualFilePointer> myUrlToIdentity;

    VirtualFilePointerManagerImpl(@NotNull VirtualFileManagerEx virtualFileManagerEx, MessageBus bus) {
        if (virtualFileManagerEx == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl.<init> must not be null");
        }
        this.myUrlToPointerMaps = new LinkedHashMap<VirtualFilePointerListener, TreeMap<String, VirtualFilePointerImpl>>();
        this.myContainers = new THashSet(TObjectHashingStrategy.IDENTITY);
        this.myUrlToIdentity = new THashMap();
        this.myVirtualFileManager = virtualFileManagerEx;
        this.myBus = bus;
        bus.connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)new VFSEventsProcessor());
    }

    synchronized void clearPointerCaches(String url, VirtualFilePointerListener listener) {
        TreeMap<String, VirtualFilePointerImpl> urlToPointer = this.myUrlToPointerMaps.get(listener);
        if (urlToPointer == null && ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        assert (urlToPointer != null);
        urlToPointer.remove(VfsUtil.urlToPath((String)url));
        if (urlToPointer.isEmpty()) {
            this.myUrlToPointerMaps.remove(listener);
        }
    }

    private List<VirtualFilePointer> getPointersUnder(String path, boolean allowSameFSOptimization) {
        ArrayList<VirtualFilePointer> pointers = new ArrayList<VirtualFilePointer>();
        boolean urlFromJarFS = allowSameFSOptimization && path.indexOf("!/") > 0;
        for (TreeMap<String, VirtualFilePointerImpl> urlToPointer : this.myUrlToPointerMaps.values()) {
            for (String pointerUrl : urlToPointer.keySet()) {
                VirtualFilePointer pointer;
                boolean pointerFromJarFS = allowSameFSOptimization && pointerUrl.indexOf("!/") > 0;
                if (urlFromJarFS != pointerFromJarFS || !VirtualFilePointerManagerImpl.startsWith(path, pointerUrl) || (pointer = (VirtualFilePointer)urlToPointer.get(pointerUrl)) == null) continue;
                pointers.add(pointer);
            }
        }
        return pointers;
    }

    private static boolean startsWith(String url, String pointerUrl) {
        String urlSuffix = VirtualFilePointerManagerImpl.stripSuffix(url);
        String pointerPrefix = VirtualFilePointerManagerImpl.stripToJarPrefix(pointerUrl);
        if (urlSuffix.length() > 0) {
            return Comparing.equal((String)VirtualFilePointerManagerImpl.stripToJarPrefix(url), (String)pointerPrefix, (boolean)SystemInfo.isFileSystemCaseSensitive) && StringUtil.startsWith((CharSequence)urlSuffix, (CharSequence)VirtualFilePointerManagerImpl.stripSuffix(pointerUrl));
        }
        return FileUtil.startsWith((String)pointerPrefix, (String)VirtualFilePointerManagerImpl.stripToJarPrefix(url));
    }

    private static String stripToJarPrefix(String url) {
        int separatorIndex = url.indexOf("!/");
        if (separatorIndex < 0) {
            return url;
        }
        return url.substring(0, separatorIndex);
    }

    private static String stripSuffix(String url) {
        int separatorIndex = url.indexOf("!/");
        if (separatorIndex < 0) {
            return "";
        }
        return url.substring(separatorIndex + "!/".length());
    }

    public synchronized void cleanupForNextTest() {
        this.myUrlToPointerMaps.clear();
        this.myContainers.clear();
    }

    @Deprecated
    public synchronized VirtualFilePointer create(String url, VirtualFilePointerListener listener) {
        return this.create(url, (Disposable)this, listener);
    }

    @NotNull
    public synchronized VirtualFilePointer create(@NotNull String url, @NotNull Disposable parent, VirtualFilePointerListener listener) {
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl.create must not be null");
        }
        if (parent == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl.create must not be null");
        }
        VirtualFilePointer virtualFilePointer = this.create(null, url, parent, listener);
        if (virtualFilePointer == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl.create must not return null");
        }
        return virtualFilePointer;
    }

    @Deprecated
    public synchronized VirtualFilePointer create(VirtualFile file, VirtualFilePointerListener listener) {
        return this.create(file, (Disposable)this, listener);
    }

    @NotNull
    public synchronized VirtualFilePointer create(@NotNull VirtualFile file, @NotNull Disposable parent, VirtualFilePointerListener listener) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl.create must not be null");
        }
        if (parent == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl.create must not be null");
        }
        VirtualFilePointer virtualFilePointer = this.create(file, file.getUrl(), parent, listener);
        if (virtualFilePointer == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl.create must not return null");
        }
        return virtualFilePointer;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private VirtualFilePointer create(VirtualFile file, @NotNull String url, @NotNull Disposable parentDisposable, VirtualFilePointerListener listener) {
        String path;
        VirtualFilePointer virtualFilePointer;
        VirtualFileSystem fileSystem;
        String protocol;
        if (url == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl.create must not be null");
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl.create must not be null");
        }
        if (file == null) {
            protocol = VirtualFileManager.extractProtocol((String)url);
            fileSystem = this.myVirtualFileManager.getFileSystem(protocol);
        } else {
            protocol = null;
            fileSystem = file.getFileSystem();
        }
        if (fileSystem == TempFileSystem.getInstance()) {
            VirtualFile found;
            VirtualFile virtualFile = found = fileSystem == null ? null : (file != null ? file : VirtualFileManager.getInstance().findFileByUrl(url));
            virtualFilePointer = new IdentityVirtualFilePointer(found, url);
            if (virtualFilePointer == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl.create must not return null");
            return virtualFilePointer;
        }
        if (fileSystem != LocalFileSystem.getInstance() && fileSystem != JarFileSystem.getInstance()) {
            VirtualFile found;
            VirtualFile virtualFile = found = fileSystem == null ? null : (file != null ? file : VirtualFileManager.getInstance().findFileByUrl(url));
            virtualFilePointer = this.getOrCreateIdentity(url, found);
            if (virtualFilePointer == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl.create must not return null");
            return virtualFilePointer;
        }
        if (file == null) {
            path = VirtualFileManager.extractPath((String)url);
            path = VirtualFilePointerManagerImpl.cleanupPath(path, protocol);
            url = VirtualFileManager.constructUrl((String)protocol, (String)path);
        } else {
            path = file.getPath();
        }
        VirtualFilePointerImpl pointer = this.getOrCreate(file, url, parentDisposable, listener, path);
        int newCount = pointer.incrementUsageCount();
        if (newCount == 1) {
            Disposer.register((Disposable)parentDisposable, (Disposable)pointer);
        } else {
            VirtualFilePointerManagerImpl.register(parentDisposable, pointer);
        }
        if ((virtualFilePointer = pointer) != null) return virtualFilePointer;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl.create must not return null");
    }

    private IdentityVirtualFilePointer getOrCreateIdentity(@NotNull String url, VirtualFile found) {
        if (url == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl.getOrCreateIdentity must not be null");
        }
        IdentityVirtualFilePointer pointer = this.myUrlToIdentity.get(url);
        if (pointer == null) {
            pointer = new IdentityVirtualFilePointer(found, url);
            this.myUrlToIdentity.put(url, pointer);
        }
        return pointer;
    }

    private static void register(Disposable parentDisposable, VirtualFilePointerImpl pointer) {
        DelegatingDisposable delegating = new DelegatingDisposable(pointer);
        DelegatingDisposable registered = (DelegatingDisposable)Disposer.findRegisteredObject((Disposable)parentDisposable, (Disposable)delegating);
        if (registered == null) {
            Disposer.register((Disposable)parentDisposable, (Disposable)delegating);
        } else {
            registered.disposeCount++;
        }
    }

    private static String cleanupPath(String path, String protocol) {
        path = FileUtil.toSystemIndependentName((String)path);
        path = VirtualFilePointerManagerImpl.stripTrailingPathSeparator(path, protocol);
        path = VirtualFilePointerManagerImpl.removeDoubleSlashes(path);
        return path;
    }

    private static String removeDoubleSlashes(String path) {
        int i;
        while ((i = path.lastIndexOf("//")) != -1) {
            path = path.substring(0, i) + path.substring(i + 1);
        }
        return path;
    }

    private synchronized VirtualFilePointerImpl getOrCreate(VirtualFile file, @NotNull String url, Disposable parentDisposable, VirtualFilePointerListener listener, String path) {
        VirtualFilePointerImpl pointer;
        if (url == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl.getOrCreate must not be null");
        }
        TreeMap<String, VirtualFilePointerImpl> urlToPointer = this.myUrlToPointerMaps.get(listener);
        if (urlToPointer == null) {
            urlToPointer = new TreeMap(COMPARATOR);
            this.myUrlToPointerMaps.put(listener, urlToPointer);
        }
        if ((pointer = urlToPointer.get(path)) == null) {
            pointer = new VirtualFilePointerImpl(file, url, this.myVirtualFileManager, listener, parentDisposable);
            urlToPointer.put(path, pointer);
        }
        return pointer;
    }

    private static String stripTrailingPathSeparator(String path, String protocol) {
        while (!(!path.endsWith("/") || protocol.equals("jar") && path.endsWith("!/"))) {
            path = StringUtil.trimEnd((String)path, (String)"/");
        }
        return path;
    }

    @Deprecated
    public synchronized VirtualFilePointer duplicate(VirtualFilePointer pointer, VirtualFilePointerListener listener) {
        return this.duplicate(pointer, (Disposable)this, listener);
    }

    @NotNull
    public synchronized VirtualFilePointer duplicate(@NotNull VirtualFilePointer pointer, @NotNull Disposable parent, VirtualFilePointerListener listener) {
        if (pointer == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl.duplicate must not be null");
        }
        if (parent == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl.duplicate must not be null");
        }
        VirtualFile file = pointer.getFile();
        VirtualFilePointer virtualFilePointer = file == null ? this.create(pointer.getUrl(), parent, listener) : this.create(file, parent, listener);
        if (virtualFilePointer == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl.duplicate must not return null");
        }
        return virtualFilePointer;
    }

    @Deprecated
    public synchronized void kill(VirtualFilePointer pointer, VirtualFilePointerListener listener) {
    }

    public void initComponent() {
    }

    public void disposeComponent() {
        Disposer.dispose((Disposable)this);
        this.assertPointersDisposed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void assertPointersDisposed() {
        for (Map.Entry<VirtualFilePointerListener, TreeMap<String, VirtualFilePointerImpl>> entry : this.myUrlToPointerMaps.entrySet()) {
            VirtualFilePointerListener listener = entry.getKey();
            TreeMap<String, VirtualFilePointerImpl> map = entry.getValue();
            for (VirtualFilePointerImpl pointer : map.values()) {
                this.myUrlToPointerMaps.clear();
                pointer.throwNotDisposedError("Not disposed pointer: listener=" + listener);
            }
        }
        Set<VirtualFilePointerContainerImpl> set = this.myContainers;
        synchronized (set) {
            if (!this.myContainers.isEmpty()) {
                VirtualFilePointerContainerImpl container = this.myContainers.iterator().next();
                this.myContainers.clear();
                throw new RuntimeException("Not disposed container " + container);
            }
        }
    }

    public void dispose() {
    }

    @NotNull
    public String getComponentName() {
        if ("SmartVirtualPointerManager" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl.getComponentName must not return null");
        }
        return "SmartVirtualPointerManager";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanContainerCaches() {
        Set<VirtualFilePointerContainerImpl> set = this.myContainers;
        synchronized (set) {
            for (VirtualFilePointerContainerImpl container : this.myContainers) {
                container.dropCaches();
            }
        }
    }

    @Deprecated
    public synchronized VirtualFilePointerContainer createContainer() {
        return this.createContainer((Disposable)this);
    }

    @Deprecated
    public synchronized VirtualFilePointerContainer createContainer(final VirtualFilePointerFactory factory) {
        VirtualFilePointerContainerImpl virtualFilePointerContainer = new VirtualFilePointerContainerImpl(this, (Disposable)this, null){

            @Override
            protected VirtualFilePointer create(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl$3.create must not be null");
                }
                return factory.create(file);
            }

            @Override
            protected VirtualFilePointer create(@NotNull String url) {
                if (url == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl$3.create must not be null");
                }
                return factory.create(url);
            }

            @Override
            protected VirtualFilePointer duplicate(@NotNull VirtualFilePointer virtualFilePointer) {
                if (virtualFilePointer == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl$3.duplicate must not be null");
                }
                return factory.duplicate(virtualFilePointer);
            }
        };
        return this.registerContainer((Disposable)this, virtualFilePointerContainer);
    }

    @NotNull
    public VirtualFilePointerContainer createContainer(@NotNull Disposable parent) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl.createContainer must not be null");
        }
        VirtualFilePointerContainer virtualFilePointerContainer = this.createContainer(parent, null);
        if (virtualFilePointerContainer == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl.createContainer must not return null");
        }
        return virtualFilePointerContainer;
    }

    @NotNull
    public synchronized VirtualFilePointerContainer createContainer(@NotNull Disposable parent, VirtualFilePointerListener listener) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl.createContainer must not be null");
        }
        VirtualFilePointerContainer virtualFilePointerContainer = this.registerContainer(parent, new VirtualFilePointerContainerImpl(this, parent, listener));
        if (virtualFilePointerContainer == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl.createContainer must not return null");
        }
        return virtualFilePointerContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VirtualFilePointerContainer registerContainer(@NotNull Disposable parent, final @NotNull VirtualFilePointerContainerImpl virtualFilePointerContainer) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl.registerContainer must not be null");
        }
        if (virtualFilePointerContainer == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl.registerContainer must not be null");
        }
        Set<VirtualFilePointerContainerImpl> set = this.myContainers;
        synchronized (set) {
            this.myContainers.add(virtualFilePointerContainer);
        }
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void dispose() {
                boolean removed;
                Disposer.dispose((Disposable)virtualFilePointerContainer);
                Set set = VirtualFilePointerManagerImpl.this.myContainers;
                synchronized (set) {
                    removed = VirtualFilePointerManagerImpl.this.myContainers.remove(virtualFilePointerContainer);
                }
                if (!ApplicationManager.getApplication().isUnitTestMode()) assert (removed);
            }

            public String toString() {
                return "Disposing container " + virtualFilePointerContainer;
            }
        });
        return virtualFilePointerContainer;
    }

    public int countPointers() {
        int result = 0;
        for (TreeMap<String, VirtualFilePointerImpl> map : this.myUrlToPointerMaps.values()) {
            result += map.values().size();
        }
        return result;
    }

    public int countDupContainers() {
        THashMap c = new THashMap();
        for (VirtualFilePointerContainerImpl container : this.myContainers) {
            Integer count = (Integer)c.get(container);
            if (count == null) {
                count = 0;
            }
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
            c.put(container, count);
        }
        int i = 0;
        for (Integer count : c.values()) {
            if (count <= 1) continue;
            ++i;
        }
        return i;
    }

    public static int countMaxRefCount() {
        int result = 0;
        for (Disposable disposable : Disposer.getTree().getRootObjects()) {
            result = VirtualFilePointerManagerImpl.calcMaxRefCount(disposable, result);
        }
        return result;
    }

    private static int calcMaxRefCount(Disposable disposable, int result) {
        if (disposable instanceof DelegatingDisposable) {
            result = Math.max(((DelegatingDisposable)disposable).disposeCount, result);
        }
        for (ObjectNode node : Disposer.getTree().getNode((Object)disposable).getChildren()) {
            result = VirtualFilePointerManagerImpl.calcMaxRefCount((Disposable)node.getObject(), result);
        }
        return result;
    }

    private static class DelegatingDisposable
    implements Disposable {
        private final VirtualFilePointerImpl myPointer;
        private int disposeCount;

        private DelegatingDisposable(@NotNull VirtualFilePointerImpl pointer) {
            if (pointer == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl$DelegatingDisposable.<init> must not be null");
            }
            this.disposeCount = 1;
            this.myPointer = pointer;
        }

        public void dispose() {
            this.myPointer.useCount -= this.disposeCount - 1;
            LOG.assertTrue(this.myPointer.useCount > 0);
            this.myPointer.dispose();
        }

        public String toString() {
            return "D:" + this.myPointer.toString();
        }

        public boolean equals(Object o) {
            DelegatingDisposable that = (DelegatingDisposable)o;
            return this.myPointer == that.myPointer;
        }

        public int hashCode() {
            return ((Object)((Object)this.myPointer)).hashCode();
        }
    }

    private class VFSEventsProcessor
    implements BulkFileListener {
        private List<EventDescriptor> myEvents = null;
        private List<String> myUrlsToUpdate = null;
        private List<VirtualFilePointer> myPointersToUdate = null;

        private VFSEventsProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void before(List<? extends VFileEvent> events) {
            VirtualFilePointerManagerImpl.this.cleanContainerCaches();
            ArrayList<VirtualFilePointer> toFireEvents = new ArrayList<VirtualFilePointer>();
            ArrayList<String> toUpdateUrl = new ArrayList<String>();
            VirtualFilePointerManagerImpl virtualFilePointerManagerImpl = VirtualFilePointerManagerImpl.this;
            synchronized (virtualFilePointerManagerImpl) {
                for (VFileEvent vFileEvent : events) {
                    VFilePropertyChangeEvent change;
                    VirtualFile file;
                    List pointers;
                    String url;
                    if (vFileEvent instanceof VFileDeleteEvent) {
                        VFileDeleteEvent deleteEvent = (VFileDeleteEvent)vFileEvent;
                        url = deleteEvent.getFile().getPath();
                        toFireEvents.addAll(VirtualFilePointerManagerImpl.this.getPointersUnder(url, true));
                        continue;
                    }
                    if (vFileEvent instanceof VFileCreateEvent) {
                        VFileCreateEvent createEvent = (VFileCreateEvent)vFileEvent;
                        url = createEvent.getPath();
                        toFireEvents.addAll(VirtualFilePointerManagerImpl.this.getPointersUnder(url, false));
                        continue;
                    }
                    if (vFileEvent instanceof VFileCopyEvent) {
                        VFileCopyEvent copyEvent = (VFileCopyEvent)vFileEvent;
                        url = copyEvent.getNewParent().getPath() + "/" + copyEvent.getFile().getName();
                        toFireEvents.addAll(VirtualFilePointerManagerImpl.this.getPointersUnder(url, false));
                        continue;
                    }
                    if (vFileEvent instanceof VFileMoveEvent) {
                        VFileMoveEvent moveEvent = (VFileMoveEvent)vFileEvent;
                        pointers = VirtualFilePointerManagerImpl.this.getPointersUnder(moveEvent.getFile().getPath(), false);
                        for (VirtualFilePointer pointer : pointers) {
                            file = pointer.getFile();
                            if (file == null) continue;
                            toUpdateUrl.add(file.getPath());
                        }
                        continue;
                    }
                    if (!(vFileEvent instanceof VFilePropertyChangeEvent) || !"name".equals((change = (VFilePropertyChangeEvent)vFileEvent).getPropertyName())) continue;
                    pointers = VirtualFilePointerManagerImpl.this.getPointersUnder(change.getFile().getPath(), false);
                    for (VirtualFilePointer pointer : pointers) {
                        file = pointer.getFile();
                        if (file == null) continue;
                        toUpdateUrl.add(file.getPath());
                    }
                }
                this.myEvents = new ArrayList<EventDescriptor>();
                for (VirtualFilePointerListener virtualFilePointerListener : VirtualFilePointerManagerImpl.this.myUrlToPointerMaps.keySet()) {
                    if (virtualFilePointerListener == null) continue;
                    EventDescriptor event = new EventDescriptor(virtualFilePointerListener, toFireEvents);
                    this.myEvents.add(event);
                }
            }
            for (EventDescriptor event : this.myEvents) {
                event.fireBefore();
            }
            if (!toFireEvents.isEmpty()) {
                VirtualFilePointer[] arr = toFireEvents.toArray(new VirtualFilePointer[toFireEvents.size()]);
                ((VirtualFilePointerListener)VirtualFilePointerManagerImpl.this.myBus.syncPublisher(VirtualFilePointerListener.TOPIC)).beforeValidityChanged(arr);
            }
            this.myPointersToUdate = toFireEvents;
            this.myUrlsToUpdate = toUpdateUrl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void after(List<? extends VFileEvent> events) {
            VirtualFilePointerManagerImpl.this.cleanContainerCaches();
            if (this.myUrlsToUpdate == null) {
                return;
            }
            for (String url : this.myUrlsToUpdate) {
                VirtualFilePointerManagerImpl virtualFilePointerManagerImpl = VirtualFilePointerManagerImpl.this;
                synchronized (virtualFilePointerManagerImpl) {
                    for (TreeMap urlToPointer : VirtualFilePointerManagerImpl.this.myUrlToPointerMaps.values()) {
                        VirtualFilePointerImpl pointer = (VirtualFilePointerImpl)((Object)urlToPointer.remove(url));
                        if (pointer == null) continue;
                        String path = VfsUtil.urlToPath((String)pointer.getUrl());
                        urlToPointer.put(path, pointer);
                    }
                }
            }
            for (VirtualFilePointer pointer : this.myPointersToUdate) {
                ((VirtualFilePointerImpl)pointer).update();
            }
            for (EventDescriptor event : this.myEvents) {
                event.fireAfter();
            }
            if (!this.myPointersToUdate.isEmpty()) {
                VirtualFilePointer[] arr = this.myPointersToUdate.toArray(new VirtualFilePointer[this.myPointersToUdate.size()]);
                ((VirtualFilePointerListener)VirtualFilePointerManagerImpl.this.myBus.syncPublisher(VirtualFilePointerListener.TOPIC)).validityChanged(arr);
            }
            this.myUrlsToUpdate = null;
            this.myEvents = null;
            this.myPointersToUdate = null;
        }
    }

    private class EventDescriptor {
        private final VirtualFilePointerListener myListener;
        private final VirtualFilePointer[] myPointers;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private EventDescriptor(@NotNull VirtualFilePointerListener listener, List<VirtualFilePointer> pointers) {
            if (listener == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl$EventDescriptor.<init> must not be null");
            }
            if (pointers == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/vfs/impl/VirtualFilePointerManagerImpl$EventDescriptor.<init> must not be null");
            }
            this.myListener = listener;
            VirtualFilePointerManagerImpl virtualFilePointerManagerImpl2 = VirtualFilePointerManagerImpl.this;
            synchronized (virtualFilePointerManagerImpl2) {
                Collection set = ((TreeMap)VirtualFilePointerManagerImpl.this.myUrlToPointerMaps.get(listener)).values();
                ArrayList<VirtualFilePointer> result = new ArrayList<VirtualFilePointer>(pointers);
                result.retainAll(set);
                this.myPointers = result.isEmpty() ? VirtualFilePointer.EMPTY_ARRAY : result.toArray(new VirtualFilePointer[result.size()]);
            }
        }

        public void fireBefore() {
            if (this.myPointers.length != 0) {
                this.myListener.beforeValidityChanged(this.myPointers);
            }
        }

        public void fireAfter() {
            if (this.myPointers.length != 0) {
                this.myListener.validityChanged(this.myPointers);
            }
        }
    }
}

