/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.welcomeScreen;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.DataManager;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeScrollablePanel;
import com.intellij.ui.LabeledIcon;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.UIBundle;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NonNls;

public class WelcomeScreen {
    private JPanel myWelcomePanel;
    private final JPanel myMainPanel;
    private JPanel myPluginsPanel;
    private static final Insets ICON_INSETS = new Insets(15, 30, 15, 0);
    private static final Insets ACTION_GROUP_CAPTION_INSETS = new Insets(20, 30, 5, 0);
    private MyActionButton myKeypressedButton = null;
    private int mySelectedRow = -1;
    private int mySelectedColumn = -1;
    private int mySelectedGroup = -1;
    private static final int MAIN_GROUP = 0;
    private static final int PLUGINS_GROUP = 1;
    private static final int PLUGIN_DSC_MAX_WIDTH = 260;
    private static final int PLUGIN_DSC_MAX_ROWS = 2;
    private static final int PLUGIN_NAME_MAX_WIDTH = 180;
    private static final int PLUGIN_NAME_MAX_ROWS = 2;
    private static final int MAX_TOOLTIP_WIDTH = 400;
    private static final int ACTION_BUTTON_PADDING = 5;
    private static final Dimension ACTION_BUTTON_SIZE = new Dimension(66, 66);
    private static final Dimension PLUGIN_LOGO_SIZE = new Dimension(16, 16);
    private static final Dimension LEARN_MORE_SIZE = new Dimension(26, 26);
    private static final Dimension OPEN_PLUGIN_MANAGER_SIZE = new Dimension(166, 31);
    private static final Icon LEARN_MORE_ICON = IconLoader.getIcon((String)"/general/learnMore.png");
    private static final Icon OPEN_PLUGINS_ICON = IconLoader.getIcon((String)"/general/openPluginManager.png");
    private static final Icon DEFAULT_ICON = IconLoader.getIcon((String)"/general/configurableDefault.png");
    private static Icon CAPTION_IMAGE;
    private static Icon DEVELOPER_SLOGAN;
    @NonNls
    protected static final String TAHOMA_FONT_NAME = "Tahoma";
    private static final Font TEXT_FONT;
    private static final Font LINK_FONT;
    private static final Font GROUP_CAPTION_FONT;
    private static final Color CAPTION_COLOR;
    private static final Color DISABLED_CAPTION_COLOR;
    private static final Color PLUGINS_PANEL_COLOR;
    private static final Color MAIN_PANEL_COLOR;
    private static final Color BUTTON_PUSHED_COLOR;
    private static final Color BUTTON_POPPED_COLOR;
    private static final Color MAIN_PANEL_BACKGROUND;
    private static final Color LEARN_MORE_BUTTON_COLOR;
    private static final Color GRAY_BORDER_COLOR;
    private static Color CAPTION_BACKGROUND;
    private static final Color ACTION_BUTTON_COLOR;
    private static final Color ACTION_BUTTON_BORDER_COLOR;
    private static final Color WHITE_BORDER_COLOR;
    private int myPluginsButtonsCount = 0;
    private int myPluginsIdx = -1;
    @NonNls
    protected static final String ___HTML_SUFFIX = "...</html>";
    @NonNls
    protected static final String ESC_NEW_LINE = "\\n";

    private WelcomeScreen() {
        WelcomeScreen.initApplicationSpecificImages();
        ActionManager actionManager = ActionManager.getInstance();
        JPanel topPanel = this.createCaptionPane();
        this.myMainPanel = new WelcomeScrollablePanel(new GridLayout(1, 2));
        this.myMainPanel.setBackground(MAIN_PANEL_COLOR);
        ActionGroupDescriptor quickStarts = new ActionGroupDescriptor(UIBundle.message((String)"welcome.screen.quick.start.action.group.name", (Object[])new Object[0]), 0);
        quickStarts.appendActionsFromGroup((ActionGroup)((DefaultActionGroup)actionManager.getAction("WelcomeScreen.QuickStart")));
        JPanel quickStartPanel = quickStarts.getPanel();
        JPanel emptyPanel_2 = new JPanel();
        emptyPanel_2.setBackground(MAIN_PANEL_COLOR);
        quickStartPanel.add((Component)emptyPanel_2, new GridBagConstraints(0, quickStarts.getIdx() + 2, 2, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        ActionGroupDescriptor docsGroup = new ActionGroupDescriptor(UIBundle.message((String)"welcome.screen.documentation.action.group.name", (Object[])new Object[0]), 1);
        docsGroup.appendActionsFromGroup((ActionGroup)((DefaultActionGroup)actionManager.getAction("WelcomeScreen.Documentation")));
        JPanel docsPanel = docsGroup.getPanel();
        JPanel emptyPanel_3 = new JPanel();
        emptyPanel_3.setBackground(MAIN_PANEL_COLOR);
        docsPanel.add((Component)emptyPanel_3, new GridBagConstraints(0, docsGroup.getIdx() + 2, 2, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.myMainPanel.add(quickStartPanel);
        this.myMainPanel.add(docsPanel);
        JScrollPane myMainScrollPane = new JScrollPane(this.myMainPanel);
        myMainScrollPane.setBorder(null);
        myMainScrollPane.setHorizontalScrollBarPolicy(30);
        myMainScrollPane.setVerticalScrollBarPolicy(20);
        JScrollPane myPluginsScrollPane = this.createPluginsPanel();
        GridBagConstraints gBC = new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 18, 2, new Insets(10, 5, 0, 5), 0, 0);
        this.myWelcomePanel.add((Component)topPanel, gBC);
        gBC = new GridBagConstraints(0, 1, 1, 1, 0.7, 1.0, 18, 1, new Insets(15, 15, 15, 0), 0, 0);
        this.myWelcomePanel.add((Component)myMainScrollPane, gBC);
        gBC = new GridBagConstraints(1, 1, 1, 1, 0.3, 1.0, 18, 1, new Insets(15, 15, 15, 15), 0, 0);
        this.myWelcomePanel.add((Component)myPluginsScrollPane, gBC);
    }

    private static void initApplicationSpecificImages() {
        if (CAPTION_IMAGE == null) {
            ApplicationInfoEx applicationInfoEx = ApplicationInfoEx.getInstanceEx();
            CAPTION_IMAGE = IconLoader.getIcon((String)applicationInfoEx.getWelcomeScreenCaptionUrl());
            DEVELOPER_SLOGAN = IconLoader.getIcon((String)applicationInfoEx.getWelcomeScreenDeveloperSloganUrl());
            BufferedImage image = new BufferedImage(CAPTION_IMAGE.getIconWidth(), CAPTION_IMAGE.getIconHeight(), 1);
            CAPTION_IMAGE.paintIcon(null, image.getGraphics(), 0, 0);
            int[] pixels = new int[1];
            PixelGrabber pixelGrabber = new PixelGrabber(image, CAPTION_IMAGE.getIconWidth() - 1, CAPTION_IMAGE.getIconHeight() - 1, 1, 1, pixels, 0, 1);
            try {
                pixelGrabber.grabPixels();
                CAPTION_BACKGROUND = new Color(pixels[0]);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    public static JPanel createWelcomePanel() {
        return new WelcomeScreen().myWelcomePanel;
    }

    private JPanel createCaptionPane() {
        JPanel topPanel = new JPanel(new GridBagLayout()){

            @Override
            public void paint(Graphics g) {
                Icon welcome = CAPTION_IMAGE;
                welcome.paintIcon(null, g, 0, 0);
                g.setColor(CAPTION_BACKGROUND);
                g.fillRect(welcome.getIconWidth(), 0, this.getWidth() - welcome.getIconWidth(), welcome.getIconHeight());
                super.paint(g);
            }
        };
        topPanel.setOpaque(false);
        JPanel transparentTopPanel = new JPanel();
        transparentTopPanel.setOpaque(false);
        topPanel.add((Component)transparentTopPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        topPanel.add((Component)new JLabel(DEVELOPER_SLOGAN), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 16, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.myWelcomePanel = new JPanel(new GridBagLayout());
        this.myWelcomePanel.setBackground(MAIN_PANEL_BACKGROUND);
        return topPanel;
    }

    private JScrollPane createPluginsPanel() {
        this.myPluginsPanel = new WelcomeScrollablePanel(new GridBagLayout());
        this.myPluginsPanel.setBackground(PLUGINS_PANEL_COLOR);
        JLabel pluginsCaption = new JLabel(UIBundle.message((String)"welcome.screen.plugins.panel.plugins.label", (Object[])new Object[0]));
        pluginsCaption.setFont(GROUP_CAPTION_FONT);
        pluginsCaption.setForeground(CAPTION_COLOR);
        JLabel installedPluginsCaption = new JLabel(UIBundle.message((String)"welcome.screen.plugins.panel.my.plugins.label", (Object[])new Object[0]));
        installedPluginsCaption.setFont(LINK_FONT);
        installedPluginsCaption.setForeground(CAPTION_COLOR);
        JPanel installedPluginsPanel = new JPanel(new GridBagLayout());
        installedPluginsPanel.setBackground(PLUGINS_PANEL_COLOR);
        JLabel bundledPluginsCaption = new JLabel(UIBundle.message((String)"welcome.screen.plugins.panel.bundled.plugins.label", (Object[])new Object[0]));
        bundledPluginsCaption.setFont(LINK_FONT);
        bundledPluginsCaption.setForeground(CAPTION_COLOR);
        JPanel bundledPluginsPanel = new JPanel(new GridBagLayout());
        bundledPluginsPanel.setBackground(PLUGINS_PANEL_COLOR);
        JPanel topPluginsPanel = new JPanel(new GridBagLayout());
        topPluginsPanel.setBackground(PLUGINS_PANEL_COLOR);
        GridBagConstraints gBC = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(17, 25, 0, 0), 0, 0);
        topPluginsPanel.add((Component)pluginsCaption, gBC);
        JLabel emptyLabel_1 = new JLabel();
        emptyLabel_1.setBackground(PLUGINS_PANEL_COLOR);
        gBC = new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        topPluginsPanel.add((Component)emptyLabel_1, gBC);
        this.createListOfPlugins(installedPluginsPanel, bundledPluginsPanel);
        gBC = new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(13, 0, 0, 10), 0, 0);
        PluginsActionButton openPluginManager = new PluginsActionButton(OPEN_PLUGINS_ICON, null){

            @Override
            protected void onPress(InputEvent e) {
                ShowSettingsUtil.getInstance().editConfigurable((Component)WelcomeScreen.this.myPluginsPanel, (Configurable)PluginManagerConfigurable.getInstance());
            }

            @Override
            public Dimension getMaximumSize() {
                return OPEN_PLUGIN_MANAGER_SIZE;
            }

            @Override
            public Dimension getMinimumSize() {
                return OPEN_PLUGIN_MANAGER_SIZE;
            }

            @Override
            public Dimension getPreferredSize() {
                return OPEN_PLUGIN_MANAGER_SIZE;
            }
        };
        openPluginManager.setCursor(Cursor.getPredefinedCursor(12));
        topPluginsPanel.add((Component)openPluginManager, gBC);
        ((MyActionButton)openPluginManager).setupWithinPanel(this.myPluginsPanel, 1, this.myPluginsButtonsCount, 0);
        ++this.myPluginsButtonsCount;
        gBC = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(15, 25, 0, 0), 0, 0);
        topPluginsPanel.add((Component)installedPluginsCaption, gBC);
        JLabel emptyLabel_2 = new JLabel();
        emptyLabel_2.setBackground(PLUGINS_PANEL_COLOR);
        gBC = new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        topPluginsPanel.add((Component)emptyLabel_2, gBC);
        gBC = new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0);
        this.myPluginsPanel.add((Component)topPluginsPanel, gBC);
        gBC = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 5, 0, 0), 0, 0);
        this.myPluginsPanel.add((Component)installedPluginsPanel, gBC);
        JPanel emptyPanel_1 = new JPanel();
        emptyPanel_1.setBackground(PLUGINS_PANEL_COLOR);
        gBC = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(25, 25, 0, 0), 0, 0);
        this.myPluginsPanel.add((Component)bundledPluginsCaption, gBC);
        gBC = new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 18, 1, new Insets(5, 5, 0, 0), 0, 0);
        this.myPluginsPanel.add((Component)bundledPluginsPanel, gBC);
        gBC = new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0);
        this.myPluginsPanel.add((Component)emptyPanel_1, gBC);
        JScrollPane myPluginsScrollPane = ScrollPaneFactory.createScrollPane((JComponent)this.myPluginsPanel);
        myPluginsScrollPane.setBorder(BorderFactory.createLineBorder(GRAY_BORDER_COLOR));
        myPluginsScrollPane.setHorizontalScrollBarPolicy(30);
        myPluginsScrollPane.setVerticalScrollBarPolicy(20);
        return myPluginsScrollPane;
    }

    private void createListOfPlugins(JPanel installedPluginsPanel, JPanel bundledPluginsPanel) {
        ArrayList<IdeaPluginDescriptor> installedPlugins = new ArrayList<IdeaPluginDescriptor>(Arrays.asList(ApplicationManager.getApplication().getPlugins()));
        if (installedPlugins.size() == 0) {
            this.addListItemToPlugins(installedPluginsPanel, WelcomeScreen.makeItalic(UIBundle.message((String)"welcome.screen.plugins.panel.no.plugins.currently.installed.message.text", (Object[])new Object[0])));
            this.addListItemToPlugins(bundledPluginsPanel, WelcomeScreen.makeItalic(UIBundle.message((String)"welcome.screen.plugins.panel.all.bundled.plugins.were.uninstalled.message.text", (Object[])new Object[0])));
        } else {
            Comparator<IdeaPluginDescriptor> pluginsComparator = new Comparator<IdeaPluginDescriptor>(){

                @Override
                public int compare(IdeaPluginDescriptor o1, IdeaPluginDescriptor o2) {
                    boolean e1 = ((IdeaPluginDescriptorImpl)o1).isEnabled();
                    boolean e2 = ((IdeaPluginDescriptorImpl)o2).isEnabled();
                    if (e1 && !e2) {
                        return -1;
                    }
                    if (!e1 && e2) {
                        return 1;
                    }
                    return o1.getName().compareTo(o2.getName());
                }
            };
            Collections.sort(installedPlugins, pluginsComparator);
            int embeddedPlugins = 0;
            int installedPluginsCount = 0;
            for (IdeaPluginDescriptor plugin : installedPlugins) {
                if (plugin.getName().equals("IDEA CORE") || ((IdeaPluginDescriptorImpl)plugin).isUseCoreClassLoader()) continue;
                if (plugin.isBundled()) {
                    ++embeddedPlugins;
                    this.addListItemToPlugins(bundledPluginsPanel, (IdeaPluginDescriptorImpl)plugin);
                    continue;
                }
                ++installedPluginsCount;
                this.addListItemToPlugins(installedPluginsPanel, (IdeaPluginDescriptorImpl)plugin);
            }
            if (embeddedPlugins == 0) {
                this.addListItemToPlugins(bundledPluginsPanel, WelcomeScreen.makeItalic(UIBundle.message((String)"welcome.screen.plugins.panel.all.bundled.plugins.were.uninstalled.message.text", (Object[])new Object[0])));
            }
            if (installedPluginsCount == 0) {
                this.addListItemToPlugins(installedPluginsPanel, WelcomeScreen.makeItalic(UIBundle.message((String)"welcome.screen.plugins.panel.no.plugins.currently.installed.message.text", (Object[])new Object[0])));
            }
        }
    }

    private static String makeItalic(String message) {
        return "<i>" + message + "</i>";
    }

    private void addListItemToPlugins(JPanel bundledPluginsPanel, String title) {
        this.addListItemToPlugins(bundledPluginsPanel, title, null, null, null, null, true, false);
    }

    private void addListItemToPlugins(JPanel bundledPluginsPanel, IdeaPluginDescriptorImpl plugin) {
        this.addListItemToPlugins(bundledPluginsPanel, plugin.getName(), plugin.getDescription(), plugin.getVendorLogoPath(), plugin.getPluginClassLoader(), plugin.getUrl(), plugin.isEnabled(), PluginManager.isIncompatible((IdeaPluginDescriptor)plugin));
    }

    public void addListItemToPlugins(JPanel panel, String name, String description, String iconPath, ClassLoader pluginClassLoader, final String url, boolean enabled, boolean incompatible) {
        Icon logoImage;
        if (StringUtil.isEmptyOrSpaces((String)name)) {
            return;
        }
        name = name.trim();
        int y = this.myPluginsIdx += 2;
        if (StringUtil.isEmptyOrSpaces((String)iconPath)) {
            logoImage = new EmptyIcon(WelcomeScreen.PLUGIN_LOGO_SIZE.width, WelcomeScreen.PLUGIN_LOGO_SIZE.height);
        } else {
            logoImage = IconLoader.findIcon((String)iconPath, (ClassLoader)pluginClassLoader);
            if (logoImage == null) {
                logoImage = new EmptyIcon(WelcomeScreen.PLUGIN_LOGO_SIZE.width, WelcomeScreen.PLUGIN_LOGO_SIZE.height);
            }
        }
        JLabel imageLabel = new JLabel(logoImage);
        GridBagConstraints gBC = new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 18, 0, new Insets(15, 20, 0, 0), 0, 0);
        panel.add((Component)imageLabel, gBC);
        String shortenedName = this.adjustStringBreaksByWidth(name + " " + (incompatible ? UIBundle.message((String)"welcome.screen.incompatible.plugins.description", (Object[])new Object[0]) : (enabled ? "" : UIBundle.message((String)"welcome.screen.disabled.plugins.description", (Object[])new Object[0]))), LINK_FONT, false, 180, 2);
        JLabel logoName = new JLabel(shortenedName);
        logoName.setFont(LINK_FONT);
        logoName.setForeground(enabled ? CAPTION_COLOR : DISABLED_CAPTION_COLOR);
        if (shortenedName.endsWith(___HTML_SUFFIX)) {
            logoName.setToolTipText(this.adjustStringBreaksByWidth(name, UIUtil.getToolTipFont(), false, 400, 0));
        }
        gBC = new GridBagConstraints(1, y, 1, 1, 0.0, 0.0, 18, 0, new Insets(15, 7, 0, 0), 0, 0);
        panel.add((Component)logoName, gBC);
        if (!StringUtil.isEmpty((String)description)) {
            if ((description = description.trim()).startsWith("<html>") && (description = description.replaceAll("<html>", "")).endsWith("</html>")) {
                description = description.replaceAll("</html>", "");
            }
            description = description.replaceAll(ESC_NEW_LINE, "");
            String shortenedDcs = this.adjustStringBreaksByWidth(description, TEXT_FONT, false, 260, 2);
            JLabel pluginDescription = new JLabel(shortenedDcs);
            pluginDescription.setFont(TEXT_FONT);
            if (shortenedDcs.endsWith(___HTML_SUFFIX)) {
                pluginDescription.setToolTipText(this.adjustStringBreaksByWidth(description, UIUtil.getToolTipFont(), false, 400, 0));
            }
            gBC = new GridBagConstraints(1, y + 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 7, 0, 0), 5, 0);
            panel.add((Component)pluginDescription, gBC);
        }
        if (!StringUtil.isEmptyOrSpaces((String)url)) {
            gBC = new GridBagConstraints(2, y + 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 7, 0, 10), 0, 0);
            PluginsActionButton learnMore = new PluginsActionButton(LEARN_MORE_ICON, null){

                @Override
                protected void onPress(InputEvent e) {
                    try {
                        BrowserUtil.launchBrowser((String)url);
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        // empty catch block
                    }
                }
            };
            learnMore.setCursor(Cursor.getPredefinedCursor(12));
            learnMore.setToolTipText(UIBundle.message((String)"welcome.screen.plugins.panel.learn.more.tooltip.text", (Object[])new Object[0]));
            panel.add((Component)learnMore, gBC);
            ((MyActionButton)learnMore).setupWithinPanel(this.myPluginsPanel, 1, this.myPluginsButtonsCount, 0);
            ++this.myPluginsButtonsCount;
        }
        gBC = new GridBagConstraints(2, y, 2, 2, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 10), 0, 0);
        JPanel emptyPane = new JPanel();
        emptyPane.setBackground(PLUGINS_PANEL_COLOR);
        panel.add((Component)emptyPane, gBC);
    }

    private String adjustStringBreaksByWidth(String string, Font font, boolean isAntiAliased, int maxWidth, int maxRows) {
        if (StringUtil.isEmpty((String)(string = string.trim()))) {
            return "<html>" + UIBundle.message((String)"welcome.script.text.not.specified.message", (Object[])new Object[0]) + "</html>";
        }
        string = string.replaceAll("<li>", " <>&gt; ");
        string = string.replaceAll("<br>", " <>");
        string = string.replaceAll("(<[^>]+?>)", " ");
        Rectangle2D r = font.getStringBounds(string = string.replaceAll("[\\s]{2,}", " "), new FontRenderContext(new AffineTransform(), isAntiAliased, false));
        if (r.getWidth() > (double)maxWidth) {
            int i;
            StringBuffer prefix = new StringBuffer();
            String suffix = string;
            int maxIdxPerLine = (int)((double)maxWidth / r.getWidth() * (double)string.length());
            int lengthLeft = string.length();
            int rows = maxRows;
            if (rows <= 0) {
                rows = string.length() / maxIdxPerLine + 1;
            }
            while (lengthLeft > maxIdxPerLine && rows > 1) {
                for (i = maxIdxPerLine; i > 0; --i) {
                    if (suffix.charAt(i) != ' ') continue;
                    prefix.append(suffix.substring(0, i)).append("<br>");
                    suffix = suffix.substring(i + 1, suffix.length());
                    lengthLeft = suffix.length();
                    if (maxRows > 0) {
                        --rows;
                        break;
                    }
                    rows = lengthLeft / maxIdxPerLine + 1;
                    break;
                }
                if (i != 0) continue;
                if (rows <= 1 || maxRows > 0) break;
                prefix.append(suffix.substring(0, maxIdxPerLine)).append("<br>");
                suffix = suffix.substring(maxIdxPerLine, suffix.length());
                lengthLeft = suffix.length();
                --rows;
            }
            if (suffix.length() > maxIdxPerLine) {
                suffix = suffix.substring(0, maxIdxPerLine - 3);
                for (i = suffix.length() - 1; i > 0; --i) {
                    if (suffix.charAt(i) != ' ') continue;
                    if ("...".equals(suffix.substring(i - 3, i))) {
                        suffix = suffix.substring(0, i - 1);
                        break;
                    }
                    if (suffix.charAt(i - 1) == '>') {
                        --i;
                        continue;
                    }
                    if (suffix.charAt(i - 1) == '.') {
                        suffix = suffix.substring(0, i) + "..";
                        break;
                    }
                    suffix = suffix.substring(0, i) + "...";
                    break;
                }
            }
            string = prefix + suffix;
        }
        string = string.replaceAll(" <>", "<br>");
        return "<html>" + string + "</html>";
    }

    static {
        TEXT_FONT = new Font(TAHOMA_FONT_NAME, 0, 11);
        LINK_FONT = new Font(TAHOMA_FONT_NAME, 1, 12);
        GROUP_CAPTION_FONT = new Font(TAHOMA_FONT_NAME, 1, 18);
        CAPTION_COLOR = new Color(47, 67, 96);
        DISABLED_CAPTION_COLOR = UIUtil.getInactiveTextColor();
        PLUGINS_PANEL_COLOR = new Color(229, 229, 229);
        MAIN_PANEL_COLOR = new Color(210, 213, 226);
        BUTTON_PUSHED_COLOR = new Color(130, 146, 185);
        BUTTON_POPPED_COLOR = new Color(181, 190, 214);
        MAIN_PANEL_BACKGROUND = new Color(238, 238, 238);
        LEARN_MORE_BUTTON_COLOR = new Color(238, 238, 238);
        GRAY_BORDER_COLOR = new Color(177, 177, 177);
        CAPTION_BACKGROUND = new Color(23, 52, 150);
        ACTION_BUTTON_COLOR = new Color(201, 205, 217);
        ACTION_BUTTON_BORDER_COLOR = new Color(166, 170, 182);
        WHITE_BORDER_COLOR = new Color(255, 255, 255);
    }

    private abstract class PluginsActionButton
    extends MyActionButton {
        protected PluginsActionButton(Icon icon, String displayName) {
            super(icon, displayName);
        }

        @Override
        public Dimension getMaximumSize() {
            return LEARN_MORE_SIZE;
        }

        @Override
        public Dimension getMinimumSize() {
            return LEARN_MORE_SIZE;
        }

        @Override
        public Dimension getPreferredSize() {
            return LEARN_MORE_SIZE;
        }

        @Override
        protected Color getNormalButtonColor() {
            return LEARN_MORE_BUTTON_COLOR;
        }

        @Override
        protected void paintBorder(Graphics g) {
            Rectangle rectangle = new Rectangle(this.getSize());
            Color color = WHITE_BORDER_COLOR;
            g.setColor(color);
            UIUtil.drawLine((Graphics)g, (int)rectangle.x, (int)rectangle.y, (int)rectangle.x, (int)(rectangle.y + rectangle.height - 1));
            UIUtil.drawLine((Graphics)g, (int)rectangle.x, (int)rectangle.y, (int)(rectangle.x + rectangle.width - 1), (int)rectangle.y);
            color = GRAY_BORDER_COLOR;
            g.setColor(color);
            UIUtil.drawLine((Graphics)g, (int)(rectangle.x + rectangle.width - 1), (int)(rectangle.y + 1), (int)(rectangle.x + rectangle.width - 1), (int)(rectangle.y + rectangle.height - 1));
            UIUtil.drawLine((Graphics)g, (int)(rectangle.x + 1), (int)(rectangle.y + rectangle.height - 1), (int)(rectangle.x + rectangle.width - 1), (int)(rectangle.y + rectangle.height - 1));
        }
    }

    private abstract class ButtonWithExtension
    extends MyActionButton {
        private ButtonWithExtension(Icon icon, String displayName) {
            super(icon, displayName);
        }

        @Override
        protected void onPress(InputEvent e) {
            this.onPress(e, this);
        }

        protected abstract void onPress(InputEvent var1, MyActionButton var2);
    }

    private abstract class MyActionButton
    extends JComponent
    implements ActionButtonComponent {
        private int myGroupIdx;
        private int myRowIdx;
        private int myColumnIdx;
        private final String myDisplayName;
        private final Icon myIcon;

        private MyActionButton(Icon icon, String displayName) {
            this.myDisplayName = displayName;
            this.myIcon = new LabeledIcon(icon != null ? icon : DEFAULT_ICON, this.getDisplayName(), null);
        }

        private void setupWithinPanel(JPanel panel, int groupIdx, int rowIdx, int columnIdx) {
            this.myGroupIdx = groupIdx;
            this.myRowIdx = rowIdx;
            this.myColumnIdx = columnIdx;
            this.setToolTipText(null);
            this.setupListeners(panel);
        }

        protected int getColumnIdx() {
            return this.myColumnIdx;
        }

        protected int getGroupIdx() {
            return this.myGroupIdx;
        }

        protected int getRowIdx() {
            return this.myRowIdx;
        }

        protected String getDisplayName() {
            return this.myDisplayName != null ? this.myDisplayName : "";
        }

        @Override
        public Dimension getMaximumSize() {
            return ACTION_BUTTON_SIZE;
        }

        @Override
        public Dimension getMinimumSize() {
            return ACTION_BUTTON_SIZE;
        }

        @Override
        public Dimension getPreferredSize() {
            return ACTION_BUTTON_SIZE;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            ActionButtonLook look = ActionButtonLook.IDEA_LOOK;
            this.paintBackground(g);
            look.paintIcon(g, this, this.myIcon);
            this.paintBorder(g);
        }

        protected Color getNormalButtonColor() {
            return ACTION_BUTTON_COLOR;
        }

        protected void paintBackground(Graphics g) {
            Dimension dimension = this.getSize();
            int state = this.getPopState();
            if (state != 0) {
                if (state == 1) {
                    g.setColor(BUTTON_POPPED_COLOR);
                    g.fillRect(0, 0, dimension.width, dimension.height);
                } else {
                    g.setColor(BUTTON_PUSHED_COLOR);
                    g.fillRect(0, 0, dimension.width, dimension.height);
                }
            } else {
                g.setColor(this.getNormalButtonColor());
                g.fillRect(0, 0, dimension.width, dimension.height);
            }
            if (state == -1) {
                g.setColor(BUTTON_PUSHED_COLOR);
                g.fillRect(0, 0, dimension.width, dimension.height);
            }
        }

        @Override
        protected void paintBorder(Graphics g) {
            Rectangle rectangle = new Rectangle(this.getSize());
            Color color = ACTION_BUTTON_BORDER_COLOR;
            g.setColor(color);
            UIUtil.drawLine((Graphics)g, (int)rectangle.x, (int)rectangle.y, (int)rectangle.x, (int)(rectangle.y + rectangle.height - 1));
            UIUtil.drawLine((Graphics)g, (int)rectangle.x, (int)rectangle.y, (int)(rectangle.x + rectangle.width - 1), (int)rectangle.y);
            UIUtil.drawLine((Graphics)g, (int)(rectangle.x + rectangle.width - 1), (int)rectangle.y, (int)(rectangle.x + rectangle.width - 1), (int)(rectangle.y + rectangle.height - 1));
            UIUtil.drawLine((Graphics)g, (int)rectangle.x, (int)(rectangle.y + rectangle.height - 1), (int)(rectangle.x + rectangle.width - 1), (int)(rectangle.y + rectangle.height - 1));
        }

        public int getPopState() {
            if (WelcomeScreen.this.myKeypressedButton == this) {
                return -1;
            }
            if (WelcomeScreen.this.myKeypressedButton != null) {
                return 0;
            }
            if (WelcomeScreen.this.mySelectedColumn == this.myColumnIdx && WelcomeScreen.this.mySelectedRow == this.myRowIdx && WelcomeScreen.this.mySelectedGroup == this.myGroupIdx) {
                return 1;
            }
            return 0;
        }

        private void setupListeners(final JPanel panel) {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    WelcomeScreen.this.myKeypressedButton = MyActionButton.this;
                    panel.repaint();
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (WelcomeScreen.this.myKeypressedButton == MyActionButton.this) {
                        WelcomeScreen.this.myKeypressedButton = null;
                        MyActionButton.this.onPress(e);
                    } else {
                        WelcomeScreen.this.myKeypressedButton = null;
                    }
                    panel.repaint();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    WelcomeScreen.this.mySelectedColumn = -1;
                    WelcomeScreen.this.mySelectedRow = -1;
                    WelcomeScreen.this.mySelectedGroup = -1;
                    panel.repaint();
                }
            });
            this.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseDragged(MouseEvent e) {
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    WelcomeScreen.this.mySelectedColumn = MyActionButton.this.myColumnIdx;
                    WelcomeScreen.this.mySelectedRow = MyActionButton.this.myRowIdx;
                    WelcomeScreen.this.mySelectedGroup = MyActionButton.this.myGroupIdx;
                    panel.repaint();
                }
            });
        }

        protected abstract void onPress(InputEvent var1);
    }

    private class ActionGroupDescriptor {
        private int myIdx = -1;
        private int myCount = 0;
        private final JPanel myPanel;
        private final int myColumnIdx;
        @NonNls
        protected static final String HTML_PREFIX = "<html>";
        @NonNls
        protected static final String HTML_SUFFIX = "</html>";

        public ActionGroupDescriptor(String caption, int columnIndex) {
            JPanel panel = new JPanel(new GridBagLayout()){

                @Override
                public Dimension getPreferredSize() {
                    return this.getMinimumSize();
                }
            };
            panel.setBackground(MAIN_PANEL_COLOR);
            JLabel actionGroupCaption = new JLabel(caption);
            actionGroupCaption.setFont(GROUP_CAPTION_FONT);
            actionGroupCaption.setForeground(CAPTION_COLOR);
            GridBagConstraints gBC = new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 0, ACTION_GROUP_CAPTION_INSETS, 0, 0);
            panel.add((Component)actionGroupCaption, gBC);
            this.myPanel = panel;
            this.myColumnIdx = columnIndex;
        }

        public void addButton(final MyActionButton button, String commandLink, String description) {
            int y = this.myIdx += 2;
            GridBagConstraints gBC = new GridBagConstraints(0, y, 1, 2, 0.0, 0.0, 18, 0, ICON_INSETS, 5, 5);
            button.setCursor(Cursor.getPredefinedCursor(12));
            this.myPanel.add((Component)button, gBC);
            button.setupWithinPanel(WelcomeScreen.this.myMainPanel, 0, this.myCount, this.myColumnIdx);
            ++this.myCount;
            JLabel name = new JLabel(this.underlineHtmlText(commandLink));
            name.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    button.onPress(e);
                }
            });
            name.setForeground(CAPTION_COLOR);
            name.setFont(LINK_FONT);
            name.setCursor(Cursor.getPredefinedCursor(12));
            gBC = new GridBagConstraints(1, y, 1, 1, 0.0, 0.0, 16, 0, new Insets(15, 15, 0, 0), 5, 0);
            this.myPanel.add((Component)name, gBC);
            description = this.wrapWithHtml(description);
            JLabel shortDescription = new JLabel(description);
            shortDescription.setFont(TEXT_FONT);
            gBC = new GridBagConstraints(1, y + 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(7, 15, 0, 30), 5, 0);
            this.myPanel.add((Component)shortDescription, gBC);
        }

        private String wrapWithHtml(String description) {
            return HTML_PREFIX + description + HTML_SUFFIX;
        }

        private String underlineHtmlText(String commandLink) {
            return "<html><nobr><u>" + commandLink + "</u></nobr></html>";
        }

        private void appendActionsFromGroup(ActionGroup group) {
            AnAction[] actions = group.getChildren(null);
            PresentationFactory factory = new PresentationFactory();
            for (AnAction action : actions) {
                if (action instanceof ActionGroup) {
                    ActionGroup childGroup = (ActionGroup)action;
                    this.appendActionsFromGroup(childGroup);
                    continue;
                }
                Presentation presentation = factory.getPresentation(action);
                action.update(new AnActionEvent(null, DataManager.getInstance().getDataContext((Component)WelcomeScreen.this.myMainPanel), "WelcomeScreen", presentation, ActionManager.getInstance(), 0));
                if (!presentation.isVisible()) continue;
                this.appendButtonForAction(action);
            }
        }

        public void appendButtonForAction(final AnAction action) {
            Presentation presentation = action.getTemplatePresentation();
            Icon icon = presentation.getIcon();
            String text = presentation.getText();
            ButtonWithExtension button = new ButtonWithExtension(icon, ""){

                @Override
                protected void onPress(InputEvent e, MyActionButton button) {
                    ActionManager actionManager = ActionManager.getInstance();
                    AnActionEvent evt = new AnActionEvent(null, DataManager.getInstance().getDataContext(e.getComponent()), "WelcomeScreen", action.getTemplatePresentation(), actionManager, 0);
                    action.beforeActionPerformedUpdate(evt);
                    if (evt.getPresentation().isEnabled()) {
                        action.actionPerformed(evt);
                    }
                }
            };
            this.addButton(button, text, presentation.getDescription());
        }

        public JPanel getPanel() {
            return this.myPanel;
        }

        public int getIdx() {
            return this.myIdx;
        }
    }
}

