/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.wrappers;

import com.intellij.lang.ASTNode;
import com.intellij.pom.PomModel;
import com.intellij.pom.PomModelAspect;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.tree.TreeAspect;
import com.intellij.pom.tree.events.ChangeInfo;
import com.intellij.pom.tree.events.ReplaceChangeInfo;
import com.intellij.pom.tree.events.TreeChange;
import com.intellij.pom.tree.events.TreeChangeEvent;
import com.intellij.pom.tree.events.impl.ChangeInfoImpl;
import com.intellij.pom.tree.events.impl.TreeChangeImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class PsiEventWrapperAspect
implements PomModelAspect {
    private final TreeAspect myTreeAspect;

    public PsiEventWrapperAspect(PomModel model, TreeAspect aspect) {
        this.myTreeAspect = aspect;
        model.registerAspect(PsiEventWrapperAspect.class, (PomModelAspect)this, Collections.singleton(aspect));
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    @NotNull
    public String getComponentName() {
        if ("PSI event wrapper aspect for POM" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/pom/wrappers/PsiEventWrapperAspect.getComponentName must not return null");
        }
        return "PSI event wrapper aspect for POM";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public void update(PomModelEvent event) {
        TreeChangeEvent changeSet = (TreeChangeEvent)event.getChangeSet((PomModelAspect)this.myTreeAspect);
        if (changeSet == null) {
            return;
        }
        ASTNode rootElement = changeSet.getRootElement();
        PsiFile file = (PsiFile)SourceTreeToPsiMap.treeElementToPsi(rootElement);
        PsiManagerImpl manager = (PsiManagerImpl)file.getManager();
        if (manager == null) {
            return;
        }
        if (file.isPhysical()) {
            ASTNode[] changedElements;
            for (ASTNode changedElement : changedElements = changeSet.getChangedElements()) {
                ASTNode[] affectedChildren;
                TreeChange changesByElement = changeSet.getChangesByElement(changedElement);
                PsiElement psiParent = null;
                while (!(changedElement == null || (psiParent = changedElement.getPsi()) != null && PsiEventWrapperAspect.checkPsiForChildren(changesByElement.getAffectedChildren()))) {
                    ASTNode parent = changedElement.getTreeParent();
                    ChangeInfoImpl changeInfo = ChangeInfoImpl.create((short)3, changedElement);
                    changeInfo.compactChange(changesByElement);
                    changesByElement = new TreeChangeImpl(parent);
                    changesByElement.addChange(changedElement, (ChangeInfo)changeInfo);
                    changedElement = parent;
                }
                if (changedElement == null) continue;
                block8: for (ASTNode treeElement : affectedChildren = changesByElement.getAffectedChildren()) {
                    PsiTreeChangeEventImpl psiEvent = new PsiTreeChangeEventImpl(manager);
                    psiEvent.setParent(psiParent);
                    psiEvent.setFile(file);
                    PsiElement psiChild = treeElement.getPsi();
                    psiEvent.setChild(psiChild);
                    ChangeInfo changeByChild = changesByElement.getChangeByChild(treeElement);
                    switch (changeByChild.getChangeType()) {
                        case 0: {
                            psiEvent.setOffset(treeElement.getStartOffset());
                            psiEvent.setOldLength(0);
                            manager.childAdded(psiEvent);
                            continue block8;
                        }
                        case 2: {
                            ReplaceChangeInfo change = (ReplaceChangeInfo)changeByChild;
                            psiEvent.setOffset(treeElement.getStartOffset());
                            ASTNode replaced = change.getReplaced();
                            psiEvent.setOldChild(replaced.getPsi());
                            psiEvent.setNewChild(psiChild);
                            psiEvent.setOldLength(replaced.getTextLength());
                            manager.childReplaced(psiEvent);
                            continue block8;
                        }
                        case 3: {
                            psiEvent.setOffset(treeElement.getStartOffset());
                            psiEvent.setOldChild(psiChild);
                            psiEvent.setNewChild(psiChild);
                            psiEvent.setOldLength(changeByChild.getOldLength());
                            manager.childReplaced(psiEvent);
                            continue block8;
                        }
                        case 1: {
                            psiEvent.setOffset(changesByElement.getChildOffsetInNewTree(treeElement));
                            psiEvent.setOldParent(psiParent);
                            psiEvent.setOldChild(psiChild);
                            psiEvent.setOldLength(changeByChild.getOldLength());
                            manager.childRemoved(psiEvent);
                        }
                    }
                }
            }
        } else {
            manager.nonPhysicalChange();
        }
    }

    private static boolean checkPsiForChildren(ASTNode[] affectedChildren) {
        for (ASTNode astNode : affectedChildren) {
            if (astNode.getPsi() != null) continue;
            return false;
        }
        return true;
    }
}

