/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui;

import com.intellij.CommonBundle;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ModifiableModel;
import com.intellij.codeInspection.ex.Descriptor;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolRegistrar;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.Profile;
import com.intellij.profile.ProfileManager;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.SeverityProvider;
import com.intellij.profile.codeInspection.ui.InspectionConfigTreeNode;
import com.intellij.profile.codeInspection.ui.InspectionsConfigTreeComparator;
import com.intellij.profile.codeInspection.ui.InspectionsConfigTreeRenderer;
import com.intellij.profile.codeInspection.ui.LevelChooser;
import com.intellij.profile.codeInspection.ui.actions.AddScopeAction;
import com.intellij.profile.codeInspection.ui.actions.DeleteScopeAction;
import com.intellij.profile.codeInspection.ui.actions.MoveScopeAction;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.FilterComponent;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SeparatorFactory;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.TreeToolTipHandler;
import com.intellij.ui.UserActivityListener;
import com.intellij.ui.UserActivityWatcher;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class SingleInspectionProfilePanel
extends JPanel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.ex.InspectionToolsPanel");
    @NonNls
    private static final String INSPECTION_FILTER_HISTORY = "INSPECTION_FILTER_HISTORY";
    private static final String UNDER_CONSTRUCTION = InspectionsBundle.message((String)"inspection.tool.description.under.construction.text", (Object[])new Object[0]);
    private final Map<Descriptor, List<Descriptor>> myDescriptors = new HashMap<Descriptor, List<Descriptor>>();
    private InspectionProfileImpl mySelectedProfile;
    private JEditorPane myBrowser;
    private JPanel myOptionsPanel;
    private final JPanel myInspectionProfilePanel = new JPanel(new BorderLayout());
    private FilterComponent myProfileFilter;
    private final InspectionConfigTreeNode myRoot = new InspectionConfigTreeNode(InspectionsBundle.message((String)"inspection.root.node.title", (Object[])new Object[0]), null, false, false, false);
    private final Alarm myAlarm = new Alarm();
    private boolean myModified = false;
    private Tree myTree;
    private TreeExpander myTreeExpander;
    private String myInitialProfile;
    @NonNls
    private static final String EMPTY_HTML = "<html><body></body></html>";
    private boolean myIsInRestore = false;
    private boolean myShareProfile;
    private final InspectionProjectProfileManager myProjectProfileManager;

    public SingleInspectionProfilePanel(String inspectionProfileName, ModifiableModel profile) {
        this(null, inspectionProfileName, profile);
    }

    public SingleInspectionProfilePanel(InspectionProjectProfileManager projectProfileManager, String inspectionProfileName, ModifiableModel profile) {
        super(new BorderLayout());
        this.myProjectProfileManager = projectProfileManager;
        this.mySelectedProfile = (InspectionProfileImpl)profile;
        this.myInitialProfile = inspectionProfileName;
        this.add((Component)this.createInspectionProfileSettingsPanel(), "Center");
        UserActivityWatcher userActivityWatcher = new UserActivityWatcher();
        userActivityWatcher.addUserActivityListener(new UserActivityListener(){

            public void stateChanged() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (SingleInspectionProfilePanel.this.mySelectedProfile == null) {
                            return;
                        }
                        SingleInspectionProfilePanel.this.updateProperSettingsForSelection();
                        SingleInspectionProfilePanel.this.wereToolSettingsModified();
                    }
                });
            }
        });
        userActivityWatcher.register((Component)this.myOptionsPanel);
        this.updateSelectedProfileState();
    }

    private void updateSelectedProfileState() {
        if (this.mySelectedProfile == null) {
            return;
        }
        this.restoreTreeState();
        this.repaintTableData();
        TreePath selectionPath = this.myTree.getSelectionPath();
        if (selectionPath != null) {
            TreeUtil.selectNode((JTree)this.myTree, (TreeNode)((TreeNode)selectionPath.getLastPathComponent()));
            TreeUtil.showRowCentered((JTree)this.myTree, (int)this.myTree.getRowForPath(selectionPath), (boolean)false);
        }
    }

    private void wereToolSettingsModified() {
        for (Map.Entry<Descriptor, List<Descriptor>> entry : this.myDescriptors.entrySet()) {
            Descriptor desc = entry.getKey();
            if (this.wereToolSettingsModified(desc)) {
                return;
            }
            List<Descriptor> descriptors = entry.getValue();
            for (Descriptor descriptor : descriptors) {
                if (!this.wereToolSettingsModified(descriptor)) continue;
                return;
            }
        }
        this.myModified = false;
    }

    private boolean wereToolSettingsModified(Descriptor descriptor) {
        InspectionProfileEntry tool = descriptor.getTool();
        if (tool == null || !this.mySelectedProfile.isToolEnabled(descriptor.getKey())) {
            return false;
        }
        Element oldConfig = descriptor.getConfig();
        Element newConfig = new Element("options");
        try {
            tool.writeSettings(newConfig);
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
        }
        if (!JDOMUtil.areElementsEqual((Element)oldConfig, (Element)newConfig)) {
            this.myAlarm.cancelAllRequests();
            this.myAlarm.addRequest(new Runnable(){

                @Override
                public void run() {
                    SingleInspectionProfilePanel.this.myTree.repaint();
                }
            }, 300);
            this.myModified = true;
            return true;
        }
        return false;
    }

    private void updateProperSettingsForSelection() {
        boolean properSetting;
        InspectionConfigTreeNode node;
        Descriptor descriptor;
        TreePath selectionPath = this.myTree.getSelectionPath();
        if (selectionPath != null && (descriptor = (node = (InspectionConfigTreeNode)((Object)selectionPath.getLastPathComponent())).getDesriptor()) != null && node.isProperSetting != (properSetting = this.mySelectedProfile.isProperSetting(descriptor.getKey()))) {
            this.myAlarm.cancelAllRequests();
            this.myAlarm.addRequest(new Runnable(){

                @Override
                public void run() {
                    SingleInspectionProfilePanel.this.myTree.repaint();
                }
            }, 300);
            node.isProperSetting = properSetting;
            SingleInspectionProfilePanel.updateUpHierarchy(node, (InspectionConfigTreeNode)((Object)node.getParent()));
        }
    }

    private void initDescriptors() {
        InspectionProfileImpl profile = this.mySelectedProfile;
        if (profile == null) {
            return;
        }
        this.myDescriptors.clear();
        List<ScopeToolState> tools = profile.getDefaultStates();
        for (ScopeToolState state : tools) {
            ArrayList<Descriptor> descriptors = new ArrayList<Descriptor>();
            this.myDescriptors.put(new Descriptor(state, profile), descriptors);
            List<ScopeToolState> nonDefaultTools = profile.getNonDefaultTools(state.getTool().getShortName());
            if (nonDefaultTools == null) continue;
            for (ScopeToolState nonDefaultToolState : nonDefaultTools) {
                descriptors.add(new Descriptor(nonDefaultToolState, profile));
            }
        }
    }

    private void postProcessModification() {
        this.wereToolSettingsModified();
        for (ScopeToolState state : this.mySelectedProfile.getAllTools()) {
            state.resetConfigPanel();
        }
        this.fillTreeData(this.myProfileFilter.getFilter(), true);
        this.repaintTableData();
        this.updateOptionsAndDescriptionPanel(this.myTree.getSelectionPath());
    }

    @Nullable
    public static ModifiableModel createNewProfile(int initValue, ModifiableModel selectedProfile, JPanel parent, String profileName) {
        if ((profileName = Messages.showInputDialog((Component)parent, (String)profileName, (String)"Create new inspection profile", (Icon)Messages.getQuestionIcon())) == null) {
            return null;
        }
        ProfileManager profileManager = selectedProfile.getProfileManager();
        if (ArrayUtil.find((Object[])profileManager.getAvailableProfileNames(), (Object)profileName) != -1) {
            Messages.showErrorDialog((String)InspectionsBundle.message((String)"inspection.unable.to.create.profile.message", (Object[])new Object[]{profileName}), (String)InspectionsBundle.message((String)"inspection.unable.to.create.profile.dialog.title", (Object[])new Object[0]));
            return null;
        }
        InspectionProfileImpl inspectionProfile = new InspectionProfileImpl(profileName, InspectionToolRegistrar.getInstance(), profileManager);
        if (initValue == -1) {
            InspectionProfileEntry[] profileEntries;
            inspectionProfile.initInspectionTools();
            ModifiableModel profileModifiableModel = inspectionProfile.getModifiableModel();
            for (InspectionProfileEntry entry : profileEntries = profileModifiableModel.getInspectionTools(null)) {
                profileModifiableModel.disableTool(entry.getShortName(), (NamedScope)null);
            }
            profileModifiableModel.setLocal(true);
            return profileModifiableModel;
        }
        if (initValue == 0) {
            inspectionProfile.copyFrom((Profile)selectedProfile);
            inspectionProfile.setName(profileName);
            inspectionProfile.initInspectionTools();
            return inspectionProfile;
        }
        return null;
    }

    public void filterTree(String filter) {
        if (this.myTree != null) {
            this.mySelectedProfile.getExpandedNodes().saveVisibleState(this.myTree);
            this.fillTreeData(filter, true);
            this.reloadModel();
            this.restoreTreeState();
            if (this.myTree.getSelectionPath() == null) {
                TreeUtil.selectFirstNode((JTree)this.myTree);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reloadModel() {
        try {
            this.myIsInRestore = true;
            ((DefaultTreeModel)this.myTree.getModel()).reload();
        }
        finally {
            this.myIsInRestore = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreTreeState() {
        try {
            this.myIsInRestore = true;
            this.mySelectedProfile.getExpandedNodes().restoreVisibleState(this.myTree);
        }
        finally {
            this.myIsInRestore = false;
        }
    }

    private ActionToolbar createTreeToolbarPanel() {
        CommonActionsManager actionManager = CommonActionsManager.getInstance();
        DefaultActionGroup actions = new DefaultActionGroup();
        actions.add(actionManager.createExpandAllAction(this.myTreeExpander, (JComponent)this.myTree));
        actions.add(actionManager.createCollapseAllAction(this.myTreeExpander, (JComponent)this.myTree));
        actions.add(new AnAction(CommonBundle.message((String)"button.reset.to.default", (Object[])new Object[0]), CommonBundle.message((String)"button.reset.to.default", (Object[])new Object[0]), IconLoader.getIcon((String)"/actions/reset-to-default.png")){
            {
                this.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(82, 2)), (JComponent)SingleInspectionProfilePanel.this.myTree);
            }

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(((SingleInspectionProfilePanel)SingleInspectionProfilePanel.this).myRoot.isProperSetting);
            }

            public void actionPerformed(AnActionEvent e) {
                SingleInspectionProfilePanel.this.mySelectedProfile.resetToBase();
                SingleInspectionProfilePanel.this.postProcessModification();
            }
        });
        actions.add(new AnAction("Reset to Empty", "Reset to empty", IconLoader.getIcon((String)"/general/reset.png")){

            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(SingleInspectionProfilePanel.this.mySelectedProfile != null && SingleInspectionProfilePanel.this.mySelectedProfile.isExecutable());
            }

            public void actionPerformed(AnActionEvent e) {
                SingleInspectionProfilePanel.this.mySelectedProfile.resetToEmpty();
                SingleInspectionProfilePanel.this.postProcessModification();
            }
        });
        actions.add((AnAction)new ToggleAction("Lock Profile", "Lock profile", IconLoader.getIcon((String)"/nodes/padlock.png")){

            public boolean isSelected(AnActionEvent e) {
                return SingleInspectionProfilePanel.this.mySelectedProfile != null && SingleInspectionProfilePanel.this.mySelectedProfile.isProfileLocked();
            }

            public void setSelected(AnActionEvent e, boolean state) {
                SingleInspectionProfilePanel.this.mySelectedProfile.lockProfile(state);
            }
        });
        actions.addSeparator();
        actions.add((AnAction)new AddScopeAction(this.myTree){

            @Override
            protected InspectionProfileImpl getSelectedProfile() {
                return SingleInspectionProfilePanel.this.mySelectedProfile;
            }

            @Override
            public void actionPerformed(AnActionEvent e) {
                super.actionPerformed(e);
                SingleInspectionProfilePanel.this.updateOptionsAndDescriptionPanel(SingleInspectionProfilePanel.this.myTree.getSelectionPath());
            }
        });
        actions.add((AnAction)new DeleteScopeAction(this.myTree){

            @Override
            protected InspectionProfileImpl getSelectedProfile() {
                return SingleInspectionProfilePanel.this.mySelectedProfile;
            }
        });
        actions.add((AnAction)new MoveScopeAction(this.myTree, "Move Scope Up", IconLoader.getIcon((String)"/actions/moveUp.png"), -1){

            @Override
            protected boolean isEnabledFor(int idx, InspectionConfigTreeNode parent) {
                return idx > 0;
            }

            @Override
            protected InspectionProfileImpl getSelectedProfile() {
                return SingleInspectionProfilePanel.this.mySelectedProfile;
            }
        });
        actions.add((AnAction)new MoveScopeAction(this.myTree, "Move Scope Down", IconLoader.getIcon((String)"/actions/moveDown.png"), 1){

            @Override
            protected boolean isEnabledFor(int idx, InspectionConfigTreeNode parent) {
                return idx < parent.getChildCount() - 2;
            }

            @Override
            protected InspectionProfileImpl getSelectedProfile() {
                return SingleInspectionProfilePanel.this.mySelectedProfile;
            }
        });
        actions.addSeparator();
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)actions, true);
        actionToolbar.setTargetComponent((JComponent)this);
        return actionToolbar;
    }

    private void repaintTableData() {
        if (this.myTree != null) {
            this.mySelectedProfile.getExpandedNodes().saveVisibleState(this.myTree);
            this.reloadModel();
            this.restoreTreeState();
        }
    }

    public void selectInspectionTool(String name) {
        InspectionConfigTreeNode node = SingleInspectionProfilePanel.findNodeByKey(name, this.myRoot);
        if (node != null) {
            TreeUtil.showRowCentered((JTree)this.myTree, (int)(this.myTree.getRowForPath(new TreePath(node.getPath())) - 1), (boolean)true);
            TreeUtil.selectNode((JTree)this.myTree, (TreeNode)((Object)node));
        }
    }

    @Nullable
    private static InspectionConfigTreeNode findNodeByKey(String name, InspectionConfigTreeNode root) {
        for (int i = 0; i < root.getChildCount(); ++i) {
            InspectionConfigTreeNode child = (InspectionConfigTreeNode)((Object)root.getChildAt(i));
            Descriptor descriptor = child.getDesriptor();
            if (descriptor != null) {
                if (!descriptor.getKey().toString().equals(name)) continue;
                return child;
            }
            InspectionConfigTreeNode node = SingleInspectionProfilePanel.findNodeByKey(name, child);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    private JScrollPane initTreeScrollPane() {
        this.fillTreeData(null, true);
        InspectionsConfigTreeRenderer renderer = new InspectionsConfigTreeRenderer(){

            @Override
            protected String getFilter() {
                return SingleInspectionProfilePanel.this.myProfileFilter != null ? SingleInspectionProfilePanel.this.myProfileFilter.getFilter() : null;
            }
        };
        this.myTree = new CheckboxTree(renderer, this.myRoot){

            public Dimension getPreferredScrollableViewportSize() {
                Dimension size = super.getPreferredScrollableViewportSize();
                size = new Dimension(size.width + 10, size.height);
                return size;
            }

            public int getToggleClickCount() {
                return -1;
            }

            protected void onNodeStateChanged(CheckedTreeNode node) {
                SingleInspectionProfilePanel.this.toggleToolNode((InspectionConfigTreeNode)node);
            }
        };
        this.myTree.setCellRenderer((TreeCellRenderer)((Object)renderer));
        this.myTree.setRootVisible(true);
        this.myTree.setShowsRootHandles(true);
        UIUtil.setLineStyleAngled((JTree)this.myTree);
        TreeToolTipHandler.install((JTree)this.myTree);
        TreeUtil.installActions((JTree)this.myTree);
        this.myTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                InspectionProfileImpl selected;
                if (SingleInspectionProfilePanel.this.myTree.getSelectionPaths() != null && SingleInspectionProfilePanel.this.myTree.getSelectionPaths().length == 1) {
                    SingleInspectionProfilePanel.this.updateOptionsAndDescriptionPanel(SingleInspectionProfilePanel.this.myTree.getSelectionPaths()[0]);
                } else {
                    SingleInspectionProfilePanel.this.initOptionsAndDescriptionPanel();
                }
                if (!SingleInspectionProfilePanel.this.myIsInRestore && (selected = SingleInspectionProfilePanel.this.mySelectedProfile) != null) {
                    InspectionProfileImpl baseProfile = (InspectionProfileImpl)selected.getParentProfile();
                    if (baseProfile != null) {
                        baseProfile.getExpandedNodes().setSelectionPaths(SingleInspectionProfilePanel.this.myTree.getSelectionPaths());
                    }
                    selected.getExpandedNodes().setSelectionPaths(SingleInspectionProfilePanel.this.myTree.getSelectionPaths());
                }
            }
        });
        this.myTree.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                int[] selectionRows = SingleInspectionProfilePanel.this.myTree.getSelectionRows();
                if (selectionRows != null && SingleInspectionProfilePanel.this.myTree.getPathForLocation(x, y) != null && Arrays.binarySearch(selectionRows, SingleInspectionProfilePanel.this.myTree.getRowForLocation(x, y)) > -1) {
                    SingleInspectionProfilePanel.this.compoundPopup().show(comp, x, y);
                }
            }
        });
        new TreeSpeedSearch(this.myTree, new Convertor<TreePath, String>(){

            public String convert(TreePath o) {
                InspectionConfigTreeNode node = (InspectionConfigTreeNode)((Object)o.getLastPathComponent());
                Descriptor descriptor = node.getDesriptor();
                return descriptor != null ? InspectionsConfigTreeComparator.getDisplayTextToSort(descriptor.getText()) : InspectionsConfigTreeComparator.getDisplayTextToSort(node.getGroupName());
            }
        });
        this.myTree.setSelectionModel((TreeSelectionModel)new DefaultTreeSelectionModel());
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((JComponent)this.myTree);
        scrollPane.setHorizontalScrollBarPolicy(30);
        TreeUtil.collapseAll((JTree)this.myTree, (int)1);
        Dimension preferredSize = new Dimension(this.myTree.getPreferredSize().width + 20, scrollPane.getPreferredSize().height);
        scrollPane.setPreferredSize(preferredSize);
        scrollPane.setMinimumSize(preferredSize);
        this.myTree.addTreeExpansionListener(new TreeExpansionListener(){

            private String getExpandedString(TreePath treePath) {
                InspectionConfigTreeNode node = (InspectionConfigTreeNode)((Object)treePath.getLastPathComponent());
                Descriptor descriptor = node.getDesriptor();
                if (descriptor != null) {
                    return descriptor.getText();
                }
                return node.getGroupName();
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                InspectionProfileImpl selected = SingleInspectionProfilePanel.this.mySelectedProfile;
                String nodeTitle = this.getExpandedString(event.getPath());
                InspectionProfileImpl parentProfile = (InspectionProfileImpl)selected.getParentProfile();
                if (parentProfile != null) {
                    parentProfile.getExpandedNodes().collapseNode(nodeTitle);
                }
                selected.getExpandedNodes().collapseNode(nodeTitle);
            }

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                InspectionProfileImpl selected = SingleInspectionProfilePanel.this.mySelectedProfile;
                String nodeTitle = this.getExpandedString(event.getPath());
                InspectionProfileImpl parentProfile = (InspectionProfileImpl)selected.getParentProfile();
                if (parentProfile != null) {
                    parentProfile.getExpandedNodes().expandNode(nodeTitle);
                }
                selected.getExpandedNodes().expandNode(nodeTitle);
            }
        });
        this.myTreeExpander = new DefaultTreeExpander((JTree)this.myTree);
        this.myProfileFilter = new MyFilterComponent();
        return scrollPane;
    }

    private JPopupMenu compoundPopup() {
        JPopupMenu popup = new JPopupMenu(InspectionsBundle.message((String)"inspection.error.level.popup.menu.title", (Object[])new Object[0]));
        SeverityRegistrar severityRegistrar = ((SeverityProvider)this.mySelectedProfile.getProfileManager()).getOwnSeverityRegistrar();
        TreeSet<HighlightSeverity> severities = new TreeSet<HighlightSeverity>(severityRegistrar);
        severities.add(HighlightSeverity.ERROR);
        severities.add(HighlightSeverity.WARNING);
        severities.add(HighlightSeverity.INFO);
        Collection<SeverityRegistrar.SeverityBasedTextAttributes> infoTypes = severityRegistrar.getRegisteredHighlightingInfoTypes();
        for (SeverityRegistrar.SeverityBasedTextAttributes info : infoTypes) {
            severities.add(info.getSeverity());
        }
        for (HighlightSeverity severity : severities) {
            HighlightDisplayLevel level = HighlightDisplayLevel.find((HighlightSeverity)severity);
            JMenuItem item = new JMenuItem(SingleInspectionProfilePanel.renderSeverity(level.getSeverity()));
            item.setIcon(level.getIcon());
            item.addActionListener(new LevelSelection(level));
            popup.add(item);
        }
        return popup;
    }

    static String renderSeverity(HighlightSeverity severity) {
        return InspectionsBundle.message((String)"inspection.as", (Object[])new Object[]{severity.toString().toLowerCase()});
    }

    private void toggleToolNode(InspectionConfigTreeNode toolNode) {
        Descriptor descriptor = toolNode.getDesriptor();
        if (descriptor != null) {
            HighlightDisplayKey key = descriptor.getKey();
            String toolShortName = key.toString();
            if (toolNode.isChecked()) {
                if (toolNode.getScope() != null) {
                    if (toolNode.isByDefault()) {
                        this.mySelectedProfile.enableToolByDefault(toolShortName);
                    } else {
                        this.mySelectedProfile.enableTool(toolShortName, toolNode.getScope());
                    }
                } else {
                    this.mySelectedProfile.enableTool(toolShortName);
                }
            } else if (toolNode.getScope() != null) {
                if (toolNode.isByDefault()) {
                    this.mySelectedProfile.disableToolByDefault(toolShortName);
                } else {
                    this.mySelectedProfile.disableTool(toolShortName, toolNode.getScope());
                }
            } else if (toolNode.getChildCount() == 0) {
                this.mySelectedProfile.disableTool(toolShortName);
            }
            toolNode.isProperSetting = this.mySelectedProfile.isProperSetting(key);
            SingleInspectionProfilePanel.updateUpHierarchy(toolNode, (InspectionConfigTreeNode)((Object)toolNode.getParent()));
        }
        TreePath path = new TreePath(toolNode.getPath());
        if (Comparing.equal((Object)this.myTree.getSelectionPath(), (Object)path)) {
            this.updateOptionsAndDescriptionPanel(path);
        }
    }

    private static void updateUpHierarchy(InspectionConfigTreeNode node, InspectionConfigTreeNode parent) {
        if (parent != null) {
            parent.isProperSetting = node.isProperSetting || SingleInspectionProfilePanel.wasModified(parent);
            SingleInspectionProfilePanel.updateUpHierarchy(parent, (InspectionConfigTreeNode)((Object)parent.getParent()));
        }
    }

    private static boolean wasModified(InspectionConfigTreeNode node) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            InspectionConfigTreeNode childNode = (InspectionConfigTreeNode)((Object)node.getChildAt(i));
            if (!childNode.isProperSetting) continue;
            return true;
        }
        return false;
    }

    private static boolean isDescriptorAccepted(Descriptor descriptor, @NonNls String filter, boolean forceInclude, List<Set<String>> keySetList, Set<String> quoted) {
        String[] groupPath;
        filter = filter.toLowerCase();
        if (StringUtil.containsIgnoreCase((String)descriptor.getText(), (String)filter)) {
            return true;
        }
        for (String group : groupPath = descriptor.getGroup()) {
            if (!StringUtil.containsIgnoreCase((String)group, (String)filter)) continue;
            return true;
        }
        for (String string : quoted) {
            if (StringUtil.containsIgnoreCase((String)descriptor.getText(), (String)string)) {
                return true;
            }
            for (String group : groupPath) {
                if (!StringUtil.containsIgnoreCase((String)group, (String)string)) continue;
                return true;
            }
            String description = descriptor.getTool().loadDescription();
            if (description != null && StringUtil.containsIgnoreCase((String)description.toLowerCase(), (String)string)) {
                if (forceInclude) continue;
                return true;
            }
            if (!forceInclude) continue;
            return false;
        }
        for (Set set : keySetList) {
            if (set.contains(descriptor.getKey().toString())) {
                if (forceInclude) continue;
                return true;
            }
            if (!forceInclude) continue;
            return false;
        }
        return forceInclude;
    }

    private void fillTreeData(String filter, boolean forceInclude) {
        Set filters;
        if (this.mySelectedProfile == null) {
            return;
        }
        this.myRoot.removeAllChildren();
        this.myRoot.setChecked(false);
        this.myRoot.isProperSetting = false;
        ArrayList<Set<String>> keySetList = new ArrayList<Set<String>>();
        HashSet<String> quated = new HashSet<String>();
        if (filter != null && filter.length() > 0) {
            keySetList.addAll(SearchUtil.findKeys(filter, quated));
        }
        for (Descriptor descriptor : this.myDescriptors.keySet()) {
            if (filter != null && filter.length() > 0 && !SingleInspectionProfilePanel.isDescriptorAccepted(descriptor, filter, forceInclude, keySetList, quated)) continue;
            List<ScopeToolState> nonDefaultTools = this.mySelectedProfile.getNonDefaultTools(descriptor.getKey().toString());
            HighlightDisplayKey key = descriptor.getKey();
            boolean enabled = this.mySelectedProfile.isToolEnabled(key);
            boolean properSetting = this.mySelectedProfile.isProperSetting(key);
            boolean hasNonDefaultScope = nonDefaultTools != null && !nonDefaultTools.isEmpty();
            InspectionConfigTreeNode node = new InspectionConfigTreeNode(descriptor, null, !hasNonDefaultScope, enabled, properSetting, !hasNonDefaultScope);
            SingleInspectionProfilePanel.getGroupNode(this.myRoot, descriptor.getGroup(), properSetting).add((MutableTreeNode)((Object)node));
            if (hasNonDefaultScope) {
                for (ScopeToolState nonDefaultState : nonDefaultTools) {
                    node.add((MutableTreeNode)((Object)new InspectionConfigTreeNode(new Descriptor(nonDefaultState, this.mySelectedProfile), nonDefaultState, false, properSetting, false)));
                }
                node.add((MutableTreeNode)((Object)new InspectionConfigTreeNode(descriptor, descriptor.getState(), true, properSetting, false)));
            }
            this.myRoot.setEnabled(this.myRoot.isEnabled() || enabled);
            this.myRoot.isProperSetting |= properSetting;
        }
        if (filter != null && forceInclude && this.myRoot.getChildCount() == 0 && (filters = SearchableOptionsRegistrar.getInstance().getProcessedWords(filter)).size() > 1) {
            this.fillTreeData(filter, false);
        }
        TreeUtil.sort((DefaultMutableTreeNode)((Object)this.myRoot), (Comparator)new InspectionsConfigTreeComparator());
    }

    private void updateOptionsAndDescriptionPanel(TreePath path) {
        if (path == null) {
            return;
        }
        final InspectionConfigTreeNode node = (InspectionConfigTreeNode)((Object)path.getLastPathComponent());
        Descriptor descriptor = node.getDesriptor();
        if (descriptor != null) {
            String description = descriptor.loadDescription();
            if (description != null) {
                try {
                    this.myBrowser.read(new StringReader(SearchUtil.markup(description, this.myProfileFilter.getFilter())), null);
                }
                catch (IOException e2) {
                    try {
                        this.myBrowser.read(new StringReader("<html><body><b>" + UNDER_CONSTRUCTION + "</b></body></html>"), null);
                    }
                    catch (IOException e1) {}
                }
            } else {
                try {
                    this.myBrowser.read(new StringReader(EMPTY_HTML), null);
                }
                catch (IOException e1) {
                    // empty catch block
                }
            }
            this.myOptionsPanel.removeAll();
            this.myOptionsPanel.add((Component)SeparatorFactory.createSeparator((String)"Options", null), "North");
            final NamedScope scope = node.getScope();
            if (scope != null || node.isInspectionNode()) {
                final HighlightDisplayKey key = descriptor.getKey();
                final LevelChooser chooser = new LevelChooser(((SeverityProvider)this.mySelectedProfile.getProfileManager()).getOwnSeverityRegistrar());
                chooser.getComboBox().addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        boolean toUpdate = SingleInspectionProfilePanel.this.mySelectedProfile.getErrorLevel(key, scope) != chooser.getLevel();
                        SingleInspectionProfilePanel.this.mySelectedProfile.setErrorLevel(key, chooser.getLevel(), node.isInspectionNode() || node.isByDefault() ? -1 : node.getParent().getIndex((TreeNode)((Object)node)));
                        if (toUpdate) {
                            node.isProperSetting = SingleInspectionProfilePanel.this.mySelectedProfile.isProperSetting(key);
                        }
                    }
                });
                chooser.setLevel(this.mySelectedProfile.getErrorLevel(key, scope));
                JPanel withSeverity = new JPanel(new GridBagLayout());
                withSeverity.add((Component)new JLabel(InspectionsBundle.message((String)"inspection.severity", (Object[])new Object[0])), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 10), 0, 0));
                Dimension dimension = new Dimension(150, chooser.getPreferredSize().height);
                chooser.setPreferredSize(dimension);
                chooser.setMinimumSize(dimension);
                withSeverity.add((Component)((Object)chooser), new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
                JComponent comp = descriptor.getState().getAdditionalConfigPanel();
                if (comp != null) {
                    withSeverity.add((Component)comp, new GridBagConstraints(0, -1, 2, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
                } else {
                    withSeverity.add((Component)new JPanel(), new GridBagConstraints(0, -1, 2, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
                }
                this.myOptionsPanel.add((Component)withSeverity, "Center");
            }
            this.myOptionsPanel.validate();
            GuiUtils.enableChildren((Component)this.myOptionsPanel, (boolean)node.isChecked(), (JComponent[])new JComponent[0]);
        } else {
            this.initOptionsAndDescriptionPanel();
        }
        this.myOptionsPanel.repaint();
    }

    private void initOptionsAndDescriptionPanel() {
        this.myOptionsPanel.removeAll();
        this.myOptionsPanel.add(SeparatorFactory.createSeparator((String)"Options", null));
        this.myOptionsPanel.add(new JPanel());
        try {
            this.myBrowser.read(new StringReader(EMPTY_HTML), null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.myOptionsPanel.validate();
        this.myOptionsPanel.repaint();
    }

    private static InspectionConfigTreeNode getGroupNode(InspectionConfigTreeNode root, String[] groupPath, boolean properSetting) {
        InspectionConfigTreeNode currentRoot = root;
        for (String group : groupPath) {
            currentRoot = SingleInspectionProfilePanel.getGroupNode(currentRoot, group, properSetting);
        }
        return currentRoot;
    }

    private static InspectionConfigTreeNode getGroupNode(InspectionConfigTreeNode root, String group, boolean properSetting) {
        int childCount = root.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            InspectionConfigTreeNode child = (InspectionConfigTreeNode)((Object)root.getChildAt(i));
            if (!group.equals(child.getUserObject())) continue;
            child.isProperSetting |= properSetting;
            return child;
        }
        InspectionConfigTreeNode child = new InspectionConfigTreeNode(group, null, false, properSetting, false);
        root.add((MutableTreeNode)((Object)child));
        return child;
    }

    public boolean setSelectedProfileModified(boolean modified) {
        this.mySelectedProfile.setModified(modified);
        return modified;
    }

    ModifiableModel getSelectedProfile() {
        return this.mySelectedProfile;
    }

    private void setSelectedProfile(ModifiableModel modifiableModel) {
        this.mySelectedProfile = (InspectionProfileImpl)modifiableModel;
        if (this.mySelectedProfile != null) {
            this.myInitialProfile = this.mySelectedProfile.getName();
        }
        this.initDescriptors();
        this.filterTree(this.myProfileFilter != null ? this.myProfileFilter.getFilter() : null);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(700, -1);
    }

    public void disposeUI() {
        this.myAlarm.cancelAllRequests();
        this.myProfileFilter.dispose();
        this.mySelectedProfile = null;
    }

    private JPanel createInspectionProfileSettingsPanel() {
        this.myBrowser = new JEditorPane("text/html", EMPTY_HTML);
        this.myBrowser.setEditable(false);
        this.myBrowser.addHyperlinkListener((HyperlinkListener)new BrowserHyperlinkListener());
        this.initDescriptors();
        this.fillTreeData(this.myProfileFilter != null ? this.myProfileFilter.getFilter() : null, true);
        JPanel descriptionPanel = new JPanel(new BorderLayout());
        descriptionPanel.add((Component)SeparatorFactory.createSeparator((String)InspectionsBundle.message((String)"inspection.description.title", (Object[])new Object[0]), null), "North");
        descriptionPanel.add((Component)ScrollPaneFactory.createScrollPane((JComponent)this.myBrowser), "Center");
        Splitter rightPanel = new Splitter(true);
        rightPanel.setFirstComponent((JComponent)descriptionPanel);
        this.myOptionsPanel = new JPanel(new BorderLayout());
        this.initOptionsAndDescriptionPanel();
        rightPanel.setSecondComponent((JComponent)this.myOptionsPanel);
        rightPanel.setHonorComponentsMinimumSize(true);
        JPanel treePanel = new JPanel(new BorderLayout());
        treePanel.add((Component)this.initTreeScrollPane(), "Center");
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.setBorder(IdeBorderFactory.createEmptyBorder((int)2, (int)0, (int)2, (int)0));
        northPanel.add((Component)this.createTreeToolbarPanel().getComponent(), "Center");
        northPanel.add((Component)this.myProfileFilter, "East");
        treePanel.add((Component)northPanel, "North");
        Splitter splitter = new Splitter(false);
        splitter.setShowDividerControls(false);
        splitter.setFirstComponent((JComponent)treePanel);
        splitter.setSecondComponent((JComponent)rightPanel);
        splitter.setProportion((float)treePanel.getPreferredSize().width / (float)this.getPreferredSize().width);
        splitter.setHonorComponentsMinimumSize(true);
        this.myInspectionProfilePanel.add((Component)splitter, "Center");
        this.myInspectionProfilePanel.setBorder(IdeBorderFactory.createEmptyBorder((int)2, (int)2, (int)0, (int)2));
        return this.myInspectionProfilePanel;
    }

    public boolean isModified() {
        if (this.myModified) {
            return true;
        }
        if (this.mySelectedProfile.isChanged()) {
            return true;
        }
        if (this.myShareProfile != (this.mySelectedProfile.getProfileManager() == this.myProjectProfileManager)) {
            return true;
        }
        if (!Comparing.strEqual((String)this.myInitialProfile, (String)this.mySelectedProfile.getName())) {
            return true;
        }
        if (this.descriptorsAreChanged()) {
            return this.setSelectedProfileModified(true);
        }
        this.setSelectedProfileModified(false);
        return false;
    }

    public void reset() {
        this.myModified = false;
        this.setSelectedProfile(this.mySelectedProfile);
        String filter = this.myProfileFilter.getFilter();
        this.myProfileFilter.reset();
        this.myProfileFilter.setSelectedItem(filter);
        this.myShareProfile = this.mySelectedProfile.getProfileManager() == this.myProjectProfileManager;
    }

    public void apply() throws ConfigurationException {
        SeverityProvider profileManager;
        ModifiableModel selectedProfile = this.getSelectedProfile();
        SeverityProvider severityProvider = profileManager = this.myShareProfile ? this.myProjectProfileManager : InspectionProfileManager.getInstance();
        if (selectedProfile.getProfileManager() != profileManager) {
            if (selectedProfile.getProfileManager().getProfile(selectedProfile.getName(), false) != null) {
                selectedProfile.getProfileManager().deleteProfile(selectedProfile.getName());
            }
            SingleInspectionProfilePanel.copyUsedSeveritiesIfUndefined(selectedProfile, (ProfileManager)profileManager);
            selectedProfile.setProfileManager((ProfileManager)profileManager);
        }
        InspectionProfile parentProfile = selectedProfile.getParentProfile();
        if (InspectionProfileManager.getInstance().getSchemesManager().isShared((Scheme)selectedProfile) && this.descriptorsAreChanged()) {
            throw new ConfigurationException("Shared profile cannot be modified. Please do \"Save As...\" first.");
        }
        try {
            selectedProfile.commit();
        }
        catch (IOException e) {
            throw new ConfigurationException(e.getMessage());
        }
        this.setSelectedProfile(parentProfile.getModifiableModel());
        this.setSelectedProfileModified(false);
        this.myModified = false;
    }

    private static void copyUsedSeveritiesIfUndefined(ModifiableModel selectedProfile, ProfileManager profileManager) {
        SeverityRegistrar registrar = ((SeverityProvider)profileManager).getSeverityRegistrar();
        Set<HighlightSeverity> severities = ((InspectionProfileImpl)selectedProfile).getUsedSeverities();
        Iterator<HighlightSeverity> iterator = severities.iterator();
        while (iterator.hasNext()) {
            HighlightSeverity severity = iterator.next();
            if (!registrar.isSeverityValid(severity.toString())) continue;
            iterator.remove();
        }
        if (!severities.isEmpty()) {
            SeverityRegistrar oppositeRegister = ((SeverityProvider)selectedProfile.getProfileManager()).getSeverityRegistrar();
            for (HighlightSeverity severity : severities) {
                TextAttributesKey attributesKey = TextAttributesKey.find((String)severity.toString());
                TextAttributes textAttributes = oppositeRegister.getTextAttributesBySeverity(severity);
                LOG.assertTrue(textAttributes != null);
                HighlightInfoType.HighlightInfoTypeImpl info = new HighlightInfoType.HighlightInfoTypeImpl(severity, attributesKey);
                registrar.registerSeverity(new SeverityRegistrar.SeverityBasedTextAttributes(textAttributes.clone(), info), textAttributes.getErrorStripeColor());
            }
        }
    }

    private boolean descriptorsAreChanged() {
        for (Map.Entry<Descriptor, List<Descriptor>> entry : this.myDescriptors.entrySet()) {
            Descriptor desc = entry.getKey();
            if (this.mySelectedProfile.isToolEnabled(desc.getKey(), (NamedScope)null) != desc.isEnabled()) {
                return true;
            }
            if (this.mySelectedProfile.getErrorLevel(desc.getKey(), desc.getScope()) != desc.getLevel()) {
                return true;
            }
            List<Descriptor> descriptors = entry.getValue();
            for (Descriptor descriptor : descriptors) {
                if (this.mySelectedProfile.isToolEnabled(descriptor.getKey(), descriptor.getScope()) != descriptor.isEnabled()) {
                    return true;
                }
                if (this.mySelectedProfile.getErrorLevel(descriptor.getKey(), descriptor.getScope()) == descriptor.getLevel()) continue;
                return true;
            }
            List<ScopeToolState> tools = this.mySelectedProfile.getNonDefaultTools(desc.getKey().toString());
            if (tools.size() != descriptors.size()) {
                return true;
            }
            int toolsSize = tools.size();
            for (int i = 0; i < toolsSize; ++i) {
                ScopeToolState pair = tools.get(i);
                if (Comparing.equal((Object)pair.getScope(), (Object)descriptors.get(i).getScope())) continue;
                return true;
            }
        }
        return false;
    }

    public Tree getTree() {
        return this.myTree;
    }

    public boolean isProfileShared() {
        return this.myShareProfile;
    }

    public void setProfileShared(boolean profileShared) {
        this.myShareProfile = profileShared;
    }

    private class MyFilterComponent
    extends FilterComponent {
        public MyFilterComponent() {
            super(SingleInspectionProfilePanel.INSPECTION_FILTER_HISTORY, 10);
            this.setHistory(Arrays.asList("\"New in 9\""));
        }

        public void filter() {
            SingleInspectionProfilePanel.this.filterTree(this.getFilter());
        }

        protected void onlineFilter() {
            if (SingleInspectionProfilePanel.this.mySelectedProfile == null) {
                return;
            }
            String filter = this.getFilter();
            if (filter != null && filter.length() > 0) {
                SingleInspectionProfilePanel.this.mySelectedProfile.getExpandedNodes().saveVisibleState(SingleInspectionProfilePanel.this.myTree);
            }
            SingleInspectionProfilePanel.this.fillTreeData(filter, true);
            SingleInspectionProfilePanel.this.reloadModel();
            TreeUtil.expandAll((JTree)SingleInspectionProfilePanel.this.myTree);
            if (filter == null || filter.length() == 0) {
                TreeUtil.collapseAll((JTree)SingleInspectionProfilePanel.this.myTree, (int)0);
                SingleInspectionProfilePanel.this.restoreTreeState();
            }
        }
    }

    private class LevelSelection
    implements ActionListener {
        private final HighlightDisplayLevel myLevel;

        public LevelSelection(HighlightDisplayLevel level) {
            this.myLevel = level;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] rows = SingleInspectionProfilePanel.this.myTree.getSelectionRows();
            boolean showOptionsAndDescriptorPanels = rows != null && rows.length == 1;
            for (int i = 0; rows != null && i < rows.length; ++i) {
                InspectionConfigTreeNode node = (InspectionConfigTreeNode)((Object)SingleInspectionProfilePanel.this.myTree.getPathForRow(rows[i]).getLastPathComponent());
                InspectionConfigTreeNode parent = (InspectionConfigTreeNode)((Object)node.getParent());
                if (node.getUserObject() instanceof Descriptor) {
                    this.updateErrorLevel(node, showOptionsAndDescriptorPanels);
                    SingleInspectionProfilePanel.updateUpHierarchy(node, parent);
                    continue;
                }
                node.isProperSetting = false;
                for (int j = 0; j < node.getChildCount(); ++j) {
                    InspectionConfigTreeNode child = (InspectionConfigTreeNode)((Object)node.getChildAt(j));
                    if (child.getUserObject() instanceof Descriptor) {
                        this.updateErrorLevel(child, showOptionsAndDescriptorPanels);
                    } else {
                        child.isProperSetting = false;
                        for (int k = 0; k < child.getChildCount(); ++k) {
                            InspectionConfigTreeNode descriptorNode = (InspectionConfigTreeNode)((Object)child.getChildAt(k));
                            if (descriptorNode.getUserObject() instanceof Descriptor) {
                                this.updateErrorLevel(descriptorNode, showOptionsAndDescriptorPanels);
                            }
                            child.isProperSetting |= descriptorNode.isProperSetting;
                        }
                    }
                    node.isProperSetting |= child.isProperSetting;
                }
                SingleInspectionProfilePanel.updateUpHierarchy(node, parent);
            }
            if (rows != null && rows.length == 1) {
                SingleInspectionProfilePanel.this.updateOptionsAndDescriptionPanel(SingleInspectionProfilePanel.this.myTree.getPathForRow(rows[0]));
            } else {
                SingleInspectionProfilePanel.this.initOptionsAndDescriptionPanel();
            }
            SingleInspectionProfilePanel.this.repaintTableData();
        }

        private void updateErrorLevel(InspectionConfigTreeNode child, boolean showOptionsAndDescriptorPanels) {
            HighlightDisplayKey key = child.getDesriptor().getKey();
            SingleInspectionProfilePanel.this.mySelectedProfile.setErrorLevel(key, this.myLevel, child.isInspectionNode() || child.isByDefault() ? -1 : child.getParent().getIndex((TreeNode)((Object)child)));
            child.isProperSetting = SingleInspectionProfilePanel.this.mySelectedProfile.isProperSetting(key);
            if (showOptionsAndDescriptorPanels) {
                SingleInspectionProfilePanel.this.updateOptionsAndDescriptionPanel(new TreePath(child.getPath()));
            }
        }
    }
}

