/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;

public class CheckUtil {
    public static void checkWritable(PsiElement element) throws IncorrectOperationException {
        if (!element.isWritable()) {
            if (element instanceof PsiDirectory) {
                throw new IncorrectOperationException(PsiBundle.message((String)"cannot.modify.a.read.only.directory", (Object[])new Object[]{((PsiDirectory)element).getVirtualFile().getPresentableUrl()}));
            }
            PsiFile file = element.getContainingFile();
            if (file == null) {
                throw new IncorrectOperationException();
            }
            VirtualFile virtualFile = file.getVirtualFile();
            if (virtualFile == null) {
                throw new IncorrectOperationException();
            }
            throw new IncorrectOperationException(PsiBundle.message((String)"cannot.modify.a.read.only.file", (Object[])new Object[]{virtualFile.getPresentableUrl()}));
        }
    }

    public static void checkDelete(VirtualFile file) throws IncorrectOperationException {
        if (FileTypeManager.getInstance().isFileIgnored(file.getName())) {
            return;
        }
        if (!file.isWritable()) {
            throw new IncorrectOperationException(PsiBundle.message((String)"cannot.delete.a.read.only.file", (Object[])new Object[]{file.getPresentableUrl()}));
        }
        if (file.isDirectory()) {
            VirtualFile[] children;
            for (VirtualFile aChildren : children = file.getChildren()) {
                CheckUtil.checkDelete(aChildren);
            }
        }
    }
}

