/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReceiver;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.compiled.ClsAnnotationsUtil;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.impl.compiled.ClsDocCommentImpl;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsIdentifierImpl;
import com.intellij.psi.impl.compiled.ClsRepositoryPsiElement;
import com.intellij.psi.impl.compiled.ClsTypeElementImpl;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiMethodStub;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.presentation.java.JavaPresentationUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.ui.RowIcon;
import com.intellij.util.Icons;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ClsMethodImpl
extends ClsRepositoryPsiElement<PsiMethodStub>
implements PsiAnnotationMethod {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.compiled.ClsMethodImpl");
    private PsiIdentifier myNameIdentifier = null;
    private PsiTypeElement myReturnType = null;
    private PsiDocComment myDocComment = null;
    private PsiAnnotationMemberValue myDefaultValue = null;

    public ClsMethodImpl(PsiMethodStub stub) {
        super(stub);
    }

    @Override
    @NotNull
    public PsiElement[] getChildren() {
        PsiDocComment docComment = this.getDocComment();
        PsiModifierList modifierList = this.getModifierList();
        PsiTypeElement returnType = this.getReturnTypeElement();
        PsiIdentifier name = this.getNameIdentifier();
        PsiParameterList parameterList = this.getParameterList();
        PsiReferenceList throwsList = this.getThrowsList();
        PsiAnnotationMemberValue defaultValue = this.getDefaultValue();
        int count = (docComment != null ? 1 : 0) + (modifierList != null ? 1 : 0) + (returnType != null ? 1 : 0) + (name != null ? 1 : 0) + (parameterList != null ? 1 : 0) + (throwsList != null ? 1 : 0) + (defaultValue != null ? 1 : 0);
        PsiElement[] children = new PsiElement[count];
        int offset = 0;
        if (docComment != null) {
            children[offset++] = docComment;
        }
        if (modifierList != null) {
            children[offset++] = modifierList;
        }
        if (returnType != null) {
            children[offset++] = returnType;
        }
        if (name != null) {
            children[offset++] = name;
        }
        if (parameterList != null) {
            children[offset++] = parameterList;
        }
        if (throwsList != null) {
            children[offset++] = throwsList;
        }
        if (defaultValue != null) {
            children[offset++] = defaultValue;
        }
        if (children == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsMethodImpl.getChildren must not return null");
        }
        return children;
    }

    public PsiClass getContainingClass() {
        return (PsiClass)this.getParent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PsiIdentifier getNameIdentifier() {
        Object object = LAZY_BUILT_LOCK;
        synchronized (object) {
            if (this.myNameIdentifier == null) {
                this.myNameIdentifier = new ClsIdentifierImpl(this, this.getName());
            }
            return this.myNameIdentifier;
        }
    }

    @NotNull
    public PsiMethod[] findSuperMethods() {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethods((PsiMethod)this);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsMethodImpl.findSuperMethods must not return null");
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiMethod[] findSuperMethods(boolean checkAccess) {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethods((PsiMethod)this, checkAccess);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsMethodImpl.findSuperMethods must not return null");
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiMethod[] findSuperMethods(PsiClass parentClass) {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethods((PsiMethod)this, parentClass);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsMethodImpl.findSuperMethods must not return null");
        }
        return psiMethodArray;
    }

    @NotNull
    public List<MethodSignatureBackedByPsiMethod> findSuperMethodSignaturesIncludingStatic(boolean checkAccess) {
        List<MethodSignatureBackedByPsiMethod> list = PsiSuperMethodImplUtil.findSuperMethodSignaturesIncludingStatic((PsiMethod)this, checkAccess);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsMethodImpl.findSuperMethodSignaturesIncludingStatic must not return null");
        }
        return list;
    }

    public PsiMethod findDeepestSuperMethod() {
        return PsiSuperMethodImplUtil.findDeepestSuperMethod((PsiMethod)this);
    }

    @NotNull
    public PsiMethod[] findDeepestSuperMethods() {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findDeepestSuperMethods((PsiMethod)this);
        if (psiMethodArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsMethodImpl.findDeepestSuperMethods must not return null");
        }
        return psiMethodArray;
    }

    @NotNull
    public String getName() {
        String string = ((PsiMethodStub)this.getStub()).getName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsMethodImpl.getName must not return null");
        }
        return string;
    }

    @NotNull
    public HierarchicalMethodSignature getHierarchicalMethodSignature() {
        HierarchicalMethodSignature hierarchicalMethodSignature = PsiSuperMethodImplUtil.getHierarchicalMethodSignature((PsiMethod)this);
        if (hierarchicalMethodSignature == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsMethodImpl.getHierarchicalMethodSignature must not return null");
        }
        return hierarchicalMethodSignature;
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsMethodImpl.setName must not be null");
        }
        PsiImplUtil.setName((PsiElement)this.getNameIdentifier(), name);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PsiTypeElement getReturnTypeElement() {
        if (this.isConstructor()) {
            return null;
        }
        Object object = LAZY_BUILT_LOCK;
        synchronized (object) {
            if (this.myReturnType == null) {
                String typeText = TypeInfo.createTypeText(((PsiMethodStub)this.getStub()).getReturnTypeText(false));
                this.myReturnType = new ClsTypeElementImpl(this, typeText, '\u0000');
            }
            return this.myReturnType;
        }
    }

    public PsiType getReturnType() {
        PsiTypeElement typeElement = this.getReturnTypeElement();
        return typeElement == null ? null : typeElement.getType();
    }

    @NotNull
    public PsiModifierList getModifierList() {
        PsiModifierList psiModifierList = (PsiModifierList)((PsiMethodStub)this.getStub()).findChildStubByType(JavaStubElementTypes.MODIFIER_LIST).getPsi();
        if (psiModifierList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsMethodImpl.getModifierList must not return null");
        }
        return psiModifierList;
    }

    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsMethodImpl.hasModifierProperty must not be null");
        }
        return this.getModifierList().hasModifierProperty(name);
    }

    @NotNull
    public PsiParameterList getParameterList() {
        PsiParameterList psiParameterList = (PsiParameterList)((PsiMethodStub)this.getStub()).findChildStubByType(JavaStubElementTypes.PARAMETER_LIST).getPsi();
        if (psiParameterList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsMethodImpl.getParameterList must not return null");
        }
        return psiParameterList;
    }

    @NotNull
    public PsiReferenceList getThrowsList() {
        PsiReferenceList psiReferenceList = (PsiReferenceList)((PsiMethodStub)this.getStub()).findChildStubByType(JavaStubElementTypes.THROWS_LIST).getPsi();
        if (psiReferenceList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsMethodImpl.getThrowsList must not return null");
        }
        return psiReferenceList;
    }

    public PsiCodeBlock getBody() {
        return null;
    }

    public boolean isDeprecated() {
        return ((PsiMethodStub)this.getStub()).isDeprecated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PsiAnnotationMemberValue getDefaultValue() {
        Object object = LAZY_BUILT_LOCK;
        synchronized (object) {
            if (this.myDefaultValue == null) {
                String text = ((PsiMethodStub)this.getStub()).getDefaultValueText();
                if (StringUtil.isEmpty((String)text)) {
                    return null;
                }
                this.myDefaultValue = ClsAnnotationsUtil.createMemberValueFromText(text, this.getManager(), this);
            }
            return this.myDefaultValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PsiDocComment getDocComment() {
        if (!this.isDeprecated()) {
            return null;
        }
        Object object = LAZY_BUILT_LOCK;
        synchronized (object) {
            if (this.myDocComment == null) {
                this.myDocComment = new ClsDocCommentImpl((PsiDocCommentOwner)this);
            }
            return this.myDocComment;
        }
    }

    public boolean isConstructor() {
        return ((PsiMethodStub)this.getStub()).isConstructor();
    }

    public boolean isVarArgs() {
        return ((PsiMethodStub)this.getStub()).isVarArgs();
    }

    @NotNull
    public MethodSignature getSignature(@NotNull PsiSubstitutor substitutor) {
        if (substitutor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsMethodImpl.getSignature must not be null");
        }
        MethodSignatureBackedByPsiMethod methodSignatureBackedByPsiMethod = MethodSignatureBackedByPsiMethod.create((PsiMethod)this, (PsiSubstitutor)substitutor);
        if (methodSignatureBackedByPsiMethod == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsMethodImpl.getSignature must not return null");
        }
        return methodSignatureBackedByPsiMethod;
    }

    @Override
    public void appendMirrorText(int indentLevel, StringBuffer buffer) {
        this.appendMethodHeader(buffer, indentLevel);
        if (this.hasModifierProperty("abstract") || this.hasModifierProperty("native")) {
            buffer.append(";");
        } else {
            buffer.append(" { /* ");
            buffer.append(PsiBundle.message((String)"psi.decompiled.method.body", (Object[])new Object[0]));
            buffer.append(" */ }");
        }
    }

    private void appendMethodHeader(@NonNls StringBuffer buffer, int indentLevel) {
        PsiAnnotationMemberValue defaultValue;
        ClsDocCommentImpl docComment = (ClsDocCommentImpl)this.getDocComment();
        if (docComment != null) {
            docComment.appendMirrorText(indentLevel, buffer);
            ClsMethodImpl.goNextLine(indentLevel, buffer);
        }
        ((ClsElementImpl)this.getModifierList()).appendMirrorText(indentLevel, buffer);
        ((ClsElementImpl)this.getTypeParameterList()).appendMirrorText(indentLevel, buffer);
        if (!this.isConstructor()) {
            ((ClsElementImpl)this.getReturnTypeElement()).appendMirrorText(indentLevel, buffer);
            buffer.append(' ');
        }
        ((ClsElementImpl)this.getNameIdentifier()).appendMirrorText(indentLevel, buffer);
        ((ClsElementImpl)this.getParameterList()).appendMirrorText(indentLevel, buffer);
        PsiReferenceList throwsList = this.getThrowsList();
        if (throwsList.getReferencedTypes().length > 0) {
            buffer.append(' ');
            ((ClsElementImpl)throwsList).appendMirrorText(indentLevel, buffer);
        }
        if ((defaultValue = this.getDefaultValue()) != null) {
            buffer.append(" default ");
            ((ClsElementImpl)defaultValue).appendMirrorText(indentLevel, buffer);
        }
    }

    @Override
    public void setMirror(@NotNull TreeElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsMethodImpl.setMirror must not be null");
        }
        this.setMirrorCheckingType(element, null);
        PsiMethod mirror = (PsiMethod)SourceTreeToPsiMap.treeElementToPsi(element);
        if (this.getDocComment() != null) {
            ((ClsElementImpl)this.getDocComment()).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree((PsiElement)mirror.getDocComment()));
        }
        ((ClsElementImpl)this.getModifierList()).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree((PsiElement)mirror.getModifierList()));
        if (!this.isConstructor() && mirror.getReturnTypeElement() != null) {
            ((ClsElementImpl)this.getReturnTypeElement()).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree((PsiElement)mirror.getReturnTypeElement()));
        }
        ((ClsElementImpl)this.getNameIdentifier()).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree((PsiElement)mirror.getNameIdentifier()));
        ((ClsElementImpl)this.getParameterList()).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree((PsiElement)mirror.getParameterList()));
        ((ClsElementImpl)this.getThrowsList()).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree((PsiElement)mirror.getThrowsList()));
        ((ClsElementImpl)this.getTypeParameterList()).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree((PsiElement)mirror.getTypeParameterList()));
        if (this.getDefaultValue() != null) {
            LOG.assertTrue(mirror instanceof PsiAnnotationMethod);
            ((ClsElementImpl)this.getDefaultValue()).setMirror((TreeElement)SourceTreeToPsiMap.psiElementToTree((PsiElement)((PsiAnnotationMethod)mirror).getDefaultValue()));
        }
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsMethodImpl.accept must not be null");
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitMethod((PsiMethod)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiMethod:" + this.getName();
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        PsiParameter[] parameters;
        if (processor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsMethodImpl.processDeclarations must not be null");
        }
        if (state == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsMethodImpl.processDeclarations must not be null");
        }
        if (place == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/psi/impl/compiled/ClsMethodImpl.processDeclarations must not be null");
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this);
        if (lastParent == null) {
            return true;
        }
        if (!PsiScopesUtil.walkChildrenScopes(this, processor, state, lastParent, place)) {
            return false;
        }
        for (PsiParameter parameter : parameters = this.getParameterList().getParameters()) {
            if (processor.execute((PsiElement)parameter, state)) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        PsiMethod[] methodsByName;
        ClsMethodImpl clsMethodImpl;
        PsiClass sourceClassMirror = ((ClsClassImpl)this.getParent()).getSourceMirrorClass();
        if (sourceClassMirror == null) {
            clsMethodImpl = this;
            if (clsMethodImpl == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsMethodImpl.getNavigationElement must not return null");
            return clsMethodImpl;
        }
        for (PsiMethod sourceMethod : methodsByName = sourceClassMirror.findMethodsByName(this.getName(), false)) {
            if (!MethodSignatureUtil.areParametersErasureEqual((PsiMethod)this, (PsiMethod)sourceMethod)) continue;
            clsMethodImpl = sourceMethod;
            if (clsMethodImpl == null) throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsMethodImpl.getNavigationElement must not return null");
            return clsMethodImpl;
        }
        clsMethodImpl = this;
        if (clsMethodImpl != null) return clsMethodImpl;
        throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsMethodImpl.getNavigationElement must not return null");
    }

    public PsiTypeParameterList getTypeParameterList() {
        return (PsiTypeParameterList)((PsiMethodStub)this.getStub()).findChildStubByType(JavaStubElementTypes.TYPE_PARAMETER_LIST).getPsi();
    }

    public boolean hasTypeParameters() {
        return PsiImplUtil.hasTypeParameters((PsiTypeParameterListOwner)this);
    }

    @NotNull
    public PsiTypeParameter[] getTypeParameters() {
        PsiTypeParameter[] psiTypeParameterArray = PsiImplUtil.getTypeParameters((PsiTypeParameterListOwner)this);
        if (psiTypeParameterArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsMethodImpl.getTypeParameters must not return null");
        }
        return psiTypeParameterArray;
    }

    @Override
    public ItemPresentation getPresentation() {
        return JavaPresentationUtil.getMethodPresentation((PsiMethod)this);
    }

    public Icon getElementIcon(int flags) {
        Icon methodIcon = this.hasModifierProperty("abstract") ? Icons.ABSTRACT_METHOD_ICON : Icons.METHOD_ICON;
        RowIcon baseIcon = ClsMethodImpl.createLayeredIcon((Icon)methodIcon, (int)ElementPresentationUtil.getFlags((PsiModifierListOwner)this, false));
        return ElementPresentationUtil.addVisibilityIcon((PsiModifierListOwner)this, flags, baseIcon);
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isMethodEquivalentTo((PsiMethod)this, another);
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        SearchScope searchScope = PsiImplUtil.getMemberUseScope((PsiMember)this);
        if (searchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/compiled/ClsMethodImpl.getUseScope must not return null");
        }
        return searchScope;
    }

    public PsiMethodReceiver getMethodReceiver() {
        return null;
    }

    public PsiType getReturnTypeNoResolve() {
        return this.getReturnType();
    }
}

