/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.PsiReferenceProviderBase;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class PathListReferenceProvider
extends PsiReferenceProviderBase {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/PathListReferenceProvider.getReferencesByElement must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/PathListReferenceProvider.getReferencesByElement must not be null");
        }
        PsiReference[] psiReferenceArray = this.getReferencesByElement(element);
        if (psiReferenceArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/impl/source/resolve/reference/impl/providers/PathListReferenceProvider.getReferencesByElement must not return null");
        }
        return psiReferenceArray;
    }

    public PsiReference[] getReferencesByElement(@NotNull PsiElement element) {
        Object[] refs;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/impl/source/resolve/reference/impl/providers/PathListReferenceProvider.getReferencesByElement must not be null");
        }
        Object[] result = PsiReference.EMPTY_ARRAY;
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)element);
        assert (manipulator != null);
        TextRange range = manipulator.getRangeInElement(element);
        String s = range.substring(element.getText());
        int offset = range.getStartOffset();
        if (!s.trim().startsWith("/")) {
            return result;
        }
        int pos = -1;
        while (true) {
            int nextPos;
            if ((nextPos = s.indexOf(44, pos + 1)) == -1) break;
            refs = this.createReferences(element, s.substring(pos + 1, nextPos), pos + offset + 1, false);
            result = (PsiReference[])ArrayUtil.mergeArrays((Object[])result, (Object[])refs, PsiReference.class);
            pos = nextPos;
        }
        refs = this.createReferences(element, s.substring(pos + 1), pos + offset + 1, false);
        result = (PsiReference[])ArrayUtil.mergeArrays((Object[])result, (Object[])refs, PsiReference.class);
        return result;
    }

    protected PsiReference[] createReferences(PsiElement element, String s, int offset, final boolean soft) {
        int contentOffset = StringUtil.findFirst((String)s, (CharFilter)CharFilter.NOT_WHITESPACE_FILTER);
        if (contentOffset >= 0) {
            offset += contentOffset;
        }
        return new FileReferenceSet(s.trim(), element, offset, this, true){

            @Override
            protected boolean isSoft() {
                return soft;
            }
        }.getAllReferences();
    }
}

