/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.migration;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMigration;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;

public class MigrationUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.migration.MigrationUtil");

    private MigrationUtil() {
    }

    public static UsageInfo[] findPackageUsages(PsiManager manager, PsiMigration migration, String qName) {
        PsiPackage aPackage = MigrationUtil.findOrCreatePackage(manager, migration, qName);
        return MigrationUtil.findRefs(manager, (PsiElement)aPackage);
    }

    public static void doPackageMigration(PsiManager manager, PsiMigration migration, String newQName, UsageInfo[] usages) {
        try {
            PsiPackage aPackage = MigrationUtil.findOrCreatePackage(manager, migration, newQName);
            for (UsageInfo usage : usages) {
                PsiElement element = usage.getElement();
                if (element == null || !element.isValid()) continue;
                if (element instanceof PsiJavaCodeReferenceElement) {
                    ((PsiJavaCodeReferenceElement)element).bindToElement((PsiElement)aPackage);
                    continue;
                }
                MigrationUtil.bindNonJavaReference((PsiElement)aPackage, element, usage);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private static void bindNonJavaReference(PsiElement bindTo, PsiElement element, UsageInfo usage) {
        TextRange range = usage.getRange();
        for (PsiReference reference : element.getReferences()) {
            JavaClassReference classReference;
            if (!(reference instanceof JavaClassReference) || !(classReference = (JavaClassReference)reference).getRangeInElement().equals((Object)range)) continue;
            classReference.bindToElement(bindTo);
            break;
        }
    }

    public static UsageInfo[] findClassUsages(PsiManager manager, PsiMigration migration, String qName) {
        PsiClass aClass = MigrationUtil.findOrCreateClass(manager, migration, qName);
        return MigrationUtil.findRefs(manager, (PsiElement)aClass);
    }

    private static UsageInfo[] findRefs(PsiManager manager, PsiElement aClass) {
        ArrayList<UsageInfo> results = new ArrayList<UsageInfo>();
        GlobalSearchScope projectScope = GlobalSearchScope.projectScope((Project)manager.getProject());
        for (PsiReference usage : ReferencesSearch.search((PsiElement)aClass, (SearchScope)projectScope, (boolean)false)) {
            results.add(new UsageInfo(usage));
        }
        return results.toArray(new UsageInfo[results.size()]);
    }

    public static void doClassMigration(PsiManager manager, PsiMigration migration, String newQName, UsageInfo[] usages) {
        try {
            PsiClass aClass = MigrationUtil.findOrCreateClass(manager, migration, newQName);
            for (UsageInfo usage : usages) {
                PsiElement element = usage.getElement();
                if (element == null || !element.isValid()) continue;
                if (element instanceof PsiJavaCodeReferenceElement) {
                    PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)element;
                    referenceElement.bindToElement((PsiElement)aClass);
                    continue;
                }
                MigrationUtil.bindNonJavaReference((PsiElement)aClass, element, usage);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    static PsiPackage findOrCreatePackage(PsiManager manager, final PsiMigration migration, final String qName) {
        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)manager.getProject()).findPackage(qName);
        if (aPackage != null) {
            return aPackage;
        }
        return (PsiPackage)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<PsiPackage>(){

            public PsiPackage compute() {
                return migration.createPackage(qName);
            }
        });
    }

    static PsiClass findOrCreateClass(PsiManager manager, final PsiMigration migration, final String qName) {
        PsiClass aClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(qName, GlobalSearchScope.allScope((Project)manager.getProject()));
        if (aClass == null) {
            aClass = (PsiClass)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<PsiClass>(){

                public PsiClass compute() {
                    return migration.createClass(qName);
                }
            });
        }
        return aClass;
    }
}

