/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.inplace;

import com.intellij.lang.LanguageRefactoringSupport;
import com.intellij.lang.refactoring.RefactoringSupportProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.refactoring.rename.RenameHandlerRegistry;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import org.jetbrains.annotations.NotNull;

public final class VariableInplaceRenameHandler
implements RenameHandler {
    private static final ThreadLocal<Boolean> ourPreventInlineRenameFlag = new ThreadLocal();
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.rename.inplace.VariableInplaceRenameHandler");

    public boolean isAvailableOnDataContext(DataContext dataContext) {
        PsiElement element = PsiElementRenameHandler.getElement(dataContext);
        Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
        PsiFile file = (PsiFile)LangDataKeys.PSI_FILE.getData(dataContext);
        if (editor == null || file == null) {
            return false;
        }
        if (ourPreventInlineRenameFlag.get() != null) {
            return false;
        }
        PsiElement nameSuggestionContext = file.findElementAt(editor.getCaretModel().getOffset());
        RefactoringSupportProvider supportProvider = element != null ? (RefactoringSupportProvider)LanguageRefactoringSupport.INSTANCE.forLanguage(element.getLanguage()) : null;
        return supportProvider != null && editor.getSettings().isVariableInplaceRenameEnabled() && supportProvider.doInplaceRenameFor(element, nameSuggestionContext);
    }

    public boolean isRenaming(DataContext dataContext) {
        return this.isAvailableOnDataContext(dataContext);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/rename/inplace/VariableInplaceRenameHandler.invoke must not be null");
        }
        PsiElement element = PsiElementRenameHandler.getElement(dataContext);
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        this.doRename(element, editor, dataContext);
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        PsiElement element;
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/refactoring/rename/inplace/VariableInplaceRenameHandler.invoke must not be null");
        }
        if (elements == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/refactoring/rename/inplace/VariableInplaceRenameHandler.invoke must not be null");
        }
        PsiElement psiElement = element = elements.length == 1 ? elements[0] : null;
        if (element == null) {
            element = PsiElementRenameHandler.getElement(dataContext);
        }
        LOG.assertTrue(element != null);
        Editor editor = (Editor)PlatformDataKeys.EDITOR.getData(dataContext);
        this.doRename(element, editor, dataContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRename(PsiElement elementToRename, Editor editor, DataContext dataContext) {
        if (!this.isAvailableOnDataContext(dataContext)) {
            LOG.error("Recursive invocation");
            RenameHandlerRegistry.getInstance().getRenameHandler(dataContext).invoke(elementToRename.getProject(), editor, elementToRename.getContainingFile(), dataContext);
            return;
        }
        boolean startedRename = new VariableInplaceRenamer((PsiNameIdentifierOwner)elementToRename, editor).performInplaceRename();
        if (!startedRename) {
            try {
                ourPreventInlineRenameFlag.set(Boolean.TRUE);
                RenameHandlerRegistry.getInstance().getRenameHandler(dataContext).invoke(elementToRename.getProject(), editor, elementToRename.getContainingFile(), dataContext);
            }
            finally {
                ourPreventInlineRenameFlag.set(null);
            }
        }
    }
}

