/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.turnRefsToSuper;

import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.turnRefsToSuper.TurnRefsToSuperHandler;
import com.intellij.refactoring.turnRefsToSuper.TurnRefsToSuperProcessor;
import com.intellij.refactoring.ui.ClassCellRenderer;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.RefactoringHierarchyUtil;
import com.intellij.ui.IdeBorderFactory;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NotNull;

public class TurnRefsToSuperDialog
extends RefactoringDialog {
    @NotNull
    private final PsiClass mySubClass;
    private final List mySuperClasses;
    private JList mySuperClassesList;
    private final JCheckBox myCbReplaceInstanceOf;

    TurnRefsToSuperDialog(Project project, @NotNull PsiClass subClass, List superClasses) {
        if (subClass == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/refactoring/turnRefsToSuper/TurnRefsToSuperDialog.<init> must not be null");
        }
        super(project, true);
        this.mySuperClassesList = null;
        this.myCbReplaceInstanceOf = new JCheckBox();
        this.mySubClass = subClass;
        this.mySuperClasses = superClasses;
        this.setTitle(TurnRefsToSuperHandler.REFACTORING_NAME);
        this.init();
    }

    public PsiClass getSuperClass() {
        if (this.mySuperClassesList != null) {
            return (PsiClass)this.mySuperClassesList.getSelectedValue();
        }
        return null;
    }

    public boolean isUseInInstanceOf() {
        return this.myCbReplaceInstanceOf.isSelected();
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("refactoring.useInterface");
    }

    public JComponent getPreferredFocusedComponent() {
        return this.mySuperClassesList;
    }

    protected JComponent createNorthPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(IdeBorderFactory.createBorder());
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.insets = new Insets(4, 8, 4, 8);
        gbConstraints.weighty = 1.0;
        gbConstraints.weightx = 1.0;
        gbConstraints.gridy = 0;
        gbConstraints.gridwidth = 0;
        gbConstraints.fill = 1;
        gbConstraints.anchor = 17;
        JLabel classListLabel = new JLabel();
        panel.add((Component)classListLabel, gbConstraints);
        this.mySuperClassesList = new JList<Object>(this.mySuperClasses.toArray());
        this.mySuperClassesList.setCellRenderer(new ClassCellRenderer());
        this.mySuperClassesList.getSelectionModel().setSelectionMode(0);
        classListLabel.setText(RefactoringBundle.message((String)"turnRefsToSuper.change.usages.to", (Object[])new Object[]{this.mySubClass.getQualifiedName()}));
        PsiClass nearestBase = RefactoringHierarchyUtil.getNearestBaseClass(this.mySubClass, true);
        int indexToSelect = 0;
        if (nearestBase != null) {
            indexToSelect = this.mySuperClasses.indexOf(nearestBase);
        }
        this.mySuperClassesList.setSelectedIndex(indexToSelect);
        ++gbConstraints.gridy;
        panel.add((Component)new JScrollPane(this.mySuperClassesList), gbConstraints);
        ++gbConstraints.gridy;
        this.myCbReplaceInstanceOf.setText(RefactoringBundle.message((String)"turnRefsToSuper.use.superclass.in.instanceof"));
        this.myCbReplaceInstanceOf.setSelected(false);
        this.myCbReplaceInstanceOf.setFocusable(false);
        panel.add((Component)this.myCbReplaceInstanceOf, gbConstraints);
        return panel;
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.refactoring.turnRefsToSuper.TurnRefsToSuperDialog";
    }

    @Override
    protected void doAction() {
        JavaRefactoringSettings.getInstance().TURN_REFS_TO_SUPER_PREVIEW_USAGES = this.isPreviewUsages();
        TurnRefsToSuperProcessor processor = new TurnRefsToSuperProcessor(this.getProject(), this.mySubClass, this.getSuperClass(), this.isUseInInstanceOf());
        this.invokeRefactoring(processor);
    }

    protected JComponent createCenterPanel() {
        return null;
    }
}

