/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.IdeaTestFixture;
import junit.framework.Assert;

public class BaseFixture
extends UsefulTestCase
implements IdeaTestFixture {
    private boolean myDisposed;
    private boolean myInitialized;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        Assert.assertFalse((String)"setUp() already has been called", (boolean)this.myInitialized);
        Assert.assertFalse((String)"tearDown() already has been called", (boolean)this.myDisposed);
        this.myInitialized = true;
    }

    @Override
    public void tearDown() throws Exception {
        Assert.assertTrue((String)"setUp() has not been called", (boolean)this.myInitialized);
        Assert.assertFalse((String)"tearDown() already has been called", (boolean)this.myDisposed);
        this.myDisposed = true;
        super.tearDown();
        this.resetClassFields(this.getClass());
    }

    private void resetClassFields(Class<?> aClass) {
        try {
            UsefulTestCase.clearDeclaredFields(this, aClass);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        if (aClass == BaseFixture.class) {
            return;
        }
        this.resetClassFields(aClass.getSuperclass());
    }
}

