/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.concurrency.Job;
import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.ui.DeferredIcon;
import com.intellij.ui.IconDeferrerImpl;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.RowIcon;
import com.intellij.util.Alarm;
import com.intellij.util.Function;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.lang.ref.WeakReference;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;

public class DeferredIconImpl<T>
implements DeferredIcon {
    private static final RepaintScheduler ourRepaintScheduler = new RepaintScheduler();
    private volatile Icon myDelegateIcon;
    private final Function<T, Icon> myEvaluator;
    private volatile boolean myIsScheduled = false;
    private final T myParam;
    private WeakReference<Component> myLastTarget = null;
    private static final EmptyIcon EMPTY_ICON = new EmptyIcon(16, 16);
    private boolean myNeedReadAction;

    public DeferredIconImpl(Icon baseIcon, T param, Function<T, Icon> evaluator) {
        this(baseIcon, param, true, evaluator);
    }

    public DeferredIconImpl(Icon baseIcon, T param, boolean needReadAction, Function<T, Icon> evaluator) {
        this.myParam = param;
        this.myDelegateIcon = DeferredIconImpl.nonNull(baseIcon);
        this.myEvaluator = evaluator;
        this.myNeedReadAction = needReadAction;
    }

    private static Icon nonNull(Icon icon) {
        return icon != null ? icon : EMPTY_ICON;
    }

    public void paintIcon(final Component c, Graphics g, final int x, final int y) {
        this.myDelegateIcon.paintIcon(c, g, x, y);
        if (!this.myIsScheduled) {
            Container table;
            Container tree;
            this.myIsScheduled = true;
            Container list = SwingUtilities.getAncestorOfClass(JList.class, c);
            final Component target = list != null ? list : ((tree = SwingUtilities.getAncestorOfClass(JTree.class, c)) != null ? tree : ((table = SwingUtilities.getAncestorOfClass(JTable.class, c)) != null ? table : c));
            this.myLastTarget = new WeakReference<Container>((Container)target);
            Job job = JobScheduler.getInstance().createJob("Evaluating deferred icon", 100);
            job.addTask(new Runnable(){

                @Override
                public void run() {
                    int oldWidth = DeferredIconImpl.this.myDelegateIcon.getIconWidth();
                    DeferredIconImpl.this.myDelegateIcon = DeferredIconImpl.this.evaluate();
                    final boolean shouldRevalidate = DeferredIconImpl.this.myDelegateIcon.getIconWidth() != oldWidth;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TreeUI ui;
                            if (shouldRevalidate && target instanceof JTree && (ui = ((JTree)target).getUI()) instanceof BasicTreeUI) {
                                ((BasicTreeUI)ui).setLeftChildIndent((Integer)UIManager.get("Tree.leftChildIndent"));
                            }
                            if (c == target) {
                                c.repaint(x, y, DeferredIconImpl.this.getIconWidth(), DeferredIconImpl.this.getIconHeight());
                            } else {
                                ourRepaintScheduler.pushDirtyComponent(target);
                            }
                        }
                    });
                }
            });
            job.schedule();
        }
    }

    public Icon evaluate() {
        final Icon[] evaluated = new Icon[1];
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    evaluated[0] = DeferredIconImpl.nonNull((Icon)DeferredIconImpl.this.myEvaluator.fun(DeferredIconImpl.this.myParam));
                }
                catch (ProcessCanceledException e) {
                    evaluated[0] = EMPTY_ICON;
                }
                catch (IndexNotReadyException e) {
                    evaluated[0] = EMPTY_ICON;
                }
            }
        };
        if (this.myNeedReadAction) {
            IconDeferrerImpl.evaluateDeferredInReadAction(runnable);
        } else {
            IconDeferrerImpl.evaluateDeferred(runnable);
        }
        this.checkDoesntReferenceThis(evaluated[0]);
        return evaluated[0];
    }

    private void checkDoesntReferenceThis(Icon icon) {
        block4: {
            block5: {
                block3: {
                    if (icon == this) {
                        throw new IllegalStateException("Loop in icons delegation");
                    }
                    if (!(icon instanceof DeferredIconImpl)) break block3;
                    this.checkDoesntReferenceThis(((DeferredIconImpl)((Object)icon)).myDelegateIcon);
                    break block4;
                }
                if (!(icon instanceof LayeredIcon)) break block5;
                for (Icon layer : ((LayeredIcon)icon).getAllLayers()) {
                    this.checkDoesntReferenceThis(layer);
                }
                break block4;
            }
            if (!(icon instanceof RowIcon)) break block4;
            RowIcon rowIcon = (RowIcon)icon;
            int count = rowIcon.getIconCount();
            for (int i = 0; i < count; ++i) {
                this.checkDoesntReferenceThis(rowIcon.getIcon(i));
            }
        }
    }

    public int getIconWidth() {
        return this.myDelegateIcon.getIconWidth();
    }

    public int getIconHeight() {
        return this.myDelegateIcon.getIconHeight();
    }

    public void invalidate() {
        Component lastTarget;
        this.myIsScheduled = false;
        Component component = lastTarget = this.myLastTarget != null ? (Component)this.myLastTarget.get() : null;
        if (lastTarget != null) {
            lastTarget.repaint();
        }
    }

    private static class RepaintScheduler {
        private final Alarm myAlarm = new Alarm();
        private final Set<Component> myQueue = new LinkedHashSet<Component>();

        private RepaintScheduler() {
        }

        public void pushDirtyComponent(Component c) {
            this.myAlarm.cancelAllRequests();
            this.myAlarm.addRequest(new Runnable(){

                @Override
                public void run() {
                    for (Component component : RepaintScheduler.this.myQueue) {
                        component.repaint();
                    }
                    RepaintScheduler.this.myQueue.clear();
                }
            }, 50);
            this.myQueue.add(c);
        }
    }
}

