/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup.list;

import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.statistics.StatisticsInfo;
import com.intellij.psi.statistics.StatisticsManager;
import com.intellij.ui.ListScrollingUtil;
import com.intellij.ui.popup.ClosableByLeftArrow;
import com.intellij.ui.popup.PopupIcons;
import com.intellij.ui.popup.WizardPopup;
import com.intellij.ui.popup.list.ListPopupModel;
import com.intellij.ui.popup.list.PopupListElementRenderer;
import com.intellij.util.ui.UIUtil;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionListener;

public class ListPopupImpl
extends WizardPopup
implements ListPopup {
    private MyList myList;
    private MyMouseMotionListener myMouseMotionListener;
    private MyMouseListener myMouseListener;
    private ListPopupModel myListModel;
    private int myIndexForShowingChild = -1;
    private int myMaxRowCount = 20;
    private boolean myAutoHandleBeforeShow;

    public ListPopupImpl(ListPopupStep aStep, int maxRowCount) {
        super((PopupStep<Object>)aStep);
        if (maxRowCount != -1) {
            this.myMaxRowCount = maxRowCount;
        }
    }

    public ListPopupImpl(ListPopupStep aStep) {
        super((PopupStep<Object>)aStep);
    }

    public ListPopupImpl(WizardPopup aParent, ListPopupStep aStep, Object parentValue) {
        super(aParent, (PopupStep<Object>)aStep);
        this.setParentValue(parentValue);
    }

    public ListPopupImpl(WizardPopup aParent, ListPopupStep aStep, Object parentValue, int maxRowCount) {
        super(aParent, (PopupStep<Object>)aStep);
        this.setParentValue(parentValue);
        if (maxRowCount != -1) {
            this.myMaxRowCount = maxRowCount;
        }
    }

    protected ListPopupModel getListModel() {
        return this.myListModel;
    }

    @Override
    protected boolean beforeShow() {
        this.myList.addMouseMotionListener(this.myMouseMotionListener);
        this.myList.addMouseListener(this.myMouseListener);
        this.myList.setVisibleRowCount(Math.min(this.myMaxRowCount, this.myListModel.getSize()));
        boolean shouldShow = super.beforeShow();
        if (this.myAutoHandleBeforeShow) {
            boolean toDispose = this.tryToAutoSelect(true);
            shouldShow &= !toDispose;
        }
        return shouldShow;
    }

    @Override
    protected void afterShow() {
        this.tryToAutoSelect(false);
    }

    private boolean tryToAutoSelect(boolean handleFinalChoices) {
        int defaultIndex = this.getListStep().getDefaultOptionIndex();
        if (defaultIndex >= 0 && defaultIndex < this.myList.getModel().getSize()) {
            ListScrollingUtil.selectItem((JList)this.myList, (int)defaultIndex);
        } else {
            this.selectFirstSelectableItem();
        }
        if (this.getListStep().isAutoSelectionEnabled()) {
            if (!this.isVisible() && this.getSelectableCount() == 1) {
                return this._handleSelect(handleFinalChoices, null);
            }
            if (this.isVisible() && this.hasSingleSelectableItemWithSubmenu()) {
                return this._handleSelect(handleFinalChoices, null);
            }
        }
        return false;
    }

    private boolean autoSelectUsingStatistics() {
        String filter = this.getSpeedSearch().getFilter();
        if (!StringUtil.isEmpty((String)filter)) {
            int maxUseCount = -1;
            int mostUsedValue = -1;
            int elementsCount = this.myListModel.getSize();
            for (int i = 0; i < elementsCount; ++i) {
                Object value = this.myListModel.getElementAt(i);
                String text = this.getListStep().getTextFor(value);
                int count = StatisticsManager.getInstance().getUseCount(new StatisticsInfo("#list_popup:" + this.myStep.getTitle() + "#" + filter, text));
                if (count <= maxUseCount) continue;
                maxUseCount = count;
                mostUsedValue = i;
            }
            if (mostUsedValue > 0) {
                ListScrollingUtil.selectItem((JList)this.myList, (int)mostUsedValue);
                return true;
            }
        }
        return false;
    }

    private void selectFirstSelectableItem() {
        for (int i = 0; i < this.myListModel.getSize(); ++i) {
            if (!this.getListStep().isSelectable(this.myListModel.getElementAt(i))) continue;
            this.myList.setSelectedIndex(i);
            break;
        }
    }

    private boolean hasSingleSelectableItemWithSubmenu() {
        boolean oneSubmenuFound = false;
        int countSelectables = 0;
        for (int i = 0; i < this.myListModel.getSize(); ++i) {
            Object elementAt = this.myListModel.getElementAt(i);
            if (!this.getListStep().isSelectable(elementAt)) continue;
            ++countSelectables;
            if (!this.getStep().hasSubstep(elementAt)) continue;
            if (oneSubmenuFound) {
                return false;
            }
            oneSubmenuFound = true;
        }
        return oneSubmenuFound && countSelectables == 1;
    }

    private int getSelectableCount() {
        int count = 0;
        for (int i = 0; i < this.myListModel.getSize(); ++i) {
            Object each = this.myListModel.getElementAt(i);
            if (!this.getListStep().isSelectable(each)) continue;
            ++count;
        }
        return count;
    }

    @Override
    protected JComponent createContent() {
        this.myMouseMotionListener = new MyMouseMotionListener();
        this.myMouseListener = new MyMouseListener();
        this.myListModel = new ListPopupModel(this, this.getSpeedSearch(), this.getListStep());
        this.myList = new MyList();
        if (this.myStep.getTitle() != null) {
            this.myList.getAccessibleContext().setAccessibleName(this.myStep.getTitle());
        }
        this.myList.setSelectionMode(0);
        this.myList.setSelectedIndex(0);
        this.myList.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ListScrollingUtil.installActions((JList)this.myList);
        this.myList.setCellRenderer(this.getListElementRenderer());
        this.myList.getActionMap().get("selectNextColumn").setEnabled(false);
        this.myList.getActionMap().get("selectPreviousColumn").setEnabled(false);
        this.registerAction("handleSelection1", 10, 0, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListPopupImpl.this.handleSelect(true);
            }
        });
        this.registerAction("handleSelection2", 39, 0, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListPopupImpl.this.handleSelect(false);
            }
        });
        this.registerAction("goBack2", 37, 0, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ListPopupImpl.this.isClosableByLeftArrow()) {
                    ListPopupImpl.this.goBack();
                }
            }
        });
        this.myList.setCursor(Cursor.getPredefinedCursor(12));
        return this.myList;
    }

    private boolean isClosableByLeftArrow() {
        return this.getParent() != null || this.myStep instanceof ClosableByLeftArrow;
    }

    @Override
    protected ActionMap getActionMap() {
        return this.myList.getActionMap();
    }

    @Override
    protected InputMap getInputMap() {
        return this.myList.getInputMap();
    }

    protected ListCellRenderer getListElementRenderer() {
        return new PopupListElementRenderer(this);
    }

    public ListPopupStep<Object> getListStep() {
        return (ListPopupStep)this.myStep;
    }

    @Override
    public void dispose() {
        this.myList.removeMouseMotionListener(this.myMouseMotionListener);
        this.myList.removeMouseListener(this.myMouseListener);
        super.dispose();
    }

    protected int getSelectedIndex() {
        return this.myList.getSelectedIndex();
    }

    @Override
    public void disposeChildren() {
        this.setIndexForShowingChild(-1);
        super.disposeChildren();
    }

    @Override
    protected void onAutoSelectionTimer() {
        if (this.myList.getModel().getSize() > 0 && !this.myList.isSelectionEmpty()) {
            this.handleSelect(false);
        } else {
            this.disposeChildren();
            this.setIndexForShowingChild(-1);
        }
    }

    public void handleSelect(boolean handleFinalChoices) {
        this._handleSelect(handleFinalChoices, null);
    }

    public void handleSelect(boolean handleFinalChoices, InputEvent e) {
        this._handleSelect(handleFinalChoices, e);
    }

    private boolean _handleSelect(boolean handleFinalChoices, InputEvent e) {
        if (this.myList.getSelectedIndex() == -1) {
            return false;
        }
        if (this.getSpeedSearch().isHoldingFilter() && this.myList.getModel().getSize() == 0) {
            return false;
        }
        if (this.myList.getSelectedIndex() == this.getIndexForShowingChild()) {
            return false;
        }
        Object selectedValue = this.myList.getSelectedValue();
        if (!this.getListStep().isSelectable(selectedValue)) {
            return false;
        }
        if (!this.getListStep().hasSubstep(selectedValue) && !handleFinalChoices) {
            return false;
        }
        this.disposeChildren();
        if (this.myListModel.getSize() == 0) {
            this.setFinalRunnable(this.myStep.getFinalRunnable());
            this.disposeAllParents(e);
            this.setIndexForShowingChild(-1);
            return true;
        }
        this.valueSelected(selectedValue);
        return this.handleNextStep(this.myStep.onChosen(selectedValue, handleFinalChoices), selectedValue, e);
    }

    private void valueSelected(Object value) {
        String filter = this.getSpeedSearch().getFilter();
        if (!StringUtil.isEmpty((String)filter)) {
            String text = this.getListStep().getTextFor(value);
            StatisticsManager.getInstance().incUseCount(new StatisticsInfo("#list_popup:" + this.getListStep().getTitle() + "#" + filter, text));
        }
    }

    private boolean handleNextStep(PopupStep nextStep, Object parentValue, InputEvent e) {
        if (nextStep != PopupStep.FINAL_CHOICE) {
            Point point = this.myList.indexToLocation(this.myList.getSelectedIndex());
            SwingUtilities.convertPointToScreen(point, this.myList);
            this.myChild = ListPopupImpl.createPopup(this, nextStep, parentValue);
            if (this.myChild instanceof ListPopupImpl) {
                for (ListSelectionListener listener : this.myList.getListSelectionListeners()) {
                    ((ListPopupImpl)this.myChild).addListSelectionListener(listener);
                }
            }
            JComponent container = this.getContent();
            assert (container != null) : "container == null";
            this.myChild.show(container, point.x + container.getWidth() - 2, point.y, true);
            this.setIndexForShowingChild(this.myList.getSelectedIndex());
            return false;
        }
        this.setFinalRunnable(this.myStep.getFinalRunnable());
        this.disposeAllParents(e);
        this.setIndexForShowingChild(-1);
        return true;
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.myList.addListSelectionListener(listSelectionListener);
    }

    protected boolean isActionClick(MouseEvent e) {
        return UIUtil.isActionClick((MouseEvent)e);
    }

    @Override
    protected void process(KeyEvent aEvent) {
        this.myList.processKeyEvent(aEvent);
    }

    private int getIndexForShowingChild() {
        return this.myIndexForShowingChild;
    }

    private void setIndexForShowingChild(int aIndexForShowingChild) {
        this.myIndexForShowingChild = aIndexForShowingChild;
    }

    @Override
    protected void onSpeedSearchPatternChanged() {
        this.myListModel.refilter();
        if (this.myListModel.getSize() > 0 && !this.autoSelectUsingStatistics()) {
            int fullMatchIndex = this.myListModel.getClosestMatchIndex();
            if (fullMatchIndex != -1) {
                this.myList.setSelectedIndex(fullMatchIndex);
            }
            if (this.myListModel.getSize() <= this.myList.getSelectedIndex() || !this.myListModel.isVisible(this.myList.getSelectedValue())) {
                this.myList.setSelectedIndex(0);
            }
        }
    }

    @Override
    protected void onSelectByMnemonic(Object value) {
        if (this.myListModel.isVisible(value)) {
            this.myList.setSelectedValue(value, true);
            this.myList.repaint();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ListPopupImpl.this.handleSelect(true);
                }
            });
        }
    }

    @Override
    protected JComponent getPreferredFocusableComponent() {
        return this.myList;
    }

    @Override
    protected void onChildSelectedFor(Object value) {
        if (this.myList.getSelectedValue() != value) {
            this.myList.setSelectedValue(value, false);
        }
    }

    public void setHandleAutoSelectionBeforeShow(boolean autoHandle) {
        this.myAutoHandleBeforeShow = autoHandle;
    }

    @Override
    public boolean isModalContext() {
        return true;
    }

    private class MyList
    extends JList
    implements DataProvider {
        public MyList() {
            super(ListPopupImpl.this.myListModel);
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return new Dimension(super.getPreferredScrollableViewportSize().width, this.getPreferredSize().height);
        }

        @Override
        public void processKeyEvent(KeyEvent e) {
            e.setSource(this);
            super.processKeyEvent(e);
        }

        public Object getData(String dataId) {
            if (PlatformDataKeys.SELECTED_ITEM.is(dataId)) {
                return ListPopupImpl.this.myList.getSelectedValue();
            }
            return null;
        }
    }

    private class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!ListPopupImpl.this.isActionClick(e)) {
                return;
            }
            boolean handleFinalChoices = true;
            Object selectedValue = ListPopupImpl.this.myList.getSelectedValue();
            ListPopupStep<Object> listStep = ListPopupImpl.this.getListStep();
            if (selectedValue != null && listStep.hasSubstep(selectedValue) && listStep.isSelectable(selectedValue)) {
                int index = ListPopupImpl.this.myList.getSelectedIndex();
                Rectangle bounds = ListPopupImpl.this.myList.getCellBounds(index, index);
                Point point = e.getPoint();
                if (point.getX() > (double)bounds.width + bounds.getX() - (double)PopupIcons.HAS_NEXT_ICON.getIconWidth()) {
                    handleFinalChoices = false;
                }
            }
            ListPopupImpl.this.handleSelect(handleFinalChoices, e);
            ListPopupImpl.this.stopTimer();
        }
    }

    private class MyMouseMotionListener
    extends MouseMotionAdapter {
        private MyMouseMotionListener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Point point = e.getPoint();
            int index = ListPopupImpl.this.myList.locationToIndex(point);
            if (index != ListPopupImpl.this.myList.getSelectedIndex()) {
                ListPopupImpl.this.myList.setSelectedIndex(index);
                ListPopupImpl.this.restartTimer();
            }
            ListPopupImpl.this.notifyParentOnChildSelection();
        }
    }
}

