/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.codeInsight.lookup.LookupValueWithPsiElement;
import com.intellij.codeInsight.lookup.LookupValueWithUIHint;
import com.intellij.codeInsight.lookup.PresentableLookupValue;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.xml.ElementPresentationManager;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ElementPresentationManagerImpl
extends ElementPresentationManager {
    @NotNull
    public <T> Object[] createVariants(Collection<T> elements, Function<T, String> namer, int iconFlags) {
        ArrayList<Object> result = new ArrayList<Object>(elements.size());
        for (T element : elements) {
            String name = (String)namer.fun(element);
            if (name == null) continue;
            Object value = this.createVariant(element, name, null);
            result.add(value);
        }
        Object[] objectArray = result.toArray();
        if (objectArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/xml/ElementPresentationManagerImpl.createVariants must not return null");
        }
        return objectArray;
    }

    public Object createVariant(Object variant, String name, PsiElement psiElement) {
        return new DomVariant(variant, name, psiElement);
    }

    private static class DomVariant
    implements PresentableLookupValue,
    Iconable,
    LookupValueWithUIHint,
    LookupValueWithPsiElement {
        private final Object myVariant;
        private final String myName;
        private PsiElement myElement;

        public DomVariant(Object variant, String name, PsiElement element) {
            this.myVariant = variant;
            this.myName = name;
            this.myElement = element;
        }

        @Override
        public String getPresentation() {
            return this.myName;
        }

        @Nullable
        public Icon getIcon(int flags) {
            return ElementPresentationManager.getIcon((Object)this.myVariant);
        }

        @Override
        @Nullable
        public String getTypeHint() {
            return null;
        }

        @Override
        @Nullable
        public Color getColorHint() {
            return null;
        }

        @Override
        public boolean isBold() {
            return false;
        }

        @Override
        @Nullable
        public PsiElement getElement() {
            return this.myElement;
        }
    }
}

