/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDNativeTarget;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.frame.XDebugViewBase;
import com.intellij.xdebugger.impl.ui.XDebugSessionData;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreePanel;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeRestorer;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeState;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchesRootNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

public class XWatchesView
extends XDebugViewBase
implements DnDNativeTarget {
    private final XDebuggerTreePanel myTreePanel;
    private XDebuggerTreeState myTreeState;
    private XDebuggerTreeRestorer myTreeRestorer;
    private WatchesRootNode myRootNode;

    public XWatchesView(XDebugSession session, Disposable parentDisposable, XDebugSessionData sessionData) {
        super(session, parentDisposable);
        this.myTreePanel = new XDebuggerTreePanel(session, session.getDebugProcess().getEditorsProvider(), null, "XDebugger.Watches.Tree.Popup");
        ActionManager actionManager = ActionManager.getInstance();
        CustomShortcutSet insertShortcut = new CustomShortcutSet(KeyStroke.getKeyStroke(155, 0));
        XDebuggerTree tree = this.myTreePanel.getTree();
        actionManager.getAction("XDebugger.NewWatch").registerCustomShortcutSet((ShortcutSet)insertShortcut, (JComponent)((Object)tree));
        CustomShortcutSet deleteShortcut = new CustomShortcutSet(KeyStroke.getKeyStroke(127, 0));
        actionManager.getAction("XDebugger.RemoveWatch").registerCustomShortcutSet((ShortcutSet)deleteShortcut, (JComponent)((Object)tree));
        CustomShortcutSet f2Shortcut = new CustomShortcutSet(KeyStroke.getKeyStroke(113, 0));
        actionManager.getAction("XDebugger.EditWatch").registerCustomShortcutSet((ShortcutSet)f2Shortcut, (JComponent)((Object)tree));
        DnDManager.getInstance().registerTarget((DnDTarget)this, (JComponent)((Object)tree));
        this.myRootNode = new WatchesRootNode(tree, sessionData.getWatchExpressions());
        tree.setRoot(this.myRootNode, false);
    }

    public void addWatchExpression(@NotNull String expression, int index) {
        if (expression == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/impl/frame/XWatchesView.addWatchExpression must not be null");
        }
        XDebuggerEvaluator evaluator = null;
        XStackFrame stackFrame = this.mySession.getCurrentStackFrame();
        if (stackFrame != null) {
            evaluator = stackFrame.getEvaluator();
        }
        this.myRootNode.addWatchExpression(evaluator, expression, index);
    }

    @Override
    protected void rebuildView(XDebugViewBase.SessionEvent event) {
        XStackFrame stackFrame = this.mySession.getCurrentStackFrame();
        XDebuggerTree tree = this.myTreePanel.getTree();
        if (event == XDebugViewBase.SessionEvent.BEFORE_RESUME || event == XDebugViewBase.SessionEvent.SETTINGS_CHANGED) {
            if (this.myTreeRestorer != null) {
                this.myTreeRestorer.dispose();
            }
            this.myTreeState = XDebuggerTreeState.saveState(tree);
            if (event == XDebugViewBase.SessionEvent.BEFORE_RESUME) {
                return;
            }
        }
        if (stackFrame != null) {
            tree.setSourcePosition(stackFrame.getSourcePosition());
            this.myRootNode.updateWatches(stackFrame.getEvaluator());
            if (this.myTreeState != null) {
                this.myTreeRestorer = this.myTreeState.restoreState(tree);
            }
        } else {
            tree.setSourcePosition(null);
            this.myRootNode.updateWatches(null);
        }
    }

    @Override
    public void dispose() {
        DnDManager.getInstance().unregisterTarget((DnDTarget)this, (JComponent)((Object)this.myTreePanel.getTree()));
        super.dispose();
    }

    public XDebuggerTree getTree() {
        return this.myTreePanel.getTree();
    }

    public JPanel getMainPanel() {
        return this.myTreePanel.getMainPanel();
    }

    public void removeWatches(List<? extends XDebuggerTreeNode> nodes) {
        List<? extends WatchNode> children = this.myRootNode.getAllChildren();
        int minIndex = Integer.MAX_VALUE;
        if (children != null) {
            for (XDebuggerTreeNode xDebuggerTreeNode : nodes) {
                int index = children.indexOf(xDebuggerTreeNode);
                if (index == -1) continue;
                minIndex = Math.min(minIndex, index);
            }
        }
        this.myRootNode.removeChildren(nodes);
        List<? extends WatchNode> newChildren = this.myRootNode.getAllChildren();
        if (newChildren != null && newChildren.size() > 0) {
            WatchNode watchNode = minIndex < newChildren.size() ? newChildren.get(minIndex) : newChildren.get(newChildren.size() - 1);
            TreeUtil.selectNode((JTree)((Object)this.myTreePanel.getTree()), (TreeNode)watchNode);
        }
    }

    public List<String> getWatchExpressions() {
        ArrayList<String> watchExpressions = new ArrayList<String>();
        List<? extends WatchNode> children = this.myRootNode.getAllChildren();
        if (children != null) {
            for (WatchNode watchNode : children) {
                watchExpressions.add(watchNode.getExpression());
            }
        }
        return watchExpressions;
    }

    public boolean update(DnDEvent aEvent) {
        Object object = aEvent.getAttachedObject();
        boolean possible = false;
        if (object instanceof XValueNodeImpl[]) {
            possible = true;
        } else if (object instanceof DnDNativeTarget.EventInfo) {
            possible = ((DnDNativeTarget.EventInfo)object).getTextForFlavor(DataFlavor.stringFlavor) != null;
        }
        aEvent.setDropPossible(possible, XDebuggerBundle.message((String)"xdebugger.drop.text.add.to.watches", (Object[])new Object[0]));
        return true;
    }

    public void drop(DnDEvent aEvent) {
        String text;
        Object object = aEvent.getAttachedObject();
        if (object instanceof XValueNodeImpl[]) {
            XValueNodeImpl[] nodes;
            for (XValueNodeImpl node : nodes = (XValueNodeImpl[])object) {
                String expression = ((XValue)node.getValueContainer()).getEvaluationExpression();
                if (expression == null) continue;
                this.addWatchExpression(expression, -1);
            }
        } else if (object instanceof DnDNativeTarget.EventInfo && (text = ((DnDNativeTarget.EventInfo)object).getTextForFlavor(DataFlavor.stringFlavor)) != null) {
            this.addWatchExpression(text, -1);
        }
    }

    public void cleanUpOnLeave() {
    }

    public void updateDraggedImage(Image image, Point dropPoint, Point imageOffset) {
    }
}

