/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.actions;

import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.javaee.UriUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.MessageView;
import com.intellij.util.Function;
import com.intellij.util.ui.ErrorTreeView;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.util.XmlResourceResolver;
import java.io.FileNotFoundException;
import java.io.StringReader;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.xml.parsers.SAXParser;
import org.apache.xerces.jaxp.SAXParserFactoryImpl;
import org.apache.xerces.util.XMLGrammarPoolImpl;
import org.jetbrains.annotations.NonNls;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ValidateXmlActionHandler
implements Function<PsiFile, Void> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.xml.actions.ValidateXmlAction");
    private static final Key<NewErrorTreeViewPanel> KEY = Key.create((String)"ValidateXmlAction.KEY");
    @NonNls
    private static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    private static final String GRAMMAR_FEATURE_ID = "http://apache.org/xml/properties/internal/grammar-pool";
    private static final Key<XMLGrammarPoolImpl> GRAMMAR_POOL_KEY = Key.create((String)"GrammarPoolKey");
    private static final Key<Long> GRAMMAR_POOL_TIME_STAMP_KEY = Key.create((String)"GrammarPoolTimeStampKey");
    private static final Key<VirtualFile[]> DEPENDENT_FILES_KEY = Key.create((String)"GrammarPoolFilesKey");
    private Project myProject;
    private XmlFile myFile;
    private ErrorReporter myErrorReporter;
    private Object myParser;
    private XmlResourceResolver myXmlResourceResolver;
    private final boolean myForceChecking;
    @NonNls
    private static final String ENTITY_RESOLVER_PROPERTY_NAME = "http://apache.org/xml/properties/internal/entity-resolver";

    public ValidateXmlActionHandler(boolean _forceChecking) {
        this.myForceChecking = _forceChecking;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.myErrorReporter = errorReporter;
    }

    public VirtualFile getFile(String publicId, String systemId) {
        if (publicId == null) {
            if (systemId != null) {
                String path = this.myXmlResourceResolver.getPathByPublicId(systemId);
                if (path != null) {
                    return UriUtil.findRelativeFile((String)path, null);
                }
                PsiFile file = this.myXmlResourceResolver.resolve(null, systemId);
                if (file != null) {
                    return file.getVirtualFile();
                }
            }
            return this.myFile.getVirtualFile();
        }
        String path = this.myXmlResourceResolver.getPathByPublicId(publicId);
        if (path != null) {
            return UriUtil.findRelativeFile((String)path, null);
        }
        return null;
    }

    private String buildMessageString(SAXParseException ex) {
        String msg = "(" + ex.getLineNumber() + ":" + ex.getColumnNumber() + ") " + ex.getMessage();
        VirtualFile file = this.getFile(ex.getPublicId(), ex.getSystemId());
        if (file != null && !file.equals(this.myFile.getVirtualFile())) {
            msg = file.getName() + ":" + msg;
        }
        return msg;
    }

    public Void fun(PsiFile file) {
        Project project = file.getProject();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        this.doValidate(project, file);
        return null;
    }

    public void doValidate(Project project, PsiFile file) {
        this.myProject = project;
        this.myFile = (XmlFile)file;
        this.myXmlResourceResolver = new XmlResourceResolver(this.myFile, this.myProject, this.myErrorReporter);
        this.myXmlResourceResolver.setStopOnUnDeclaredResource(this.myErrorReporter.isStopOnUndeclaredResource());
        try {
            this.myParser = this.createParser();
            if (this.myParser == null) {
                return;
            }
            this.myErrorReporter.startProcessing();
        }
        catch (XmlResourceResolver.IgnoredResourceException e) {
        }
        catch (Exception exception) {
            this.filterAppException(exception);
        }
    }

    private void filterAppException(Exception exception) {
        if (!this.myErrorReporter.filterValidationException(exception)) {
            LOG.error((Throwable)exception);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    private void doParse() {
        block8: {
            try {
                if (this.myParser instanceof SAXParser) {
                    SAXParser parser = (SAXParser)this.myParser;
                    try {
                        parser.parse(new InputSource(new StringReader(this.myFile.getText())), new DefaultHandler(){

                            @Override
                            public void warning(SAXParseException e) {
                                if (ValidateXmlActionHandler.this.myErrorReporter.isUniqueProblem(e)) {
                                    ValidateXmlActionHandler.this.myErrorReporter.processError(e, true);
                                }
                            }

                            @Override
                            public void error(SAXParseException e) {
                                if (ValidateXmlActionHandler.this.myErrorReporter.isUniqueProblem(e)) {
                                    ValidateXmlActionHandler.this.myErrorReporter.processError(e, false);
                                }
                            }

                            @Override
                            public void fatalError(SAXParseException e) {
                                if (ValidateXmlActionHandler.this.myErrorReporter.isUniqueProblem(e)) {
                                    ValidateXmlActionHandler.this.myErrorReporter.processError(e, false);
                                }
                            }

                            @Override
                            public InputSource resolveEntity(String publicId, String systemId) {
                                PsiFile psiFile = ValidateXmlActionHandler.this.myXmlResourceResolver.resolve(null, systemId);
                                if (psiFile == null) {
                                    return null;
                                }
                                return new InputSource(new StringReader(psiFile.getText()));
                            }

                            @Override
                            public void startDocument() throws SAXException {
                                super.startDocument();
                                ((SAXParser)ValidateXmlActionHandler.this.myParser).setProperty(ValidateXmlActionHandler.ENTITY_RESOLVER_PROPERTY_NAME, ValidateXmlActionHandler.this.myXmlResourceResolver);
                            }
                        });
                        String[] resourcePaths = this.myXmlResourceResolver.getResourcePaths();
                        if (resourcePaths.length > 0) {
                            VirtualFile[] files = new VirtualFile[resourcePaths.length];
                            for (int i = 0; i < resourcePaths.length; ++i) {
                                files[i] = UriUtil.findRelativeFile((String)resourcePaths[i], null);
                            }
                            this.myFile.putUserData(DEPENDENT_FILES_KEY, (Object)files);
                            this.myFile.putUserData(GRAMMAR_POOL_TIME_STAMP_KEY, (Object)new Long(ValidateXmlActionHandler.calculateTimeStamp(files, this.myProject)));
                        }
                        break block8;
                    }
                    catch (SAXException e) {
                        LOG.debug((Throwable)e);
                    }
                    break block8;
                }
                LOG.error("unknown parser: " + this.myParser);
            }
            catch (Exception exception) {
                this.filterAppException(exception);
            }
            catch (StackOverflowError stackOverflowError) {
                // empty catch block
            }
        }
    }

    private Object createParser() {
        try {
            if (!(this.needsDtdChecking() || this.needsSchemaChecking() || this.myForceChecking)) {
                return null;
            }
            SAXParserFactoryImpl factory = new SAXParserFactoryImpl();
            boolean schemaChecking = false;
            if (this.hasDtdDeclaration()) {
                factory.setValidating(true);
            }
            if (this.needsSchemaChecking()) {
                factory.setValidating(true);
                factory.setNamespaceAware(true);
                try {
                    factory.setXIncludeAware(true);
                }
                catch (NoSuchMethodError e) {
                    // empty catch block
                }
                schemaChecking = true;
            }
            SAXParser parser = factory.newSAXParser();
            parser.setProperty(ENTITY_RESOLVER_PROPERTY_NAME, this.myXmlResourceResolver);
            if (schemaChecking) {
                XMLGrammarPoolImpl previousGrammarPool = (XMLGrammarPoolImpl)this.myFile.getUserData(GRAMMAR_POOL_KEY);
                XMLGrammarPoolImpl grammarPool = null;
                if (!this.myForceChecking && !ValidateXmlActionHandler.isValidationDependentFilesOutOfDate(this.myFile)) {
                    grammarPool = previousGrammarPool;
                }
                if (grammarPool == null) {
                    grammarPool = new XMLGrammarPoolImpl();
                    this.myFile.putUserData(GRAMMAR_POOL_KEY, (Object)grammarPool);
                }
                parser.getXMLReader().setProperty(GRAMMAR_FEATURE_ID, grammarPool);
            }
            try {
                if (schemaChecking) {
                    parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                    parser.getXMLReader().setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, true);
                    if (Boolean.TRUE.equals(Boolean.getBoolean("idea.xml.honour.all.schema.locations"))) {
                        parser.getXMLReader().setFeature("http://apache.org/xml/features/honour-all-schemaLocations", true);
                    }
                    parser.getXMLReader().setFeature("http://apache.org/xml/features/validation/warn-on-undeclared-elemdef", Boolean.TRUE);
                    parser.getXMLReader().setFeature("http://apache.org/xml/features/validation/warn-on-duplicate-attdef", Boolean.TRUE);
                }
                parser.getXMLReader().setFeature("http://apache.org/xml/features/warn-on-duplicate-entitydef", Boolean.TRUE);
                parser.getXMLReader().setFeature("http://apache.org/xml/features/validation/unparsed-entity-checking", Boolean.FALSE);
            }
            catch (SAXNotRecognizedException ex) {
                LOG.info("Xml parser installation seems screwed", (Throwable)ex);
            }
            return parser;
        }
        catch (Exception e) {
            this.filterAppException(e);
            return null;
        }
    }

    public static boolean isValidationDependentFilesOutOfDate(XmlFile myFile) {
        long dependentFilesTimestamp;
        VirtualFile[] files = (VirtualFile[])myFile.getUserData(DEPENDENT_FILES_KEY);
        Long grammarPoolTimeStamp = (Long)myFile.getUserData(GRAMMAR_POOL_TIME_STAMP_KEY);
        return grammarPoolTimeStamp == null || files == null || (dependentFilesTimestamp = ValidateXmlActionHandler.calculateTimeStamp(files, myFile.getProject())) != grammarPoolTimeStamp || dependentFilesTimestamp == 0L;
    }

    private static long calculateTimeStamp(VirtualFile[] files, Project myProject) {
        long timestamp = 0L;
        for (VirtualFile file : files) {
            PsiFile psifile;
            if (file == null || !file.isValid() || (psifile = PsiManager.getInstance((Project)myProject).findFile(file)) == null || !psifile.isValid()) break;
            timestamp += psifile.getModificationStamp();
        }
        return timestamp;
    }

    private boolean hasDtdDeclaration() {
        XmlDocument document = this.myFile.getDocument();
        if (document == null) {
            return false;
        }
        XmlProlog prolog = document.getProlog();
        if (prolog == null) {
            return false;
        }
        XmlDoctype doctype = prolog.getDoctype();
        return doctype != null;
    }

    private boolean needsDtdChecking() {
        XmlDocument document = this.myFile.getDocument();
        if (document == null) {
            return false;
        }
        return document.getProlog() != null && document.getProlog().getDoctype() != null;
    }

    private boolean needsSchemaChecking() {
        XmlAttribute[] attributes;
        XmlDocument document = this.myFile.getDocument();
        if (document == null) {
            return false;
        }
        XmlTag rootTag = document.getRootTag();
        if (rootTag == null) {
            return false;
        }
        for (XmlAttribute attribute : attributes = rootTag.getAttributes()) {
            if (!attribute.isNamespaceDeclaration()) continue;
            return true;
        }
        return false;
    }

    private static class MyContentDisposer
    implements ContentManagerListener {
        private final Content myContent;
        private final MessageView myMessageView;

        public MyContentDisposer(Content content, MessageView messageView) {
            this.myContent = content;
            this.myMessageView = messageView;
        }

        public void contentRemoved(ContentManagerEvent event) {
            Content eventContent = event.getContent();
            if (!eventContent.equals(this.myContent)) {
                return;
            }
            this.myMessageView.getContentManager().removeContentManagerListener((ContentManagerListener)this);
            NewErrorTreeViewPanel errorTreeView = (NewErrorTreeViewPanel)eventContent.getUserData(KEY);
            if (errorTreeView != null) {
                errorTreeView.dispose();
            }
            eventContent.putUserData(KEY, null);
        }

        public void contentAdded(ContentManagerEvent event) {
        }

        public void contentRemoveQuery(ContentManagerEvent event) {
        }

        public void selectionChanged(ContentManagerEvent event) {
        }
    }

    class StdErrorReporter
    extends ErrorReporter {
        private final NewErrorTreeViewPanel myErrorsView;
        private final String CONTENT_NAME;
        private boolean myErrorsDetected;

        StdErrorReporter(Project project, Runnable rerunAction) {
            this.CONTENT_NAME = XmlBundle.message((String)"xml.validate.tab.content.title", (Object[])new Object[0]);
            this.myErrorsDetected = false;
            this.myErrorsView = new NewErrorTreeViewPanel(project, null, true, true, rerunAction);
        }

        @Override
        public void startProcessing() {
            Runnable task = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        ApplicationManager.getApplication().runReadAction(new Runnable(){

                            @Override
                            public void run() {
                                StdErrorReporter.super.startProcessing();
                            }
                        });
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (!StdErrorReporter.this.myErrorsDetected) {
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            StdErrorReporter.this.removeCompileContents(null);
                                            WindowManager.getInstance().getStatusBar(ValidateXmlActionHandler.this.myProject).setInfo(XmlBundle.message((String)"xml.validate.no.errors.detected.status.message", (Object[])new Object[0]));
                                        }
                                    });
                                }
                            }
                        });
                    }
                    finally {
                        boolean bl = Thread.interrupted();
                    }
                }
            };
            MyProcessController processController = new MyProcessController();
            this.myErrorsView.setProcessController(processController);
            this.openMessageView();
            processController.setFuture(ApplicationManager.getApplication().executeOnPooledThread(task));
            ToolWindowManager.getInstance((Project)ValidateXmlActionHandler.this.myProject).getToolWindow(ToolWindowId.MESSAGES_WINDOW).activate(null);
        }

        private void openMessageView() {
            CommandProcessor commandProcessor = CommandProcessor.getInstance();
            commandProcessor.executeCommand(ValidateXmlActionHandler.this.myProject, new Runnable(){

                @Override
                public void run() {
                    MessageView messageView = MessageView.SERVICE.getInstance(ValidateXmlActionHandler.this.myProject);
                    Content content = ContentFactory.SERVICE.getInstance().createContent(StdErrorReporter.this.myErrorsView.getComponent(), StdErrorReporter.this.CONTENT_NAME, true);
                    content.putUserData(KEY, (Object)StdErrorReporter.this.myErrorsView);
                    messageView.getContentManager().addContent(content);
                    messageView.getContentManager().setSelectedContent(content);
                    messageView.getContentManager().addContentManagerListener((ContentManagerListener)new CloseListener(content, messageView.getContentManager()));
                    StdErrorReporter.this.removeCompileContents(content);
                    messageView.getContentManager().addContentManagerListener((ContentManagerListener)new MyContentDisposer(content, messageView));
                }
            }, XmlBundle.message((String)"validate.xml.open.message.view.command.name", (Object[])new Object[0]), null);
        }

        private void removeCompileContents(Content notToRemove) {
            MessageView messageView = MessageView.SERVICE.getInstance(ValidateXmlActionHandler.this.myProject);
            for (Content content : messageView.getContentManager().getContents()) {
                ErrorTreeView listErrorView;
                if (content.isPinned() || !this.CONTENT_NAME.equals(content.getDisplayName()) || content == notToRemove || (listErrorView = (ErrorTreeView)content.getComponent()) == null || !messageView.getContentManager().removeContent(content, true)) continue;
                content.release();
            }
        }

        @Override
        public void processError(final SAXParseException ex, final boolean warning) {
            if (LOG.isDebugEnabled()) {
                String error = ValidateXmlActionHandler.this.buildMessageString(ex);
                LOG.debug("enter: processError(error='" + error + "')");
            }
            this.myErrorsDetected = true;
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        VirtualFile file = ValidateXmlActionHandler.this.getFile(ex.getPublicId(), ex.getSystemId());
                        StdErrorReporter.this.myErrorsView.addMessage(warning ? 5 : 4, new String[]{ex.getLocalizedMessage()}, file, ex.getLineNumber() - 1, ex.getColumnNumber() - 1, null);
                    }
                });
            }
        }

        private class MyProcessController
        implements NewErrorTreeViewPanel.ProcessController {
            private Future<?> myFuture;

            private MyProcessController() {
            }

            public void setFuture(Future<?> future) {
                this.myFuture = future;
            }

            @Override
            public void stopProcess() {
                if (this.myFuture != null) {
                    this.myFuture.cancel(true);
                }
            }

            @Override
            public boolean isProcessStopped() {
                return this.myFuture != null && this.myFuture.isDone();
            }
        }

        private class CloseListener
        extends ContentManagerAdapter {
            private Content myContent;
            private final ContentManager myContentManager;

            public CloseListener(Content content, ContentManager contentManager) {
                this.myContent = content;
                this.myContentManager = contentManager;
            }

            public void contentRemoved(ContentManagerEvent event) {
                if (event.getContent() == this.myContent) {
                    StdErrorReporter.this.myErrorsView.stopProcess();
                    this.myContentManager.removeContentManagerListener((ContentManagerListener)this);
                    this.myContent.release();
                    this.myContent = null;
                }
            }

            public void contentRemoveQuery(ContentManagerEvent event) {
                int result;
                if (event.getContent() == this.myContent && !StdErrorReporter.this.myErrorsView.isProcessStopped() && (result = Messages.showYesNoDialog((String)XmlBundle.message((String)"xml.validate.validation.is.running.terminate.confirmation.text", (Object[])new Object[0]), (String)XmlBundle.message((String)"xml.validate.validation.is.running.terminate.confirmation.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon())) != 0) {
                    event.consume();
                }
            }
        }
    }

    public class TestErrorReporter
    extends ErrorReporter {
        private final ArrayList<String> errors;

        public TestErrorReporter() {
            this.errors = new ArrayList(3);
        }

        @Override
        public boolean isStopOnUndeclaredResource() {
            return true;
        }

        @Override
        public boolean filterValidationException(Exception ex) {
            if (ex instanceof XmlResourceResolver.IgnoredResourceException) {
                throw (XmlResourceResolver.IgnoredResourceException)ex;
            }
            return this.errors.add(ex.getMessage());
        }

        @Override
        public void processError(SAXParseException ex, boolean warning) {
            this.errors.add(ValidateXmlActionHandler.this.buildMessageString(ex));
        }

        public List<String> getErrors() {
            return this.errors;
        }
    }

    public abstract class ErrorReporter {
        protected final Set<String> ourErrorsSet = new HashSet<String>();

        public abstract void processError(SAXParseException var1, boolean var2);

        public boolean filterValidationException(Exception ex) {
            if (ex instanceof ProcessCanceledException) {
                throw (ProcessCanceledException)((Object)ex);
            }
            if (ex instanceof XmlResourceResolver.IgnoredResourceException) {
                throw (XmlResourceResolver.IgnoredResourceException)ex;
            }
            if (ex instanceof FileNotFoundException || ex instanceof MalformedURLException || ex instanceof NoRouteToHostException || ex instanceof SocketTimeoutException || ex instanceof UnknownHostException || ex instanceof ConnectException) {
                return true;
            }
            return ex instanceof NullPointerException;
        }

        public void startProcessing() {
            ValidateXmlActionHandler.this.doParse();
        }

        public boolean isStopOnUndeclaredResource() {
            return false;
        }

        public boolean isUniqueProblem(SAXParseException e) {
            String error = ValidateXmlActionHandler.this.buildMessageString(e);
            if (this.ourErrorsSet.contains(error)) {
                return false;
            }
            this.ourErrorsSet.add(error);
            return true;
        }
    }
}

