/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.concatenation;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.search.GlobalSearchScope;

class AppendUtil {
    private AppendUtil() {
    }

    public static boolean isAppendCall(PsiElement element) {
        if (!(element instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
        PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
        String callName = methodExpression.getReferenceName();
        if (!"append".equals(callName)) {
            return false;
        }
        PsiMethod method = methodCallExpression.resolveMethod();
        if (method == null) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        String name = containingClass.getQualifiedName();
        if ("java.lang.StringBuffer".equals(name) || "java.lang.StringBuilder".equals(name)) {
            return true;
        }
        PsiManager manager = containingClass.getManager();
        Project project = containingClass.getProject();
        PsiClass appendableClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass("java.lang.Appendable", GlobalSearchScope.allScope((Project)project));
        if (appendableClass == null) {
            return false;
        }
        return containingClass.isInheritor(appendableClass, true);
    }
}

