/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.psiutils;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.tree.IElementType;

public class SideEffectChecker {
    private SideEffectChecker() {
    }

    public static boolean mayHaveSideEffects(PsiExpression exp) {
        SideEffectsVisitor visitor = new SideEffectsVisitor();
        exp.accept((PsiElementVisitor)visitor);
        return visitor.mayHaveSideEffects();
    }

    private static class SideEffectsVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean mayHaveSideEffects = false;

        private SideEffectsVisitor() {
        }

        public void visitElement(PsiElement element) {
            if (!this.mayHaveSideEffects) {
                super.visitElement(element);
            }
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            this.mayHaveSideEffects = true;
        }

        public void visitNewExpression(PsiNewExpression expression) {
            this.mayHaveSideEffects = true;
        }

        public void visitAssignmentExpression(PsiAssignmentExpression expression) {
            this.mayHaveSideEffects = true;
        }

        public void visitPrefixExpression(PsiPrefixExpression expression) {
            super.visitPrefixExpression(expression);
            PsiJavaToken sign = expression.getOperationSign();
            IElementType tokenType = sign.getTokenType();
            if (tokenType.equals(JavaTokenType.PLUSPLUS) || tokenType.equals(JavaTokenType.MINUSMINUS)) {
                this.mayHaveSideEffects = true;
            }
        }

        public void visitPostfixExpression(PsiPostfixExpression expression) {
            super.visitPostfixExpression(expression);
            PsiJavaToken sign = expression.getOperationSign();
            IElementType tokenType = sign.getTokenType();
            if (tokenType.equals(JavaTokenType.PLUSPLUS) || tokenType.equals(JavaTokenType.MINUSMINUS)) {
                this.mayHaveSideEffects = true;
            }
        }

        public boolean mayHaveSideEffects() {
            return this.mayHaveSideEffects;
        }
    }
}

