/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.javacvsImpl.io;

import com.intellij.cvsSupport2.CvsUtil;
import com.intellij.cvsSupport2.cvsoperations.common.UpdatedFilesManager;
import com.intellij.cvsSupport2.cvsoperations.cvsErrors.ErrorProcessor;
import com.intellij.cvsSupport2.errorHandling.CvsException;
import com.intellij.cvsSupport2.javacvsImpl.ProjectContentInfoProvider;
import com.intellij.cvsSupport2.javacvsImpl.io.ReceiveTextFilePreprocessor;
import com.intellij.cvsSupport2.util.CvsVfsUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Date;
import org.jetbrains.annotations.NonNls;
import org.netbeans.lib.cvsclient.file.AbstractFileObject;
import org.netbeans.lib.cvsclient.file.FileObject;
import org.netbeans.lib.cvsclient.file.ICvsFileSystem;
import org.netbeans.lib.cvsclient.file.IFileReadOnlyHandler;
import org.netbeans.lib.cvsclient.file.IFileSystem;
import org.netbeans.lib.cvsclient.file.ILocalFileWriter;
import org.netbeans.lib.cvsclient.file.IReaderFactory;
import org.netbeans.lib.cvsclient.file.IReceiveTextFilePreprocessor;
import org.netbeans.lib.cvsclient.file.LocalFileWriter;

public class StoringLineSeparatorsLocalFileWriter
implements ILocalFileWriter {
    private final LocalFileWriter myLocalFileWriter;
    private final ErrorProcessor myErrorProcessor;
    private final UpdatedFilesManager myUpdatedFilesManager;
    private final String myCvsRoot;
    private final ReceiveTextFilePreprocessor myReceiveTextFilePreprocessor;
    private final ProjectContentInfoProvider myProjectContentInfoProvider;
    @NonNls
    private static final String COULD_NOT_DELETE_FILE_PREFIX = "Could not delete file ";

    public StoringLineSeparatorsLocalFileWriter(ReceiveTextFilePreprocessor preprocessor, ErrorProcessor errorProcessor, UpdatedFilesManager nonUpdateableFilesProcessor, String cvsRoot, ProjectContentInfoProvider projectContentInfoProvider) {
        this.myCvsRoot = cvsRoot;
        this.myLocalFileWriter = new LocalFileWriter((IReceiveTextFilePreprocessor)preprocessor);
        this.myErrorProcessor = errorProcessor;
        this.myUpdatedFilesManager = nonUpdateableFilesProcessor;
        this.myReceiveTextFilePreprocessor = preprocessor;
        this.myProjectContentInfoProvider = projectContentInfoProvider;
    }

    public void setNextFileMode(String nextFileMode) {
        this.myLocalFileWriter.setNextFileMode(nextFileMode);
    }

    public void setNextFileDate(Date modifiedDate) {
        this.myLocalFileWriter.setNextFileDate(modifiedDate);
    }

    public void renameLocalFile(FileObject fileObject, ICvsFileSystem cvsFileSystem, String newFileName) throws IOException {
        File originalFile = cvsFileSystem.getLocalFileSystem().getFile((AbstractFileObject)fileObject);
        File targetFile = new File(originalFile.getParentFile(), newFileName);
        try {
            FileUtil.copy((File)originalFile, (File)targetFile);
        }
        catch (IOException ex) {
            this.processException(ex, null, -1, cvsFileSystem.getLocalFileSystem(), fileObject, this.myCvsRoot);
        }
    }

    public void removeLocalFile(FileObject fileObject, ICvsFileSystem cvsFileSystem, IFileReadOnlyHandler fileReadOnlyHandler) throws IOException {
        if (this.hasToBeSkipped((AbstractFileObject)fileObject, cvsFileSystem.getLocalFileSystem())) {
            return;
        }
        try {
            this.myLocalFileWriter.removeLocalFile(fileObject, cvsFileSystem, fileReadOnlyHandler);
        }
        catch (IOException ex) {
            this.processException(ex, null, -1, cvsFileSystem.getLocalFileSystem(), fileObject, this.myCvsRoot);
        }
    }

    public void writeBinaryFile(FileObject fileObject, int length, InputStream inputStream, boolean readOnly, IFileReadOnlyHandler fileReadOnlyHandler, ICvsFileSystem cvsFileSystem) throws IOException {
        if (this.hasToBeSkipped((AbstractFileObject)fileObject, cvsFileSystem.getLocalFileSystem())) {
            CvsUtil.skip(inputStream, length);
            return;
        }
        try {
            this.myLocalFileWriter.writeBinaryFile(fileObject, length, inputStream, readOnly, fileReadOnlyHandler, cvsFileSystem);
        }
        catch (IOException ex) {
            this.processException(ex, inputStream, length, cvsFileSystem.getLocalFileSystem(), fileObject, this.myCvsRoot);
        }
    }

    private boolean hasToBeSkipped(AbstractFileObject fileObject, IFileSystem localFileSystem) {
        if (fileObject == null) {
            return false;
        }
        File localFile = localFileSystem.getFile(fileObject);
        if (!localFile.exists()) {
            return this.hasToBeSkipped((AbstractFileObject)fileObject.getParent(), localFileSystem);
        }
        return !this.myProjectContentInfoProvider.fileIsUnderProject(localFile);
    }

    public void writeTextFile(FileObject fileObject, int length, InputStream inputStream, boolean readOnly, IReaderFactory readerFactory, IFileReadOnlyHandler fileReadOnlyHandler, IFileSystem fileSystem, Charset charSet) throws IOException {
        if (this.hasToBeSkipped((AbstractFileObject)fileObject, fileSystem)) {
            CvsUtil.skip(inputStream, length);
            return;
        }
        try {
            this.storeLineSeparatorInTheVirtualFile(fileSystem, fileObject);
            this.myLocalFileWriter.writeTextFile(fileObject, length, inputStream, readOnly, readerFactory, fileReadOnlyHandler, fileSystem, charSet);
        }
        catch (IOException ex) {
            this.processException(ex, inputStream, length, fileSystem, fileObject, this.myCvsRoot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processException(IOException ex, InputStream inputStream, int length, IFileSystem fileSystem, FileObject fileObject, String cvsRoot) throws IOException {
        File file = fileSystem.getFile((AbstractFileObject)fileObject);
        CvsException vcsEx = new CvsException(ex.getLocalizedMessage() + ": " + file.getAbsolutePath(), cvsRoot);
        try {
            if (ex.getLocalizedMessage().startsWith(COULD_NOT_DELETE_FILE_PREFIX)) {
                this.myUpdatedFilesManager.couldNotUpdateFile(file);
                vcsEx.setVirtualFile(CvsVfsUtil.findFileByIoFile(file));
            }
        }
        finally {
            CvsUtil.skip(inputStream, length);
            this.myErrorProcessor.addWarning(vcsEx);
        }
    }

    private void storeLineSeparatorInTheVirtualFile(IFileSystem fileSystem, FileObject fileObject) {
        final VirtualFile virtualFile = CvsVfsUtil.findFileByIoFile(fileSystem.getFile((AbstractFileObject)fileObject));
        if (virtualFile != null) {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    FileDocumentManager.getInstance().getDocument(virtualFile);
                    StoringLineSeparatorsLocalFileWriter.this.myReceiveTextFilePreprocessor.saveLineSeparatorForFile(virtualFile, StoringLineSeparatorsLocalFileWriter.this.getLineSeparatorFor(virtualFile));
                }
            });
        }
    }

    private String getLineSeparatorFor(VirtualFile virtualFile) {
        try {
            return FileDocumentManager.getInstance().getLineSeparator(virtualFile, null);
        }
        catch (Exception ex) {
            return CodeStyleSettingsManager.getInstance().getCurrentSettings().getLineSeparator();
        }
    }
}

