/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator.intentions.dynamic.ui;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.IconLoader;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.ui.EditorComboBoxEditor;
import com.intellij.ui.EditorTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.IncorrectOperationException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.EventListenerList;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.annotator.intentions.QuickfixUtil;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.DynamicManager;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.MyPair;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.elements.DClassElement;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.elements.DItemElement;
import org.jetbrains.plugins.groovy.annotator.intentions.dynamic.ui.DynamicElementSettings;
import org.jetbrains.plugins.groovy.codeInspection.GroovyInspectionBundle;
import org.jetbrains.plugins.groovy.debugger.fragments.GroovyCodeFragment;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.expectedTypes.TypeConstraint;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public abstract class DynamicDialog
extends DialogWrapper {
    private JComboBox myClassComboBox;
    private JPanel myPanel;
    private JComboBox myTypeComboBox;
    private JLabel myClassLabel;
    private JLabel myTypeLabel;
    private JPanel myTypeStatusPanel;
    private JLabel myTypeStatusLabel;
    private JTable myParametersTable;
    private JLabel myTableLabel;
    private JCheckBox myStaticCheckBox;
    private final DynamicManager myDynamicManager;
    private final Project myProject;
    private final EventListenerList myListenerList;
    private final PsiElement myContext;
    private final DynamicElementSettings mySettings;
    private static final Logger LOG = Logger.getInstance((String)"org.jetbrains.plugins.groovy.annotator.intentions.dynamic.ui.DynamicDialog");

    public DynamicDialog(PsiElement context, DynamicElementSettings settings, TypeConstraint[] typeConstraints) {
        super(context.getProject(), true);
        this.$$$setupUI$$$();
        this.myListenerList = new EventListenerList();
        this.myProject = context.getProject();
        if (!this.isTableVisible()) {
            this.myParametersTable.setVisible(false);
            this.myTableLabel.setVisible(false);
        }
        this.myContext = context;
        this.setTitle(GroovyInspectionBundle.message("dynamic.element", new Object[0]));
        this.myDynamicManager = DynamicManager.getInstance(this.myProject);
        this.init();
        this.mySettings = settings;
        this.setUpTypeComboBox(typeConstraints);
        this.setUpContainingClassComboBox();
        this.setUpStatusLabel();
        this.setUpStaticComboBox();
        this.myTableLabel.setLabelFor(this.myParametersTable);
        this.setUpTableNameLabel(GroovyBundle.message("dynamic.properties.table.name", new Object[0]));
        Border border2 = BorderFactory.createLineBorder(Color.BLACK);
        this.myParametersTable.setBorder(border2);
        this.myParametersTable.setBackground(Color.WHITE);
        this.myTypeLabel.setLabelFor(this.myTypeComboBox);
        this.myClassLabel.setLabelFor(this.myClassComboBox);
    }

    private void setUpStaticComboBox() {
        this.myStaticCheckBox.setMnemonic(83);
        this.myStaticCheckBox.setSelected(this.mySettings.isStatic());
    }

    public DynamicElementSettings getSettings() {
        return this.mySettings;
    }

    protected void setUpTableNameLabel(String text) {
        this.myTableLabel.setText(text);
    }

    private void setUpStatusLabel() {
        if (!DynamicDialog.isTypeCheckerPanelEnable()) {
            this.myTypeStatusPanel.setVisible(false);
            return;
        }
        this.myTypeStatusLabel.setHorizontalTextPosition(4);
        GrTypeElement typeElement = this.getEnteredTypeName();
        if (typeElement == null) {
            this.setStatusTextAndIcon(IconLoader.getIcon((String)"/compiler/warning.png"), GroovyInspectionBundle.message("no.type.specified", new Object[0]));
            return;
        }
        PsiType type = typeElement.getType();
        if (type instanceof PsiClassType && ((PsiClassType)type).resolve() == null) {
            this.setStatusTextAndIcon(IconLoader.getIcon((String)"/compiler/warning.png"), GroovyInspectionBundle.message("unresolved.type.status", type.getPresentableText()));
            return;
        }
        this.setStatusTextAndIcon(null, "");
    }

    private void setStatusTextAndIcon(Icon icon, String text) {
        this.myTypeStatusLabel.setIcon(icon);
        this.myTypeStatusLabel.setText(text);
        this.pack();
    }

    @Nullable
    public PsiClass getTargetClass() {
        return JavaPsiFacade.getInstance((Project)this.myProject).findClass(this.mySettings.getContainingClassName(), GlobalSearchScope.allScope((Project)this.myProject));
    }

    private void setUpContainingClassComboBox() {
        PsiClass targetClass = this.getTargetClass();
        if (targetClass == null || targetClass instanceof SyntheticElement) {
            try {
                GrTypeElement typeElement = GroovyPsiElementFactory.getInstance(this.myProject).createTypeElement("java.lang.Object");
                if (typeElement == null) {
                    return;
                }
                PsiType type = typeElement.getType();
                if (!(type instanceof PsiClassType)) {
                    LOG.error("Type java.lang.Object doesn't resolve");
                }
                targetClass = ((PsiClassType)type).resolve();
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
        if (targetClass == null) {
            return;
        }
        for (PsiClass aClass : PsiUtil.iterateSupers(targetClass, true)) {
            this.myClassComboBox.addItem(new ContainingClassItem(aClass));
        }
        this.myPanel.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DynamicDialog.this.myClassComboBox.requestFocus();
            }
        }, KeyStroke.getKeyStroke(67, 8), 2);
    }

    @Nullable
    private Document createDocument(String text) {
        GroovyCodeFragment fragment = new GroovyCodeFragment(this.myProject, text);
        fragment.setContext(this.myContext);
        return PsiDocumentManager.getInstance((Project)this.myProject).getDocument((PsiFile)fragment);
    }

    private void setUpTypeComboBox(TypeConstraint[] typeConstraints) {
        PsiClassType type;
        EditorComboBoxEditor comboEditor = new EditorComboBoxEditor(this.myProject, (FileType)GroovyFileType.GROOVY_FILE_TYPE);
        Document document = this.createDocument("");
        assert (document != null);
        comboEditor.setItem((Object)document);
        this.myTypeComboBox.setEditor((ComboBoxEditor)comboEditor);
        this.myTypeComboBox.setEditable(true);
        this.myTypeComboBox.grabFocus();
        this.addDataChangeListener();
        this.myTypeComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DynamicDialog.this.fireDataChanged();
            }
        });
        this.myPanel.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DynamicDialog.this.myTypeComboBox.requestFocus();
            }
        }, KeyStroke.getKeyStroke(84, 8), 2);
        EditorTextField editorTextField = (EditorTextField)this.myTypeComboBox.getEditor().getEditorComponent();
        editorTextField.addDocumentListener(new DocumentListener(){

            public void beforeDocumentChange(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                DynamicDialog.this.fireDataChanged();
            }
        });
        Object object = type = typeConstraints.length == 1 ? typeConstraints[0].getDefaultType() : TypesUtil.getJavaLangObject(this.myContext);
        if (type == null) {
            type = TypesUtil.getJavaLangObject(this.myContext);
        }
        this.myTypeComboBox.getEditor().setItem(this.createDocument(type.getCanonicalText()));
    }

    protected void addDataChangeListener() {
        this.myListenerList.add(DataChangedListener.class, new DataChangedListener());
    }

    protected void updateOkStatus() {
        GrTypeElement typeElement = this.getEnteredTypeName();
        if (typeElement == null) {
            this.setOKActionEnabled(false);
        } else {
            this.setOKActionEnabled(true);
        }
        this.setUpStatusLabel();
    }

    @Nullable
    public GrTypeElement getEnteredTypeName() {
        Document typeEditorDocument = this.getTypeEditorDocument();
        if (typeEditorDocument == null) {
            return null;
        }
        try {
            String typeText = typeEditorDocument.getText();
            return GroovyPsiElementFactory.getInstance(this.myProject).createTypeElement(typeText);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    @Nullable
    public Document getTypeEditorDocument() {
        Object item = this.myTypeComboBox.getEditor().getItem();
        return item instanceof Document ? (Document)item : null;
    }

    @Nullable
    public ContainingClassItem getEnteredContainingClass() {
        Object item = this.myClassComboBox.getSelectedItem();
        if (!(item instanceof ContainingClassItem)) {
            return null;
        }
        return (ContainingClassItem)item;
    }

    protected void fireDataChanged() {
        Object[] list;
        for (Object aList : list = this.myListenerList.getListenerList()) {
            if (!(aList instanceof DataChangedListener)) continue;
            ((DataChangedListener)aList).dataChanged();
        }
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected void doOKAction() {
        super.doOKAction();
        this.mySettings.setContainingClassName(this.getEnteredContainingClass().getContainingClass().getQualifiedName());
        this.mySettings.setStatic(this.myStaticCheckBox.isSelected());
        GrTypeElement typeElement = this.getEnteredTypeName();
        if (typeElement == null) {
            this.mySettings.setType("java.lang.Object");
        } else {
            String typeQualifiedName;
            PsiType type = typeElement.getType();
            if (type instanceof PsiPrimitiveType) {
                type = TypesUtil.boxPrimitiveType(type, typeElement.getManager(), ProjectScope.getAllScope((Project)this.myProject));
            }
            if ((typeQualifiedName = type.getCanonicalText()) != null) {
                this.mySettings.setType(typeQualifiedName);
            } else {
                this.mySettings.setType(type.getPresentableText());
            }
        }
        Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(this.myContext.getContainingFile());
        final DocumentReference[] refs = new DocumentReference[]{DocumentReferenceManager.getInstance().create(document)};
        CommandProcessor.getInstance().executeCommand(this.myProject, new Runnable(){

            @Override
            public void run() {
                UndoManager.getInstance((Project)DynamicDialog.this.myProject).undoableActionPerformed(new UndoableAction(){

                    public void undo() throws UnexpectedUndoException {
                        DItemElement itemElement;
                        if (DynamicDialog.this.mySettings.isMethod()) {
                            List<MyPair> myPairList = DynamicDialog.this.mySettings.getPairs();
                            String[] argumentsTypes = QuickfixUtil.getArgumentsTypes(myPairList);
                            itemElement = DynamicDialog.this.myDynamicManager.findConcreteDynamicMethod(DynamicDialog.this.mySettings.getContainingClassName(), DynamicDialog.this.mySettings.getName(), argumentsTypes);
                        } else {
                            itemElement = DynamicDialog.this.myDynamicManager.findConcreteDynamicProperty(DynamicDialog.this.mySettings.getContainingClassName(), DynamicDialog.this.mySettings.getName());
                        }
                        if (itemElement == null) {
                            Messages.showWarningDialog((Project)DynamicDialog.this.myProject, (String)GroovyInspectionBundle.message("Cannot.perform.undo.operation", new Object[0]), (String)GroovyInspectionBundle.message("Undo.disable", new Object[0]));
                            return;
                        }
                        DClassElement classElement = DynamicDialog.this.myDynamicManager.getClassElementByItem(itemElement);
                        if (classElement == null) {
                            Messages.showWarningDialog((Project)DynamicDialog.this.myProject, (String)GroovyInspectionBundle.message("Cannot.perform.undo.operation", new Object[0]), (String)GroovyInspectionBundle.message("Undo.disable", new Object[0]));
                            return;
                        }
                        DynamicDialog.this.removeElement(itemElement);
                        if (classElement.getMethods().size() == 0 && classElement.getProperties().size() == 0) {
                            DynamicDialog.this.myDynamicManager.removeClassElement(classElement);
                        }
                    }

                    public void redo() throws UnexpectedUndoException {
                        DynamicDialog.this.addElement(DynamicDialog.this.mySettings);
                    }

                    public DocumentReference[] getAffectedDocuments() {
                        return refs;
                    }

                    public boolean isGlobal() {
                        return true;
                    }
                });
                DynamicDialog.this.addElement(DynamicDialog.this.mySettings);
            }
        }, "Add dynamic element", null);
    }

    private void removeElement(DItemElement itemElement) {
        this.myDynamicManager.removeItemElement(itemElement);
        this.myDynamicManager.fireChange();
    }

    public void addElement(DynamicElementSettings settings) {
        if (settings.isMethod()) {
            this.myDynamicManager.addMethod(settings);
        } else {
            this.myDynamicManager.addProperty(settings);
        }
        this.myDynamicManager.fireChange();
    }

    public void doCancelAction() {
        super.doCancelAction();
        DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTypeComboBox;
    }

    protected boolean isTableVisible() {
        return false;
    }

    public JTable getParametersTable() {
        return this.myParametersTable;
    }

    protected static boolean isTypeCheckerPanelEnable() {
        return true;
    }

    public Project getProject() {
        return this.myProject;
    }

    protected void setUpTypeLabel(String typeLabelText) {
        this.myTypeLabel.setText(typeLabelText);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JTable jTable;
        JLabel jLabel;
        JLabel jLabel2;
        JPanel jPanel;
        JComboBox jComboBox;
        JLabel jLabel3;
        JLabel jLabel4;
        JComboBox jComboBox2;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(8, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myClassComboBox = jComboBox2 = new JComboBox();
        jPanel2.add(jComboBox2, new GridConstraints(1, 0, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myClassLabel = jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("org/jetbrains/plugins/groovy/intentions/GroovyIntentionsBundle").getString("dynamic.property.dialog.class"));
        jPanel2.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTypeLabel = jLabel3 = new JLabel();
        jLabel3.setText("type");
        jPanel2.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTypeComboBox = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(3, 0, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myTypeStatusPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(5, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myTypeStatusLabel = jLabel2 = new JLabel();
        jLabel2.setHorizontalTextPosition(2);
        ((Component)jLabel2).setEnabled(true);
        jLabel2.setText("");
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTableLabel = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel2.add((Component)jLabel, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myParametersTable = jTable = new JTable();
        jTable.setAutoResizeMode(4);
        ((Component)jTable).setBackground(UIManager.getColor("ArrowButton.background"));
        jTable.setShowVerticalLines(true);
        jTable.setShowHorizontalLines(true);
        ((Component)jTable).setEnabled(true);
        jPanel2.add((Component)jTable, new GridConstraints(7, 0, 1, 1, 0, 3, 6, 6, null, null, null));
        this.myStaticCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Static");
        jPanel2.add((Component)jCheckBox, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    static class ContainingClassItem {
        private final PsiClass myContainingClass;

        ContainingClassItem(PsiClass containingClass) {
            this.myContainingClass = containingClass;
        }

        public String toString() {
            return this.myContainingClass.getName();
        }

        public PsiClass getContainingClass() {
            return this.myContainingClass;
        }
    }

    class DataChangedListener
    implements EventListener {
        DataChangedListener() {
        }

        void dataChanged() {
            DynamicDialog.this.updateOkStatus();
        }
    }
}

