/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;

public class GroovyImportsTracker {
    private final Map<GroovyFile, Set<GrImportStatement>> myUsedImportStatements = new HashMap<GroovyFile, Set<GrImportStatement>>();
    private final Map<GroovyFile, Set<GrImportStatement>> myUnusedImportStatements = new HashMap<GroovyFile, Set<GrImportStatement>>();

    public synchronized void registerImportUsed(GrImportStatement importStatement) {
        if (importStatement.getParent() == null) {
            return;
        }
        PsiFile file = importStatement.getContainingFile();
        if (file == null || !(file instanceof GroovyFile)) {
            return;
        }
        GroovyFile groovyFile = (GroovyFile)file;
        Set<GrImportStatement> importInfos = this.myUsedImportStatements.get(groovyFile);
        if (importInfos == null) {
            importInfos = new HashSet<GrImportStatement>();
        }
        importInfos.add(importStatement);
        this.myUsedImportStatements.put(groovyFile, importInfos);
    }

    @NotNull
    public synchronized Set<GrImportStatement> getUnusedImportStatements(GroovyFile file) {
        Set<GrImportStatement> unused = this.myUnusedImportStatements.get(file);
        if (unused == null) {
            Set<GrImportStatement> used = this.myUsedImportStatements.get(file);
            unused = new HashSet<GrImportStatement>(Arrays.asList(file.getImportStatements()));
            if (used != null && used.size() > 0) {
                unused.removeAll(used);
            }
            this.myUnusedImportStatements.put(file, unused);
            this.myUsedImportStatements.remove(file);
        }
        Set<GrImportStatement> set = unused;
        if (set == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/GroovyImportsTracker.getUnusedImportStatements must not return null");
        }
        return set;
    }

    public static GroovyImportsTracker getInstance(Project project) {
        return (GroovyImportsTracker)ServiceManager.getService((Project)project, GroovyImportsTracker.class);
    }

    public synchronized void markFileAnnotated(GroovyFile file) {
        this.myUnusedImportStatements.remove(file);
    }
}

