/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.utils.EquivalenceChecker;
import org.jetbrains.plugins.groovy.codeInspection.utils.SideEffectChecker;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;

public class GroovyConditionalCanBeElvisInspection
extends BaseInspection {
    @NotNull
    public String getDisplayName() {
        if ("Conditional expression can be elvis" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/control/GroovyConditionalCanBeElvisInspection.getDisplayName must not return null");
        }
        return "Conditional expression can be elvis";
    }

    @NotNull
    public String getGroupDisplayName() {
        if ("Control Flow" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/control/GroovyConditionalCanBeElvisInspection.getGroupDisplayName must not return null");
        }
        return "Control Flow";
    }

    @Override
    public String buildErrorString(Object ... args) {
        return "Conditional expression can be elvis #loc";
    }

    @Override
    public GroovyFix buildFix(PsiElement location) {
        return new CollapseConditionalFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static boolean isEquality(GrBinaryExpression binaryCondition) {
        IElementType tokenType = binaryCondition.getOperationTokenType();
        return GroovyTokenTypes.mEQUAL == tokenType;
    }

    private static boolean isInequality(GrBinaryExpression binaryCondition) {
        IElementType tokenType = binaryCondition.getOperationTokenType();
        return GroovyTokenTypes.mNOT_EQUAL == tokenType;
    }

    private static GrExpression deparenthesizeExpression(GrExpression expression) {
        GrExpression expressionToTest = expression;
        while (expressionToTest instanceof GrParenthesizedExpression) {
            expressionToTest = ((GrParenthesizedExpression)expressionToTest).getOperand();
        }
        return expressionToTest;
    }

    private static boolean isNull(GrExpression expression) {
        return expression != null && "null".equals(expression.getText());
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitConditionalExpression(GrConditionalExpression expression) {
            super.visitConditionalExpression(expression);
            GrExpression condition = expression.getCondition();
            GrExpression thenBranch = expression.getThenBranch();
            GrExpression elseBranch = expression.getElseBranch();
            if (condition == null || thenBranch == null || elseBranch == null) {
                return;
            }
            if (SideEffectChecker.mayHaveSideEffects(condition)) {
                return;
            }
            if (!((condition = GroovyConditionalCanBeElvisInspection.deparenthesizeExpression(condition)) instanceof GrBinaryExpression)) {
                return;
            }
            GrBinaryExpression binaryCondition = (GrBinaryExpression)condition;
            if (GroovyConditionalCanBeElvisInspection.isInequality(binaryCondition)) {
                GrExpression lhs = binaryCondition.getLeftOperand();
                GrExpression rhs = binaryCondition.getRightOperand();
                if (GroovyConditionalCanBeElvisInspection.isNull(lhs) && EquivalenceChecker.expressionsAreEquivalent(rhs, thenBranch) || GroovyConditionalCanBeElvisInspection.isNull(rhs) && EquivalenceChecker.expressionsAreEquivalent(lhs, thenBranch)) {
                    this.registerError(expression);
                }
            } else if (GroovyConditionalCanBeElvisInspection.isEquality(binaryCondition)) {
                GrExpression lhs = binaryCondition.getLeftOperand();
                GrExpression rhs = binaryCondition.getRightOperand();
                if (GroovyConditionalCanBeElvisInspection.isNull(lhs) && EquivalenceChecker.expressionsAreEquivalent(rhs, elseBranch) || GroovyConditionalCanBeElvisInspection.isNull(rhs) && EquivalenceChecker.expressionsAreEquivalent(lhs, elseBranch)) {
                    this.registerError(expression);
                }
            }
        }
    }

    private static class CollapseConditionalFix
    extends GroovyFix {
        private CollapseConditionalFix() {
        }

        @NotNull
        public String getName() {
            if ("Replace with elvis" == null) {
                throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/control/GroovyConditionalCanBeElvisInspection$CollapseConditionalFix.getName must not return null");
            }
            return "Replace with elvis";
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            GrConditionalExpression expression = (GrConditionalExpression)descriptor.getPsiElement();
            GrExpression thenBranch = expression.getThenBranch();
            GrExpression elseBranch = expression.getElseBranch();
            GrBinaryExpression binaryCondition = (GrBinaryExpression)GroovyConditionalCanBeElvisInspection.deparenthesizeExpression(expression.getCondition());
            if (GroovyConditionalCanBeElvisInspection.isInequality(binaryCondition)) {
                CollapseConditionalFix.replaceExpression(expression, thenBranch.getText() + "?:" + elseBranch.getText());
            } else {
                CollapseConditionalFix.replaceExpression(expression, elseBranch.getText() + "?:" + thenBranch.getText());
            }
        }
    }
}

