/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.exception;

import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.exception.CatchParameterUsedVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrCatchClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;

public class GroovyUnusedCatchParameterInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Error handling" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/exception/GroovyUnusedCatchParameterInspection.getGroupDisplayName must not return null");
        }
        return "Error handling";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Unused catch parameter" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/exception/GroovyUnusedCatchParameterInspection.getDisplayName must not return null");
        }
        return "Unused catch parameter";
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "Unused catch parameter '#ref' #loc";
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitCatchClause(GrCatchClause catchClause) {
            super.visitCatchClause(catchClause);
            GrOpenBlock block = catchClause.getBody();
            if (block == null) {
                return;
            }
            GrParameter parameter = catchClause.getParameter();
            if (parameter == null) {
                return;
            }
            String name = parameter.getName();
            if ("ignore".equals(name) || "ignored".equals(name)) {
                return;
            }
            CatchParameterUsedVisitor visitor = new CatchParameterUsedVisitor(parameter);
            block.accept(visitor);
            if (!visitor.isUsed()) {
                this.registerVariableError(parameter);
            }
        }
    }
}

