/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.threading;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.utils.SingleCheckboxOptionsPanel;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrCondition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrPostfixExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;

public class GroovyWhileLoopSpinsOnFieldInspection
extends BaseInspection {
    public boolean ignoreNonEmtpyLoops = false;

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Threading issues" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/threading/GroovyWhileLoopSpinsOnFieldInspection.getGroupDisplayName must not return null");
        }
        return "Threading issues";
    }

    @NotNull
    public String getDisplayName() {
        if ("While loop spins on field" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/threading/GroovyWhileLoopSpinsOnFieldInspection.getDisplayName must not return null");
        }
        return "While loop spins on field";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        if ("<code>#ref</code> loop spins on field #loc" == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/codeInspection/threading/GroovyWhileLoopSpinsOnFieldInspection.buildErrorString must not return null");
        }
        return "<code>#ref</code> loop spins on field #loc";
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel("Only warn if loop is empty", this, "ignoreNonEmtpyLoops");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new WhileLoopSpinsOnFieldVisitor();
    }

    private static GrExpression deparenthesizeExpression(GrExpression expression) {
        GrExpression expressionToTest = expression;
        while (expressionToTest instanceof GrParenthesizedExpression) {
            expressionToTest = ((GrParenthesizedExpression)expressionToTest).getOperand();
        }
        return expressionToTest;
    }

    private class WhileLoopSpinsOnFieldVisitor
    extends BaseInspectionVisitor {
        private WhileLoopSpinsOnFieldVisitor() {
        }

        @Override
        public void visitWhileStatement(@NotNull GrWhileStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/codeInspection/threading/GroovyWhileLoopSpinsOnFieldInspection$WhileLoopSpinsOnFieldVisitor.visitWhileStatement must not be null");
            }
            super.visitWhileStatement(statement);
            GrStatement body = statement.getBody();
            if (GroovyWhileLoopSpinsOnFieldInspection.this.ignoreNonEmtpyLoops && !this.statementIsEmpty(body)) {
                return;
            }
            GrCondition condition = statement.getCondition();
            if (!(condition instanceof GrExpression)) {
                return;
            }
            if (!this.isSimpleFieldComparison((GrExpression)condition)) {
                return;
            }
            this.registerStatementError(statement, new Object[0]);
        }

        private boolean isSimpleFieldComparison(GrExpression condition) {
            if ((condition = GroovyWhileLoopSpinsOnFieldInspection.deparenthesizeExpression(condition)) == null) {
                return false;
            }
            if (this.isSimpleFieldAccess(condition)) {
                return true;
            }
            if (condition instanceof GrPostfixExpression) {
                GrPostfixExpression postfixExpression = (GrPostfixExpression)condition;
                GrExpression operand = postfixExpression.getOperand();
                return this.isSimpleFieldComparison(operand);
            }
            if (condition instanceof GrUnaryExpression) {
                GrUnaryExpression unaryExpression = (GrUnaryExpression)condition;
                GrExpression operand = unaryExpression.getOperand();
                return this.isSimpleFieldComparison(operand);
            }
            if (condition instanceof GrBinaryExpression) {
                GrBinaryExpression binaryExpression = (GrBinaryExpression)condition;
                GrExpression lOperand = binaryExpression.getLeftOperand();
                GrExpression rOperand = binaryExpression.getRightOperand();
                if (this.isLiteral(rOperand)) {
                    return this.isSimpleFieldComparison(lOperand);
                }
                if (this.isLiteral(lOperand)) {
                    return this.isSimpleFieldComparison(rOperand);
                }
                return false;
            }
            return false;
        }

        private boolean isLiteral(GrExpression expression) {
            if ((expression = GroovyWhileLoopSpinsOnFieldInspection.deparenthesizeExpression(expression)) == null) {
                return false;
            }
            return expression instanceof PsiLiteralExpression;
        }

        private boolean isSimpleFieldAccess(GrExpression expression) {
            if ((expression = GroovyWhileLoopSpinsOnFieldInspection.deparenthesizeExpression(expression)) == null) {
                return false;
            }
            if (!(expression instanceof GrReferenceExpression)) {
                return false;
            }
            GrReferenceExpression reference = (GrReferenceExpression)expression;
            GrExpression qualifierExpression = reference.getQualifierExpression();
            if (qualifierExpression != null) {
                return false;
            }
            PsiElement referent = reference.resolve();
            if (!(referent instanceof PsiField)) {
                return false;
            }
            PsiField field = (PsiField)referent;
            return !field.hasModifierProperty("volatile");
        }

        private boolean statementIsEmpty(GrStatement statement) {
            if (statement == null) {
                return false;
            }
            if (statement instanceof GrBlockStatement) {
                GrStatement[] codeBlockStatements;
                GrBlockStatement blockStatement = (GrBlockStatement)statement;
                GrOpenBlock codeBlock = blockStatement.getBlock();
                for (GrStatement codeBlockStatement : codeBlockStatements = codeBlock.getStatements()) {
                    if (this.statementIsEmpty(codeBlockStatement)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

