/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.AbstractClosureParameterEnhancer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.arithmetic.GrRangeExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrTupleType;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class ClosureParameterEnhancer
extends AbstractClosureParameterEnhancer {
    @Override
    @Nullable
    protected PsiType getClosureParameterType(GrClosableBlock closure, int index) {
        PsiElement parent = closure.getParent();
        if (!(parent instanceof GrMethodCallExpression)) {
            return null;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)closure.getProject()).getElementFactory();
        String methodName = ClosureParameterEnhancer.findMethodName((GrMethodCallExpression)parent);
        GrExpression expression = ((GrMethodCallExpression)parent).getInvokedExpression();
        if (!(expression instanceof GrReferenceExpression)) {
            return null;
        }
        GrExpression qualifier = ((GrReferenceExpression)expression).getQualifierExpression();
        if (qualifier == null) {
            return null;
        }
        PsiType type = qualifier.getType();
        if (type == null) {
            return null;
        }
        if ("each".equals(methodName) || "every".equals(methodName) || "collect".equals(methodName) || "find".equals(methodName) || "findAll".equals(methodName) || "findIndexOf".equals(methodName)) {
            PsiType res = ClosureParameterEnhancer.findTypeForCollection(qualifier, factory, closure);
            if (closure.getParameters().length <= 1 && res != null) {
                return res;
            }
            if (InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.Map")) {
                if (closure.getParameters().length <= 1) {
                    return ClosureParameterEnhancer.getEntryForMap(type, factory, closure);
                }
                if (closure.getParameters().length == 2) {
                    if (index == 0) {
                        return PsiUtil.substituteTypeParameter((PsiType)type, (String)"java.util.Map", (int)0, (boolean)true);
                    }
                    return PsiUtil.substituteTypeParameter((PsiType)type, (String)"java.util.Map", (int)1, (boolean)true);
                }
            }
        } else {
            if ("with".equals(methodName) && closure.getParameters().length <= 1) {
                return type;
            }
            PsiParameter[] paramCount = closure.getAllParameters();
            if ("eachWithIndex".equals(methodName)) {
                PsiType res = ClosureParameterEnhancer.findTypeForCollection(qualifier, factory, closure);
                if (closure.getParameters().length == 2 && res != null) {
                    if (index == 0) {
                        return res;
                    }
                    return factory.createTypeFromText("java.lang.Integer", (PsiElement)closure);
                }
                if (InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.Map")) {
                    if (paramCount.length == 2) {
                        if (index == 0) {
                            return ClosureParameterEnhancer.getEntryForMap(type, factory, closure);
                        }
                        return factory.createTypeFromText("java.lang.Integer", (PsiElement)closure);
                    }
                    if (paramCount.length == 3) {
                        if (index == 0) {
                            return PsiUtil.substituteTypeParameter((PsiType)type, (String)"java.util.Map", (int)0, (boolean)true);
                        }
                        if (index == 1) {
                            return PsiUtil.substituteTypeParameter((PsiType)type, (String)"java.util.Map", (int)1, (boolean)true);
                        }
                        return factory.createTypeFromText("java.lang.Integer", (PsiElement)closure);
                    }
                }
            } else if ("inject".equals(methodName) && paramCount.length == 2) {
                if (index == 0) {
                    return factory.createTypeFromText("java.lang.Object", (PsiElement)closure);
                }
                PsiType res = ClosureParameterEnhancer.findTypeForCollection(qualifier, factory, closure);
                if (res != null) {
                    return res;
                }
                if (InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.Map")) {
                    return ClosureParameterEnhancer.getEntryForMap(type, factory, closure);
                }
            }
        }
        return null;
    }

    @Nullable
    private static PsiType getEntryForMap(PsiType map, PsiElementFactory factory, PsiElement context) {
        PsiType key = PsiUtil.substituteTypeParameter((PsiType)map, (String)"java.util.Map", (int)0, (boolean)true);
        PsiType value = PsiUtil.substituteTypeParameter((PsiType)map, (String)"java.util.Map", (int)1, (boolean)true);
        if (key != null && key != PsiType.NULL && value != null && value != PsiType.NULL) {
            return factory.createTypeFromText("java.util.Map.Entry<" + key.getCanonicalText() + ", " + value.getCanonicalText() + ">", context);
        }
        return null;
    }

    @Nullable
    public static PsiType findTypeForCollection(GrExpression qualifier, PsiElementFactory factory, PsiElement context) {
        PsiType iterType = qualifier.getType();
        if (iterType == null) {
            return null;
        }
        if (iterType instanceof PsiArrayType) {
            return ((PsiArrayType)iterType).getComponentType();
        }
        if (iterType instanceof GrTupleType) {
            PsiType[] types = ((GrTupleType)iterType).getParameters();
            return types.length == 1 ? types[0] : null;
        }
        if (factory.createTypeFromText("groovy.lang.IntRange", context).isAssignableFrom(iterType)) {
            return factory.createTypeFromText("java.lang.Integer", context);
        }
        if (factory.createTypeFromText("groovy.lang.ObjectRange", context).isAssignableFrom(iterType)) {
            GrExpression element = qualifier;
            if ((element = ClosureParameterEnhancer.removeBrackets(element)) instanceof GrReferenceExpression) {
                GrReferenceExpression ref = (GrReferenceExpression)element;
                element = ClosureParameterEnhancer.removeBrackets(ref.resolve());
            }
            if (element instanceof GrRangeExpression) {
                return ClosureParameterEnhancer.getRangeElementType((GrRangeExpression)element);
            }
            return null;
        }
        PsiType res = PsiUtil.extractIterableTypeParameter((PsiType)iterType, (boolean)true);
        if (res != null) {
            return res;
        }
        if (iterType.equalsToText("java.lang.String") || iterType.equalsToText("java.io.File")) {
            return factory.createTypeFromText("java.lang.String", context);
        }
        return null;
    }

    private static PsiElement removeBrackets(PsiElement element) {
        while (element instanceof GrParenthesizedExpression) {
            element = ((GrParenthesizedExpression)element).getOperand();
        }
        return element;
    }

    @Nullable
    private static PsiType getRangeElementType(GrRangeExpression range) {
        GrExpression left = range.getLeftOperand();
        GrExpression right = range.getRightOperand();
        if (right != null) {
            PsiType leftType = left.getType();
            PsiType rightType = right.getType();
            if (leftType != null && rightType != null) {
                return TypesUtil.getLeastUpperBound(leftType, rightType, range.getManager());
            }
        }
        return null;
    }

    @Nullable
    private static String findMethodName(@NotNull GrMethodCallExpression methodCall) {
        if (methodCall == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/ClosureParameterEnhancer.findMethodName must not be null");
        }
        GrExpression expression = methodCall.getInvokedExpression();
        if (expression instanceof GrReferenceExpression) {
            return ((GrReferenceExpression)expression).getReferenceName();
        }
        return null;
    }
}

