/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.annotation;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiElementImpl;

public class GrAnnotationArgumentListImpl
extends GroovyPsiElementImpl
implements GrAnnotationArgumentList {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.annotation.GrAnnotationArgumentListImpl");

    public GrAnnotationArgumentListImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/annotation/GrAnnotationArgumentListImpl.<init> must not be null");
        }
        super(node);
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitAnnotationArgumentList(this);
    }

    public String toString() {
        return "Annotation arguments";
    }

    @NotNull
    public PsiNameValuePair[] getAttributes() {
        PsiNameValuePair[] psiNameValuePairArray = (PsiNameValuePair[])this.findChildrenByClass(PsiNameValuePair.class);
        if (psiNameValuePairArray == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/annotation/GrAnnotationArgumentListImpl.getAttributes must not return null");
        }
        return psiNameValuePairArray;
    }

    public ASTNode addInternal(ASTNode first, ASTNode last, ASTNode anchor, Boolean before) {
        if (first.getElementType() == GroovyElementTypes.ANNOTATION_MEMBER_VALUE_PAIR && last.getElementType() == GroovyElementTypes.ANNOTATION_MEMBER_VALUE_PAIR) {
            PsiNameValuePair pair;
            PsiNameValuePair[] nodes;
            ASTNode lparenth = this.getNode().getFirstChildNode();
            ASTNode rparenth = this.getNode().getLastChildNode();
            if (lparenth == null) {
                this.getNode().addLeaf(GroovyElementTypes.mLPAREN, (CharSequence)"(", null);
            }
            if (rparenth == null) {
                this.getNode().addLeaf(GroovyElementTypes.mRPAREN, (CharSequence)")", null);
            }
            if ((nodes = this.getAttributes()).length == 1 && (pair = nodes[0]).getName() == null) {
                String text = pair.getValue().getText();
                try {
                    GrAnnotation annotation = GroovyPsiElementFactory.getInstance(this.getProject()).createAnnotationFromText("@AAA(value = " + text + ")");
                    this.getNode().replaceChild(pair.getNode(), annotation.getParameterList().getAttributes()[0].getNode());
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
            if (anchor == null && before != null) {
                anchor = before != false ? this.getNode().getLastChildNode() : this.getNode().getFirstChildNode();
            }
        }
        return super.addInternal(first, last, anchor, before);
    }
}

