/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrCondition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiElementImpl;

public class GrWhileStatementImpl
extends GroovyPsiElementImpl
implements GrWhileStatement {
    public GrWhileStatementImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/plugins/groovy/lang/psi/impl/statements/GrWhileStatementImpl.<init> must not be null");
        }
        super(node);
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitWhileStatement(this);
    }

    public String toString() {
        return "WHILE statement";
    }

    @Override
    public GrCondition getCondition() {
        PsiElement lParenth = this.getLParenth();
        if (lParenth == null) {
            return null;
        }
        PsiElement afterLParen = lParenth.getNextSibling();
        if (afterLParen instanceof GrCondition) {
            return (GrCondition)afterLParen;
        }
        return null;
    }

    @Override
    public GrStatement getBody() {
        GrStatement[] statements = (GrStatement[])this.findChildrenByClass(GrStatement.class);
        if (this.getCondition() == null && statements.length > 0) {
            return statements[0];
        }
        if (statements.length > 1 && statements[1] instanceof GrStatement) {
            return statements[1];
        }
        return null;
    }

    @Override
    public GrCondition replaceBody(GrCondition newBody) throws IncorrectOperationException {
        if (this.getBody() == null || newBody == null) {
            throw new IncorrectOperationException();
        }
        ASTNode oldBodyNode = this.getBody().getNode();
        if (oldBodyNode.getTreePrev() != null && GroovyTokenTypes.mNLS.equals(oldBodyNode.getTreePrev().getElementType())) {
            ASTNode whiteNode = GroovyPsiElementFactory.getInstance(this.getProject()).createWhiteSpace().getNode();
            this.getNode().replaceChild(oldBodyNode.getTreePrev(), whiteNode);
        }
        this.getNode().replaceChild(oldBodyNode, newBody.getNode());
        ASTNode newNode = newBody.getNode();
        if (!(newNode.getPsi() instanceof GrCondition)) {
            throw new IncorrectOperationException();
        }
        return (GrCondition)newNode.getPsi();
    }

    @Override
    public PsiElement getRParenth() {
        return this.findChildByType(GroovyTokenTypes.mRPAREN);
    }

    @Override
    public PsiElement getLParenth() {
        return this.findChildByType(GroovyTokenTypes.mLPAREN);
    }
}

