/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.Location;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitConfigurationProducer;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;

public class TestClassConfigurationProducer
extends JUnitConfigurationProducer {
    private PsiClass myTestClass;

    protected RunnerAndConfigurationSettingsImpl createConfigurationByElement(Location location, ConfigurationContext context) {
        location = JavaExecutionUtil.stepIntoSingleClass((Location)location);
        Project project = location.getProject();
        this.myTestClass = JUnitUtil.getTestClass((Location)location);
        if (this.myTestClass == null) {
            return null;
        }
        RunnerAndConfigurationSettingsImpl settings = this.cloneTemplateConfiguration(project, context);
        JUnitConfiguration configuration = (JUnitConfiguration)settings.getConfiguration();
        this.setupConfigurationModule(context, configuration);
        Module originalModule = ((JavaRunConfigurationModule)configuration.getConfigurationModule()).getModule();
        configuration.beClassConfiguration(this.myTestClass);
        configuration.restoreOriginalModule(originalModule);
        RunConfigurationExtension.patchCreatedConfiguration((ModuleBasedConfiguration)configuration);
        this.copyStepsBeforeRun(project, (RunConfiguration)configuration);
        return settings;
    }

    public PsiElement getSourceElement() {
        return this.myTestClass;
    }
}

