/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.generate.tostring;

import com.intellij.codeInsight.generation.PsiElementClassMember;
import com.intellij.codeInsight.generation.PsiFieldMember;
import com.intellij.codeInsight.generation.PsiMethodMember;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.generate.tostring.config.FilterPattern;
import org.jetbrains.generate.tostring.element.ElementFactory;
import org.jetbrains.generate.tostring.element.FieldElement;
import org.jetbrains.generate.tostring.element.MethodElement;
import org.jetbrains.generate.tostring.exception.GenerateCodeException;
import org.jetbrains.generate.tostring.exception.PluginException;
import org.jetbrains.generate.tostring.psi.PsiAdapter;
import org.jetbrains.generate.tostring.psi.PsiAdapterFactory;
import org.jetbrains.generate.tostring.util.FileUtil;

public class GenerateToStringUtils {
    private static final Logger log = Logger.getInstance((String)"#org.jetbrains.generate.tostring.GenerateToStringUtils");

    private GenerateToStringUtils() {
    }

    public static PsiField[] filterAvailableFields(Project project, PsiAdapter psi, PsiClass clazz, FilterPattern pattern) {
        PsiField[] fields;
        if (log.isDebugEnabled()) {
            log.debug("Filtering fields using the pattern: " + pattern);
        }
        ArrayList<PsiField> availableFields = new ArrayList<PsiField>();
        for (PsiField field : fields = clazz.getFields()) {
            FieldElement fe = ElementFactory.newFieldElement(project, field, psi);
            if (log.isDebugEnabled()) {
                log.debug("Field being filtered: " + fe);
            }
            if (fe.applyFilter(pattern)) continue;
            availableFields.add(field);
        }
        return availableFields.toArray(new PsiField[availableFields.size()]);
    }

    public static PsiMethod[] filterAvailableMethods(PsiAdapter psi, PsiClass clazz, FilterPattern pattern) {
        PsiMethod[] methods;
        if (log.isDebugEnabled()) {
            log.debug("Filtering methods using the pattern: " + pattern);
        }
        ArrayList<PsiMethod> availableMethods = new ArrayList<PsiMethod>();
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)clazz.getProject()).getElementFactory();
        for (PsiMethod method : methods = clazz.getMethods()) {
            MethodElement me = ElementFactory.newMethodElement(method, elementFactory, psi);
            if (log.isDebugEnabled()) {
                log.debug("Method being filtered: " + me);
            }
            if (!me.isGetter() || me.isReturnTypeVoid() || !me.isModifierPublic() || me.isModifierStatic() || me.isModifierAbstract() || psi.findFieldByName(clazz, me.getFieldName()) != null || "toString".equals(me.getMethodName()) || "getClass".equals(me.getMethodName()) || me.applyFilter(pattern)) continue;
            if (log.isDebugEnabled()) {
                log.debug("Adding the method " + method.getName() + " as there is not a field for this getter");
            }
            availableMethods.add(method);
        }
        return availableMethods.toArray(new PsiMethod[availableMethods.size()]);
    }

    @Nullable
    public static Editor getEditor(Project project) {
        Editor[] editors;
        for (Editor ed : editors = EditorFactory.getInstance().getAllEditors()) {
            if (project != ed.getProject()) continue;
            return ed;
        }
        return null;
    }

    public static void handleExeption(Project project, Exception e) throws RuntimeException {
        e.printStackTrace();
        log.error((Throwable)e);
        if (e instanceof GenerateCodeException) {
            Messages.showMessageDialog((Project)project, (String)("Velocity error generating code - see IDEA log for more details (stacktrace should be in idea.log):\n" + e.getMessage()), (String)"Warning", (Icon)Messages.getWarningIcon());
        } else if (e instanceof PluginException) {
            Messages.showMessageDialog((Project)project, (String)("A PluginException was thrown while performing the action - see IDEA log for details (stacktrace should be in idea.log):\n" + e.getMessage()), (String)"Warning", (Icon)Messages.getWarningIcon());
        } else {
            if (e instanceof RuntimeException) {
                Messages.showMessageDialog((Project)project, (String)("An unrecoverable exception was thrown while performing the action - see IDEA log for details (stacktrace should be in idea.log):\n" + e.getMessage()), (String)"Error", (Icon)Messages.getErrorIcon());
                throw (RuntimeException)e;
            }
            Messages.showMessageDialog((Project)project, (String)("An unrecoverable exception was thrown while performing the action - see IDEA log for details (stacktrace should be in idea.log):\n" + e.getMessage()), (String)"Error", (Icon)Messages.getErrorIcon());
            throw new RuntimeException(e);
        }
    }

    public static PsiMember[] combineToMemberList(PsiField[] filteredFields, PsiMethod[] filteredMethods) {
        int i;
        PsiMember[] members = new PsiMember[filteredFields.length + filteredMethods.length];
        for (i = 0; i < filteredFields.length; ++i) {
            members[i] = filteredFields[i];
        }
        for (i = 0; i < filteredMethods.length; ++i) {
            members[filteredFields.length + i] = filteredMethods[i];
        }
        return members;
    }

    public static PsiElementClassMember[] combineToClassMemberList(PsiField[] filteredFields, PsiMethod[] filteredMethods) {
        int i;
        PsiElementClassMember[] members = new PsiElementClassMember[filteredFields.length + filteredMethods.length];
        for (i = 0; i < filteredFields.length; ++i) {
            members[i] = new PsiFieldMember(filteredFields[i]);
        }
        for (i = 0; i < filteredMethods.length; ++i) {
            members[filteredFields.length + i] = new PsiMethodMember(filteredMethods[i]);
        }
        return members;
    }

    public static List<PsiMember> convertClassMembersToPsiMembers(List<PsiElementClassMember> classMemberList) {
        ArrayList<PsiMember> psiMemberList = new ArrayList<PsiMember>();
        for (PsiElementClassMember classMember : classMemberList) {
            psiMemberList.add((PsiMember)classMember.getElement());
        }
        return psiMemberList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractDocumentation() throws IOException {
        log.debug("Extracting documentation +++ START +++");
        PsiAdapter psi = PsiAdapterFactory.getPsiAdapter();
        String inf = psi.getPluginFilename();
        if (inf == null) {
            log.warn("Could not find GenerateToString.jar file - documenation disabled");
            return;
        }
        String outf = GenerateToStringUtils.getDocumentationFilename();
        JarFile jar = null;
        InputStream in = null;
        BufferedInputStream bin = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug("Reading jar file: " + inf);
            }
            jar = new JarFile(inf);
            ZipEntry entry = jar.getEntry("generate/tostring/package.html");
            if (log.isDebugEnabled()) {
                log.debug("Got zipentry: " + entry.getName());
            }
            in = jar.getInputStream(entry);
            bin = new BufferedInputStream(in);
            if (log.isDebugEnabled()) {
                log.debug("Reading content of zipentry");
            }
            String doc = FileUtil.readFileContent(bin);
            if (log.isDebugEnabled()) {
                log.debug("Saving content to destinationfile: " + outf);
            }
            FileUtil.saveFile(outf, doc);
            if (log.isDebugEnabled()) {
                log.debug("Save succesfull");
            }
        }
        catch (IOException e) {
            log.warn("IO error while extracting plugin documentation - documentation disabled. Filename = '" + inf + "'", (Throwable)e);
            return;
        }
        finally {
            try {
                if (bin != null) {
                    bin.close();
                }
                if (in != null) {
                    in.close();
                }
                if (jar != null) {
                    jar.close();
                }
            }
            catch (IOException e) {
                log.debug("Ignoring IOException while closing resources", (Throwable)e);
            }
        }
        log.debug("Extracting documentation +++ END +++");
    }

    public static String getDocumentationFilename() {
        return PathManager.getPluginsPath() + File.separatorChar + "GenerateToString-doc.html";
    }
}

