/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.NestedCopyType;
import org.jetbrains.idea.svn.StatusReceiver;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class NestedCopiesBuilder
implements StatusReceiver {
    private final Set<MyPointInfo> mySet = new HashSet<MyPointInfo>();

    @Override
    public void process(FilePath path, SVNStatus status, boolean isInnerCopyRoot) throws SVNException {
        NestedCopyType type;
        if (path.getVirtualFile() != null && SVNStatusType.STATUS_EXTERNAL.equals(status.getContentsStatus())) {
            MyPointInfo info = new MyPointInfo(path.getVirtualFile(), null, WorkingCopyFormat.UNKNOWN, NestedCopyType.external);
            this.mySet.add(info);
            return;
        }
        if (path.getVirtualFile() == null || status.getURL() == null) {
            return;
        }
        SVNStatusType contentsStatus = status.getContentsStatus();
        if (SVNStatusType.STATUS_UNVERSIONED.equals(contentsStatus)) {
            return;
        }
        if (status.isSwitched()) {
            type = NestedCopyType.switched;
        } else if (isInnerCopyRoot) {
            type = NestedCopyType.inner;
        } else {
            return;
        }
        MyPointInfo info = new MyPointInfo(path.getVirtualFile(), status.getURL(), WorkingCopyFormat.getInstance(status.getWorkingCopyFormat()), type);
        this.mySet.add(info);
    }

    @Override
    public void processIgnored(VirtualFile vFile) {
    }

    @Override
    public void processUnversioned(VirtualFile vFile) {
    }

    public Set<MyPointInfo> getSet() {
        return this.mySet;
    }

    static class MyPointInfo {
        private final VirtualFile myFile;
        private SVNURL myUrl;
        private WorkingCopyFormat myFormat;
        private final NestedCopyType myType;

        MyPointInfo(@NotNull VirtualFile file, SVNURL url, WorkingCopyFormat format, NestedCopyType type) {
            if (file == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of org/jetbrains/idea/svn/NestedCopiesBuilder$MyPointInfo.<init> must not be null");
            }
            this.myFile = file;
            this.myUrl = url;
            this.myFormat = format;
            this.myType = type;
        }

        public void setUrl(SVNURL url) {
            this.myUrl = url;
        }

        public void setFormat(WorkingCopyFormat format) {
            this.myFormat = format;
        }

        public VirtualFile getFile() {
            return this.myFile;
        }

        public SVNURL getUrl() {
            return this.myUrl;
        }

        public WorkingCopyFormat getFormat() {
            return this.myFormat;
        }

        public NestedCopyType getType() {
            return this.myType;
        }

        private String key(VirtualFile file) {
            return file.getPath();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyPointInfo info = (MyPointInfo)o;
            return this.key(this.myFile).equals(this.key(info.myFile));
        }

        public int hashCode() {
            return this.key(this.myFile).hashCode();
        }
    }
}

